/*
Copyright 2008-2009 Elöd Egyed-Zsigmond, Cyril Laitang
Copyright 2009-2011 Samuel Gesche

This file is part of IPRI News Analyzer.

IPRI News Analyzer is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

IPRI News Analyzer is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with IPRI News Analyzer.  If not, see <http://www.gnu.org/licenses/>.
*/

package ihm.iprinewsanalyzer;

import data.base.Config;
import data.base.Database;
import data.base.NoBaseException;
import data.base.connectors.DBPediaDatabase;
import data.base.connectors.CorpusDatabase;
import data.base.connectors.ThesaurusDatabase;
import data.base.connectors.RSSFeedDatabase;
import data.base.connectors.StatsDatabase;
import data.base.connectors.ManagementDatabase;

import data.structures.analyse.CorpusAnalyse;
import data.structures.analyse.SacArticles;
import data.structures.analyse.Article;
import data.structures.analyse.SousCorpus;
import data.structures.base.Source;
import data.structures.base.Flux;
import data.structures.corpus.ClusteringCorpusGraph;
import data.structures.corpus.CorpusGraph;
import data.structures.corpus.CorpusItem;
import data.structures.rss.SujetBrut;
import data.structures.rss.SujetTraite;
import data.structures.rss.Tag;
import data.structures.rss.RSSItem;
import data.structures.rss.RSSItemCount;
import data.structures.rss.RSSFeedInfoExtended;
import data.structures.tagging.LemmaItem;
import data.structures.thema.ThemaGraph;
import data.structures.thema.ThemaItem;

import proc.rss.RSSSaver;
import proc.rss.NewsSaver;
import proc.rss.Collecteur;
import proc.rss.CollecteurSujets;
import proc.text.Codecs;
import proc.text.Out;
import proc.thema.ThemaIdentifier;

import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.Timer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.IOException;
import java.io.Reader;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

import java.text.ParseException;
import java.text.SimpleDateFormat;

import org.apache.commons.lang.StringUtils;

/**
 *
 * @author sgesche
 */
public class FenetrePrincipale extends JFrame {

    private Database baseIPRI = new Database();
    private TableCorpus tableCorpus;
    private TableExperiences tableExperiences;
    private TableExperiences2 tableExperiences2;
    private PanelFlux panelFluxCollecte;
    private PanelFlux panelFluxAnalyse;

    /** Creates new form FenetrePrincipale */
    public FenetrePrincipale(boolean corpus, boolean collecte, boolean experiences, boolean analyse) {
        initComponents();
        formatAll();
        Out.setBufferSize(1000);
        Out.setInfoComponent(tjInfos);
        Out.setErreurComponent(tjErreurs);


        // Les panneaux 'expériences' et 'sparql' sont laissés invisibles
        // au cas où l'on en aurait besoin
        tpExperiences.remove(peExperiencesOld);
        tpExperiences.remove(peSparql);
        tpPrincipal.remove(tpExperiences);
        // Idem pour les panneaux d'analyse qui permettent simplement
        // de contrôler ce qui est trouvé
        tpAnalyse.remove(pasSujets);
        tpAnalyse.remove(pasSujets2);
        tpAnalyse.remove(pasURLs);

        if (!corpus) {
            tpPrincipal.remove(tpCorpus);
        }
        if (!collecte) {
            tpPrincipal.remove(tpCollecte);
        }
        if (!experiences) {
            tpPrincipal.remove(tpExperiences);
        }
        if (!analyse) {
            tpPrincipal.remove(tpAnalyse);
        }
        if(corpus){
            chargerTags();
            chargerSources();
            chargerFlux();
        }
        if (experiences) {
            tableCorpus = new TableCorpus(this, 200, getTopThematiques());
            speCorpus.setViewportView(tableCorpus);
        }
        if (experiences) {
            proc.thema.Experiences.setBase(baseIPRI);
            tableExperiences = new TableExperiences(tableCorpus);
            speExperiences.setViewportView(tableExperiences);
            completeExperiences();
        }
        if (experiences) {
            proc.cluster.Experiences.setBase(baseIPRI);
            tableExperiences2 = new TableExperiences2();
            speExperiences2.setViewportView(tableExperiences2);
            completeExperiences2();
        }
        if (collecte) {
            initCollecteFlux();
            initCollecteSujets();
        }
        if (collecte) {
            panelFluxCollecte = new PanelFlux(this, baseIPRI);
            pcSelection.add(panelFluxCollecte);
            changeTag();
        }
        if (analyse) {
            panelFluxAnalyse = new PanelFlux(this, baseIPRI);
            paseFlux2.add(panelFluxAnalyse);
        }
        setSize(Toolkit.getDefaultToolkit().getScreenSize());
        setVisible(true);

        if (collecte) {
            timerCollecteFlux.start();
        }
        if (experiences) {
            teThesaurus.setModel(new DefaultTreeModel(
                    new DefaultMutableTreeNode("Taxonomie IPTC")));
        }
        initStats();
        timerStatsMemoire.start();
        if (experiences) {
            afficheArbreIPTC();
        }
        if (analyse) {
            initFenetreTemporelleAnalyseSynchronique();
        }
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        buttonGroup1 = new javax.swing.ButtonGroup();
        jLabel6 = new javax.swing.JLabel();
        tpPrincipal = new javax.swing.JTabbedPane();
        tpStats = new javax.swing.JTabbedPane();
        pJournal = new javax.swing.JPanel();
        pjMenu = new javax.swing.JPanel();
        tjNbLignes = new javax.swing.JFormattedTextField();
        jLabel5 = new javax.swing.JLabel();
        pJAffichage = new javax.swing.JPanel();
        spjInfos = new javax.swing.JScrollPane();
        tjInfos = new javax.swing.JTextArea();
        spjErreurs = new javax.swing.JScrollPane();
        tjErreurs = new javax.swing.JTextArea();
        pjMemoire = new javax.swing.JPanel();
        ljmGraphe = new JLabel(){
            public void paint(Graphics g){
                g.setColor(Charte.getBackground());
                g.fillRect(0,0,getWidth(), getHeight());
                g.setColor(Charte.getForeground());
                g.drawRect(0,0,getWidth()-1, getHeight()-1);
                int max = (int)(Math.min(Runtime.getRuntime().maxMemory(), (long)(Integer.MAX_VALUE)));
                for(int i=1; i<memMin.size(); i++){
                    int curm0 = memMin.elementAt(i-1).intValue();
                    int curm = memMin.elementAt(i).intValue();
                    g.setColor(Color.GREEN.darker());
                    g.drawLine(getWidth()-1-memMin.size()+(i-1), getHeight()-(int)(1.0*getHeight()*curm0/max), 
                        getWidth()-1-memMin.size()+i, getHeight()-(int)(1.0*getHeight()*curm/max));
                    int curM0 = memMax.elementAt(i-1).intValue();
                    int curM = memMax.elementAt(i).intValue();
                    g.setColor(Color.RED.darker());
                    g.drawLine(getWidth()-1-memMin.size()+(i-1), getHeight()-(int)(1.0*getHeight()*curM0/max), 
                        getWidth()-1-memMin.size()+i, getHeight()-(int)(1.0*getHeight()*curM/max));
                }
                g.setColor(Charte.getForeground());
                for(int i=getWidth(); i>=0; i-=60){
                    g.drawLine(i, getHeight(), 
                        i, 0);
                }
            }
        };
        ljmActu = new javax.swing.JLabel();
        ljInfoCollecte = new javax.swing.JLabel();
        psBaseDonnees = new javax.swing.JPanel();
        psbMenu = new javax.swing.JPanel();
        lsbEtat = new javax.swing.JLabel();
        bsbEtat = new javax.swing.JButton();
        psbContenu = new javax.swing.JPanel();
        psbContenu1 = new javax.swing.JPanel();
        lsbTotal = new javax.swing.JLabel();
        psbContenu10 = new javax.swing.JPanel();
        psbContenu11 = new javax.swing.JPanel();
        lsbJour = new javax.swing.JLabel();
        spsbJour = new javax.swing.JScrollPane();
        lsbJour2 = new javax.swing.JList();
        psbContenu12 = new javax.swing.JPanel();
        lsbHeure = new javax.swing.JLabel();
        spsbHeure = new javax.swing.JScrollPane();
        lsbHeure2 = new javax.swing.JList();
        lsbGrapheHeure = new JLabel(){
            public void paint(Graphics g){
                g.setColor(Charte.getBackground());
                g.fillRect(0,0,getWidth(), getHeight());
                GregorianCalendar c = new GregorianCalendar();
                c.setTimeInMillis(System.currentTimeMillis());
                int heureCourante = c.get(c.HOUR_OF_DAY);
                int minuteCourante = c.get(c.MINUTE);
                g.setColor(Charte.getSelectionBackground());
                g.fillRect(0,0,getWidth()/24*heureCourante+getWidth()*heureCourante/1440+getWidth()/24, getHeight());
                g.setColor(Charte.getForeground());
                g.drawString(0+"h", getWidth()/24*0, getHeight()-(int)(getHeight()/15*nbDepechesParHeure[0]) - 20);
                g.drawString(6+"h", getWidth()/24*6, getHeight()-(int)(getHeight()/15*nbDepechesParHeure[6]) - 20);
                g.drawString(12+"h", getWidth()/24*12, getHeight()-(int)(getHeight()/15*nbDepechesParHeure[12]) - 20);
                g.drawString(18+"h", getWidth()/24*18, getHeight()-(int)(getHeight()/15*nbDepechesParHeure[18]) - 20);
                g.drawString(0+"h", getWidth()/24*24, getHeight()-(int)(getHeight()/15*nbDepechesParHeure[0]) - 20);
                g.drawLine(getWidth()/24*0+getWidth()/48, getHeight(), 
                    getWidth()/24*0+getWidth()/48, getHeight()-(int)(getHeight()/15*nbDepechesParHeure[0]));
                for(int i=1; i<nbDepechesParHeure.length; i++){
                    double qt0 = nbDepechesParHeure[i-1];
                    double qt1 = nbDepechesParHeure[i];
                    //15% = la hauteur totale
                    g.drawLine(getWidth()/24*i+getWidth()/48, getHeight(), 
                        getWidth()/24*i+getWidth()/48, getHeight()-(int)(getHeight()/15*qt1));
                    g.drawLine(getWidth()/24*(i-1)+getWidth()/48, getHeight()-(int)(getHeight()/15*qt0), 
                        getWidth()/24*i+getWidth()/48, getHeight()-(int)(getHeight()/15*qt1));
                }
                g.drawLine(getWidth()/24*24+getWidth()/48, getHeight(), 
                    getWidth()/24*24+getWidth()/48, getHeight()-(int)(getHeight()/15*nbDepechesParHeure[0]));
                g.drawLine(getWidth()/24*23+getWidth()/48, getHeight()-(int)(getHeight()/15*nbDepechesParHeure[23]), 
                    getWidth()/24*24+getWidth()/48, getHeight()-(int)(getHeight()/15*nbDepechesParHeure[0]));
            }
        };
        psbContenu2 = new javax.swing.JPanel();
        lsbFlux = new javax.swing.JLabel();
        spsbFlux = new javax.swing.JScrollPane();
        lsbFlux2 = new javax.swing.JList();
        psRecherche = new javax.swing.JPanel();
        psRecherche2 = new javax.swing.JPanel();
        tsrRecherche = new javax.swing.JTextField();
        bsrRecherche = new javax.swing.JButton();
        lsrRecherche = new javax.swing.JLabel();
        jScrollPane1 = new javax.swing.JScrollPane();
        tsrResultat = new javax.swing.JTree();
        tpCorpus = new javax.swing.JTabbedPane();
        pTags = new javax.swing.JPanel();
        sptListe = new javax.swing.JScrollPane();
        ltListe = new javax.swing.JList();
        ptGestion = new javax.swing.JPanel();
        jLabel54 = new javax.swing.JLabel();
        ptGestion2 = new javax.swing.JPanel();
        ptGestion3 = new javax.swing.JPanel();
        ptgNouveau = new javax.swing.JPanel();
        jLabel57 = new javax.swing.JLabel();
        jLabel59 = new javax.swing.JLabel();
        ttgnNom = new javax.swing.JTextField();
        jLabel60 = new javax.swing.JLabel();
        ttgnNo = new javax.swing.JFormattedTextField();
        btgnAjouter = new javax.swing.JButton();
        ptgExistant = new javax.swing.JPanel();
        jLabel55 = new javax.swing.JLabel();
        jLabel58 = new javax.swing.JLabel();
        ttgeNom = new javax.swing.JTextField();
        jLabel56 = new javax.swing.JLabel();
        ttgeNo = new javax.swing.JFormattedTextField();
        btgeModifier = new javax.swing.JButton();
        btgeSupprimer = new javax.swing.JButton();
        jPanel12 = new javax.swing.JPanel();
        jLabel77 = new javax.swing.JLabel();
        pSources = new javax.swing.JPanel();
        spsListe = new javax.swing.JScrollPane();
        lsListe = new javax.swing.JList();
        psGestion = new javax.swing.JPanel();
        psGestion2 = new javax.swing.JPanel();
        psGestion25 = new javax.swing.JPanel();
        jLabel64 = new javax.swing.JLabel();
        psGestion26 = new javax.swing.JPanel();
        psGestion261 = new javax.swing.JPanel();
        jLabel65 = new javax.swing.JLabel();
        tsgnNom = new javax.swing.JTextField();
        psGestion27 = new javax.swing.JPanel();
        psGestion271 = new javax.swing.JPanel();
        jLabel66 = new javax.swing.JLabel();
        tsgnHomepage = new javax.swing.JTextField();
        psGestion28 = new javax.swing.JPanel();
        bsgnAjouter = new javax.swing.JButton();
        psGestion21 = new javax.swing.JPanel();
        jLabel61 = new javax.swing.JLabel();
        psGestion22 = new javax.swing.JPanel();
        psGestion221 = new javax.swing.JPanel();
        jLabel62 = new javax.swing.JLabel();
        tsgeNom = new javax.swing.JTextField();
        psGestion23 = new javax.swing.JPanel();
        psGestion231 = new javax.swing.JPanel();
        jLabel63 = new javax.swing.JLabel();
        tsgeHomepage = new javax.swing.JTextField();
        psGestion24 = new javax.swing.JPanel();
        bsgeModifier = new javax.swing.JButton();
        bsgeSupprimer = new javax.swing.JButton();
        psGestion29 = new javax.swing.JPanel();
        jLabel78 = new javax.swing.JLabel();
        pFlux = new javax.swing.JPanel();
        pfListes = new javax.swing.JPanel();
        spfListe = new javax.swing.JScrollPane();
        lfListe = new javax.swing.JList();
        pfGestion = new javax.swing.JPanel();
        pfGestion2 = new javax.swing.JPanel();
        pfGestion21 = new javax.swing.JPanel();
        jLabel69 = new javax.swing.JLabel();
        pfGestion22 = new javax.swing.JPanel();
        jLabel70 = new javax.swing.JLabel();
        tfgnNom = new javax.swing.JTextField();
        pfGestion23 = new javax.swing.JPanel();
        jLabel71 = new javax.swing.JLabel();
        tfgnUrl = new javax.swing.JTextField();
        pfGestion24 = new javax.swing.JPanel();
        jLabel72 = new javax.swing.JLabel();
        cbfgnSource = new javax.swing.JComboBox();
        pfGestion25 = new javax.swing.JPanel();
        bfgnAjouter = new javax.swing.JButton();
        pfGestion26 = new javax.swing.JPanel();
        jLabel73 = new javax.swing.JLabel();
        pfGestion27 = new javax.swing.JPanel();
        jLabel74 = new javax.swing.JLabel();
        tfgeNom = new javax.swing.JTextField();
        pfGestion28 = new javax.swing.JPanel();
        jLabel75 = new javax.swing.JLabel();
        tfgeUrl = new javax.swing.JTextField();
        pfGestion29 = new javax.swing.JPanel();
        jLabel76 = new javax.swing.JLabel();
        cbfgeSource = new javax.swing.JComboBox();
        pfGestion210 = new javax.swing.JPanel();
        bfgeModifier = new javax.swing.JButton();
        bfgeSupprimer = new javax.swing.JButton();
        pfGestion211 = new javax.swing.JPanel();
        jLabel79 = new javax.swing.JLabel();
        pfGestion212 = new javax.swing.JPanel();
        jLabel80 = new javax.swing.JLabel();
        cbfgeTag = new javax.swing.JComboBox();
        bfgeAjouterTag = new javax.swing.JButton();
        pfGestion3 = new javax.swing.JPanel();
        jLabel81 = new javax.swing.JLabel();
        bfgeSupprimerTag = new javax.swing.JButton();
        spfTags = new javax.swing.JScrollPane();
        lfTags = new javax.swing.JList();
        tpCollecte = new javax.swing.JTabbedPane();
        pSousCorpus = new javax.swing.JPanel();
        pcLancement = new javax.swing.JPanel();
        pcLancementArticles = new javax.swing.JPanel();
        jLabel7 = new javax.swing.JLabel();
        pcLancementArticles2 = new javax.swing.JPanel();
        bcCollecte = new javax.swing.JToggleButton();
        bcLemmatisation = new javax.swing.JToggleButton();
        bcLemmatisation2 = new javax.swing.JToggleButton();
        bcCapture = new javax.swing.JToggleButton();
        lcNbFlux = new javax.swing.JLabel();
        pcLancementSujets = new javax.swing.JPanel();
        jLabel25 = new javax.swing.JLabel();
        pcLancementSujets2 = new javax.swing.JPanel();
        bcCollecteSujets = new javax.swing.JToggleButton();
        pcTempsReel = new javax.swing.JPanel();
        jLabel28 = new javax.swing.JLabel();
        pcTempsReel2 = new javax.swing.JPanel();
        tcDelaiCollecte = new javax.swing.JFormattedTextField();
        jLabel38 = new javax.swing.JLabel();
        pcDiffere = new javax.swing.JPanel();
        jLabel26 = new javax.swing.JLabel();
        pcDiffere2 = new javax.swing.JPanel();
        bcToutCorpus = new javax.swing.JToggleButton();
        bcCorpusPartiel = new javax.swing.JToggleButton();
        bcCorpusJour = new javax.swing.JToggleButton();
        tcCorpusPartielDate = new javax.swing.JFormattedTextField();
        pcSelection = new javax.swing.JPanel();
        pCollecte = new javax.swing.JPanel();
        lcEtat2 = new javax.swing.JLabel();
        pcProcess = new javax.swing.JPanel();
        lcEtat = new javax.swing.JLabel();
        pcProcess2 = new javax.swing.JPanel();
        lcLemmatisation = new javax.swing.JLabel();
        lcCapture = new javax.swing.JLabel();
        pCollecte2 = new javax.swing.JPanel();
        spCollecte = new javax.swing.JScrollPane();
        lCollecte = new javax.swing.JList();
        jSeparator3 = new javax.swing.JSeparator();
        pSujets = new javax.swing.JPanel();
        lcEtat3 = new javax.swing.JLabel();
        spCollecteSujets = new javax.swing.JScrollPane();
        lCollecteSujets = new javax.swing.JList();
        tpExperiences = new javax.swing.JTabbedPane();
        peFichiers = new javax.swing.JPanel();
        peFichiers1 = new javax.swing.JPanel();
        befInclArticles = new javax.swing.JButton();
        befInclInstances = new javax.swing.JButton();
        lefLignesLuesInstances = new javax.swing.JLabel();
        jLabel22 = new javax.swing.JLabel();
        jLabel23 = new javax.swing.JLabel();
        befInclIPTC = new javax.swing.JButton();
        lefLignesLuesIPTC = new javax.swing.JLabel();
        jLabel42 = new javax.swing.JLabel();
        befInclOnto = new javax.swing.JButton();
        jLabel43 = new javax.swing.JLabel();
        befInclAbstract = new javax.swing.JButton();
        jSeparator2 = new javax.swing.JSeparator();
        befLemConcepts = new javax.swing.JButton();
        lefLemmaConcepts = new javax.swing.JLabel();
        befInclCategories = new javax.swing.JButton();
        lefLignesLuesCategories = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        befInclCateLabels = new javax.swing.JButton();
        lefLignesLuesCateLabels = new javax.swing.JLabel();
        jButton1 = new javax.swing.JButton();
        lefLemmaCategories = new javax.swing.JLabel();
        lefLignesLuesOntologie = new javax.swing.JLabel();
        peFichiers2 = new javax.swing.JPanel();
        jLabel3 = new javax.swing.JLabel();
        lefLienOnto = new javax.swing.JButton();
        lefOntoLie = new javax.swing.JLabel();
        lefLienWiki = new javax.swing.JButton();
        lefWikiLie = new javax.swing.JLabel();
        lefPretraitementOnto = new javax.swing.JButton();
        lefPretraitementWiki = new javax.swing.JButton();
        peExperiences2 = new javax.swing.JPanel();
        peeExperiences2 = new javax.swing.JPanel();
        peeCorpus2 = new javax.swing.JPanel();
        leeCTitre2 = new javax.swing.JLabel();
        leeCDesc2 = new javax.swing.JLabel();
        jLabel24 = new javax.swing.JLabel();
        teeCNbArticles2 = new javax.swing.JFormattedTextField();
        beeCNew2 = new javax.swing.JButton();
        jLabel4 = new javax.swing.JLabel();
        leecLoadStatus2 = new javax.swing.JLabel();
        speExperiences2 = new javax.swing.JScrollPane();
        peExperiences = new javax.swing.JPanel();
        peeExperiences = new javax.swing.JPanel();
        peeCorpus = new javax.swing.JPanel();
        leeCTitre = new javax.swing.JLabel();
        leeCDesc = new javax.swing.JLabel();
        jLabel20 = new javax.swing.JLabel();
        beeCLoad = new javax.swing.JButton();
        jLabel18 = new javax.swing.JLabel();
        teeCNbArticles = new javax.swing.JFormattedTextField();
        jLabel9 = new javax.swing.JLabel();
        beeCNew = new javax.swing.JButton();
        jSeparator5 = new javax.swing.JSeparator();
        jSeparator7 = new javax.swing.JSeparator();
        jSeparator6 = new javax.swing.JSeparator();
        leeCLoadStatus = new javax.swing.JLabel();
        leeCNewStatus = new javax.swing.JLabel();
        speExperiences = new javax.swing.JScrollPane();
        peThesaurus = new javax.swing.JPanel();
        leThesaurus = new javax.swing.JLabel();
        speThesaurus = new javax.swing.JScrollPane();
        teThesaurus = new javax.swing.JTree();
        peCorpus = new javax.swing.JPanel();
        speCorpus = new javax.swing.JScrollPane();
        peSparql = new javax.swing.JPanel();
        lesRequete = new javax.swing.JLabel();
        spesRequete = new javax.swing.JScrollPane();
        taesRequete = new javax.swing.JTextArea();
        besRequete = new javax.swing.JButton();
        spesReponse = new javax.swing.JScrollPane();
        taesReponse = new javax.swing.JTextArea();
        lesReponse = new javax.swing.JLabel();
        peExperiencesOld = new javax.swing.JPanel();
        peExperiencesOld1 = new javax.swing.JPanel();
        leeo1Titre = new javax.swing.JLabel();
        beeoRecupArticles = new javax.swing.JButton();
        jLabel11 = new javax.swing.JLabel();
        beeoSetCorpus = new javax.swing.JButton();
        jLabel12 = new javax.swing.JLabel();
        beeoLoadCorpus = new javax.swing.JButton();
        jLabel16 = new javax.swing.JLabel();
        beeoSaveCorpus = new javax.swing.JButton();
        jLabel17 = new javax.swing.JLabel();
        beeoExpDBPedia = new javax.swing.JButton();
        jLabel13 = new javax.swing.JLabel();
        jLabel30 = new javax.swing.JLabel();
        jLabel37 = new javax.swing.JLabel();
        jSeparator1 = new javax.swing.JSeparator();
        beeoThematiques = new javax.swing.JButton();
        jFormattedTextField10 = new javax.swing.JFormattedTextField();
        jLabel1 = new javax.swing.JLabel();
        beeoCalculDirect = new javax.swing.JButton();
        jLabel19 = new javax.swing.JLabel();
        jLabel40 = new javax.swing.JLabel();
        peExperiencesOld2 = new javax.swing.JPanel();
        leeo2Titre = new javax.swing.JLabel();
        jFormattedTextField1 = new javax.swing.JFormattedTextField();
        jLabel14 = new javax.swing.JLabel();
        beeExtractionJour = new javax.swing.JButton();
        jFormattedTextField2 = new javax.swing.JFormattedTextField();
        jLabel29 = new javax.swing.JLabel();
        jFormattedTextField3 = new javax.swing.JFormattedTextField();
        jLabel10 = new javax.swing.JLabel();
        jLabel15 = new javax.swing.JLabel();
        beeoExtractionEntre = new javax.swing.JButton();
        jFormattedTextField4 = new javax.swing.JFormattedTextField();
        jLabel31 = new javax.swing.JLabel();
        jFormattedTextField5 = new javax.swing.JFormattedTextField();
        jLabel32 = new javax.swing.JLabel();
        jFormattedTextField6 = new javax.swing.JFormattedTextField();
        jFormattedTextField7 = new javax.swing.JFormattedTextField();
        jLabel33 = new javax.swing.JLabel();
        jFormattedTextField8 = new javax.swing.JFormattedTextField();
        jLabel34 = new javax.swing.JLabel();
        jFormattedTextField9 = new javax.swing.JFormattedTextField();
        jLabel35 = new javax.swing.JLabel();
        beeoRienFaire = new javax.swing.JButton();
        jLabel36 = new javax.swing.JLabel();
        tpAnalyse = new javax.swing.JTabbedPane();
        pasExtraction = new javax.swing.JPanel();
        paseExtraction1 = new javax.swing.JPanel();
        paseExplications = new javax.swing.JPanel();
        jLabel48 = new javax.swing.JLabel();
        paseDeroulement2 = new javax.swing.JPanel();
        laseDeroulement1 = new javax.swing.JLabel();
        laseDeroulement2 = new javax.swing.JLabel();
        laseDeroulement3 = new javax.swing.JLabel();
        laseDeroulement4 = new javax.swing.JLabel();
        laseDeroulement5 = new javax.swing.JLabel();
        laseDeroulement6 = new javax.swing.JLabel();
        paseStatut = new javax.swing.JPanel();
        laseNbSujets = new javax.swing.JLabel();
        paseExtraction2 = new javax.swing.JPanel();
        paseDate = new javax.swing.JPanel();
        jLabel8 = new javax.swing.JLabel();
        taseDateDebut = new javax.swing.JFormattedTextField();
        jLabel21 = new javax.swing.JLabel();
        taseDateFin = new javax.swing.JFormattedTextField();
        jLabel27 = new javax.swing.JLabel();
        baseLancer = new javax.swing.JButton();
        baseCharger = new javax.swing.JButton();
        baseCaptures = new javax.swing.JButton();
        paseFlux = new javax.swing.JPanel();
        paseFlux2 = new javax.swing.JPanel();
        jLabel82 = new javax.swing.JLabel();
        pasSujets = new javax.swing.JPanel();
        lassNbSujets = new javax.swing.JLabel();
        spassListe = new javax.swing.JScrollPane();
        tassListe = new javax.swing.JTree();
        pasSujets2 = new javax.swing.JPanel();
        pass2Sujets = new javax.swing.JPanel();
        lass2NbSujets = new javax.swing.JLabel();
        spass2Liste = new javax.swing.JScrollPane();
        tass2Liste = new javax.swing.JTree();
        pass2Sources = new javax.swing.JPanel();
        lass2NbSources = new javax.swing.JLabel();
        spass2Sources = new javax.swing.JScrollPane();
        lass2Sources = new javax.swing.JList();
        pasURLs = new javax.swing.JPanel();
        spasuListe = new javax.swing.JScrollPane();
        lasuListe = new javax.swing.JList();
        pasManip = new javax.swing.JPanel();
        pasmMenu = new javax.swing.JPanel();
        basmAnnuler = new javax.swing.JButton();
        jLabel41 = new javax.swing.JLabel();
        tasmRechercher = new javax.swing.JTextField();
        basmRechercherEt = new javax.swing.JButton();
        basmRechercherOu = new javax.swing.JButton();
        basmSelectAll = new javax.swing.JButton();
        basmDeselectAll = new javax.swing.JButton();
        spasm1 = new javax.swing.JSplitPane();
        spasmListes = new javax.swing.JSplitPane();
        pasmArticles = new javax.swing.JPanel();
        spasmArticles = new javax.swing.JScrollPane();
        lasmArticles = new javax.swing.JList();
        lasmArticles2 = new javax.swing.JLabel();
        pasmSujets = new javax.swing.JPanel();
        spasmSujets = new javax.swing.JScrollPane();
        lasmSujets = new javax.swing.JList();
        lasmSujets2 = new javax.swing.JLabel();
        pasmActions = new javax.swing.JPanel();
        pasmMenuA = new javax.swing.JPanel();
        jPanel10 = new javax.swing.JPanel();
        jLabelNbArticlesDansLaClassification = new javax.swing.JLabel();
        jLabel46 = new javax.swing.JLabel();
        basmNouveau = new javax.swing.JButton();
        basmEdit = new javax.swing.JButton();
        basmFusion = new javax.swing.JButton();
        jButton2 = new javax.swing.JButton();
        basmRetrier = new javax.swing.JButton();
        jPanel2 = new javax.swing.JPanel();
        jLabel44 = new javax.swing.JLabel();
        basmValider = new javax.swing.JButton();
        basmInvalider = new javax.swing.JButton();
        basmTransferer = new javax.swing.JButton();
        jPanel3 = new javax.swing.JPanel();
        jLabel45 = new javax.swing.JLabel();
        lasmArticlesRestants = new javax.swing.JLabel();
        jPanel1 = new javax.swing.JPanel();
        jLabel47 = new javax.swing.JLabel();
        tasmAutoPrecision = new javax.swing.JFormattedTextField();
        basmClassAuto = new javax.swing.JButton();
        jLabel67 = new javax.swing.JLabel();
        jPanel11 = new javax.swing.JPanel();
        jLabel68 = new javax.swing.JLabel();
        tasmAutoPrecision2 = new javax.swing.JFormattedTextField();
        basmClusterAuto = new javax.swing.JButton();
        lasmAutoStatut = new javax.swing.JLabel();
        jPanel4 = new javax.swing.JPanel();
        jLabel39 = new javax.swing.JLabel();
        basmExportExcel = new javax.swing.JButton();
        jButton3 = new javax.swing.JButton();
        basmSauvegarder = new javax.swing.JButton();
        lasmStatutSave = new javax.swing.JLabel();
        pasmDestinations = new javax.swing.JPanel();
        spasmDestinations = new javax.swing.JScrollPane();
        lasmDestinations = new javax.swing.JList();
        lasmDestinations2 = new javax.swing.JLabel();
        pasDiachronie = new javax.swing.JPanel();
        pasdMenu = new javax.swing.JPanel();
        pasdMenu2 = new javax.swing.JPanel();
        basdGenerer = new javax.swing.JButton();
        lasdGenerer = new javax.swing.JLabel();
        tpasDiachronie = new javax.swing.JTabbedPane();
        pasdParSujet = new javax.swing.JPanel();
        pasdsMenu = new javax.swing.JPanel();
        basdsExportExcel = new javax.swing.JButton();
        jLabel53 = new javax.swing.JLabel();
        pasdParSujet2 = new javax.swing.JSplitPane();
        spasdListeSujets = new javax.swing.JScrollPane();
        lasdListeSujets = new javax.swing.JList();
        tpasdParSujet = new javax.swing.JTabbedPane();
        pasdsDiachronie = new javax.swing.JPanel();
        spasdsDiachronie = new javax.swing.JScrollPane();
        lasdsDiachronie = new javax.swing.JList();
        pasdsVariete = new javax.swing.JPanel();
        lasdsvArticles = new javax.swing.JLabel();
        lasdsvSources = new javax.swing.JLabel();
        lasdsvCategories = new javax.swing.JLabel();
        pasdsDistributionS = new javax.swing.JPanel();
        spasdsDistributionS = new javax.swing.JScrollPane();
        lasdsDistributionS = new javax.swing.JList();
        pasdsDistributionC = new javax.swing.JPanel();
        spasdsDistributionC = new javax.swing.JScrollPane();
        lasdsDistributionC = new javax.swing.JList();
        pasdParSource = new javax.swing.JPanel();
        pasdoMenu = new javax.swing.JPanel();
        basdoExportExcel = new javax.swing.JButton();
        jLabel52 = new javax.swing.JLabel();
        pasdParSource2 = new javax.swing.JSplitPane();
        spasdoListeSources = new javax.swing.JScrollPane();
        lasdoListeSources = new javax.swing.JList();
        tpasdParSources = new javax.swing.JTabbedPane();
        pasdoProduction = new javax.swing.JPanel();
        spasdoProduction = new javax.swing.JScrollPane();
        lasdoProduction = new javax.swing.JList();
        pasdoVariete = new javax.swing.JPanel();
        lasdoArticles = new javax.swing.JLabel();
        lasdoSujets2 = new javax.swing.JLabel();
        lasdoExclus2 = new javax.swing.JLabel();
        lasdoPrimeurs2 = new javax.swing.JLabel();
        pasdoDistribution = new javax.swing.JPanel();
        spasdoDistribution = new javax.swing.JScrollPane();
        lasdoDistribution = new javax.swing.JList();
        pasdoExclus = new javax.swing.JPanel();
        spasdoExclus = new javax.swing.JScrollPane();
        lasdoExclus = new javax.swing.JList();
        pasdoPrimeurs = new javax.swing.JPanel();
        spasdoPrimeurs = new javax.swing.JScrollPane();
        lasdoPrimeurs = new javax.swing.JList();
        pasdGeneral = new javax.swing.JPanel();
        tpasdGeneral = new javax.swing.JTabbedPane();
        pasdgVariete = new javax.swing.JPanel();
        lasdgvArticles = new javax.swing.JLabel();
        lasdgvSujets = new javax.swing.JLabel();
        lasdgvSources = new javax.swing.JLabel();
        lasdgvCategories = new javax.swing.JLabel();
        pasdgDistributionS = new javax.swing.JPanel();
        spasdgDistributionS = new javax.swing.JScrollPane();
        lasdgDistributionS = new javax.swing.JList();
        pasdgDistributionO = new javax.swing.JPanel();
        spasdgDistributionO = new javax.swing.JScrollPane();
        lasdgDistributionO = new javax.swing.JList();
        pasdgDistributionC = new javax.swing.JPanel();
        spasdgDistributionC = new javax.swing.JScrollPane();
        lasdgDistributionC = new javax.swing.JList();
        pasdgDistributionE = new javax.swing.JPanel();
        spasdgDistributionE = new javax.swing.JScrollPane();
        lasdgDistributionE = new javax.swing.JList();
        pasdgDistributionP = new javax.swing.JPanel();
        spasdgDistributionP = new javax.swing.JScrollPane();
        lasdgDistributionP = new javax.swing.JList();
        pasConfrontation = new javax.swing.JPanel();
        jLabel49 = new javax.swing.JLabel();
        jPanel5 = new javax.swing.JPanel();
        jPanel6 = new javax.swing.JPanel();
        jPanel7 = new javax.swing.JPanel();
        jLabel50 = new javax.swing.JLabel();
        tascPageWeb = new javax.swing.JTextField();
        jPanel8 = new javax.swing.JPanel();
        jLabel51 = new javax.swing.JLabel();
        tascFluxRSS = new javax.swing.JTextField();
        jPanel9 = new javax.swing.JPanel();
        bascConfrontation = new javax.swing.JToggleButton();
        lascStatut = new javax.swing.JLabel();
        spascCaptures = new javax.swing.JScrollPane();
        lascCaptures = new javax.swing.JList();

        org.jdesktop.application.ResourceMap resourceMap = org.jdesktop.application.Application.getInstance(zold.ihm.ipriproto._IHMTest1App.class).getContext().getResourceMap(FenetrePrincipale.class);
        jLabel6.setText(resourceMap.getString("jLabel6.text")); // NOI18N
        jLabel6.setName("jLabel6"); // NOI18N

        setDefaultCloseOperation(javax.swing.WindowConstants.DO_NOTHING_ON_CLOSE);
        setTitle(resourceMap.getString("FrogPondFrame.title")); // NOI18N
        setName("FrogPondFrame"); // NOI18N
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                formWindowClosing(evt);
            }
        });

        tpPrincipal.setName("tpPrincipal"); // NOI18N

        tpStats.setName("tpStats"); // NOI18N

        pJournal.setName("pJournal"); // NOI18N
        pJournal.setLayout(new java.awt.BorderLayout());

        pjMenu.setName("pjMenu"); // NOI18N

        tjNbLignes.setColumns(4);
        tjNbLignes.setFormatterFactory(new javax.swing.text.DefaultFormatterFactory(new javax.swing.text.NumberFormatter(java.text.NumberFormat.getIntegerInstance())));
        tjNbLignes.setHorizontalAlignment(javax.swing.JTextField.TRAILING);
        tjNbLignes.setText(resourceMap.getString("tjNbLignes.text")); // NOI18N
        tjNbLignes.setName("tjNbLignes"); // NOI18N
        tjNbLignes.addPropertyChangeListener(new java.beans.PropertyChangeListener() {
            public void propertyChange(java.beans.PropertyChangeEvent evt) {
                tjNbLignesPropertyChange(evt);
            }
        });
        pjMenu.add(tjNbLignes);

        jLabel5.setText(resourceMap.getString("jLabel5.text")); // NOI18N
        jLabel5.setName("jLabel5"); // NOI18N
        pjMenu.add(jLabel5);

        pJournal.add(pjMenu, java.awt.BorderLayout.PAGE_START);

        pJAffichage.setName("pJAffichage"); // NOI18N
        pJAffichage.setLayout(new java.awt.GridLayout(3, 0));

        spjInfos.setName("spjInfos"); // NOI18N

        tjInfos.setColumns(20);
        tjInfos.setEditable(false);
        tjInfos.setRows(5);
        tjInfos.setName("tjInfos"); // NOI18N
        spjInfos.setViewportView(tjInfos);

        pJAffichage.add(spjInfos);

        spjErreurs.setName("spjErreurs"); // NOI18N

        tjErreurs.setColumns(20);
        tjErreurs.setEditable(false);
        tjErreurs.setRows(5);
        tjErreurs.setName("tjErreurs"); // NOI18N
        spjErreurs.setViewportView(tjErreurs);

        pJAffichage.add(spjErreurs);

        pjMemoire.setName("pjMemoire"); // NOI18N
        pjMemoire.setLayout(new java.awt.BorderLayout());

        ljmGraphe.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        ljmGraphe.setText(resourceMap.getString("ljmGraphe.text")); // NOI18N
        ljmGraphe.setName("ljmGraphe"); // NOI18N
        pjMemoire.add(ljmGraphe, java.awt.BorderLayout.CENTER);

        ljmActu.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        ljmActu.setText(resourceMap.getString("ljmActu.text")); // NOI18N
        ljmActu.setName("ljmActu"); // NOI18N
        pjMemoire.add(ljmActu, java.awt.BorderLayout.NORTH);

        ljInfoCollecte.setText(resourceMap.getString("ljInfoCollecte.text")); // NOI18N
        ljInfoCollecte.setName("ljInfoCollecte"); // NOI18N
        pjMemoire.add(ljInfoCollecte, java.awt.BorderLayout.PAGE_END);

        pJAffichage.add(pjMemoire);

        pJournal.add(pJAffichage, java.awt.BorderLayout.CENTER);

        tpStats.addTab(resourceMap.getString("pJournal.TabConstraints.tabTitle"), pJournal); // NOI18N

        psBaseDonnees.setName("psBaseDonnees"); // NOI18N
        psBaseDonnees.setLayout(new java.awt.BorderLayout());

        psbMenu.setName("psbMenu"); // NOI18N

        lsbEtat.setFont(lsbEtat.getFont());
        lsbEtat.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        lsbEtat.setText(resourceMap.getString("lsbEtat.text")); // NOI18N
        lsbEtat.setName("lsbEtat"); // NOI18N
        psbMenu.add(lsbEtat);

        bsbEtat.setText(resourceMap.getString("bsbEtat.text")); // NOI18N
        bsbEtat.setName("bsbEtat"); // NOI18N
        bsbEtat.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bsbEtatActionPerformed(evt);
            }
        });
        psbMenu.add(bsbEtat);

        psBaseDonnees.add(psbMenu, java.awt.BorderLayout.NORTH);

        psbContenu.setName("psbContenu"); // NOI18N
        psbContenu.setLayout(new java.awt.GridLayout(1, 2, 10, 0));

        psbContenu1.setName("psbContenu1"); // NOI18N
        psbContenu1.setLayout(new java.awt.BorderLayout());

        lsbTotal.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        lsbTotal.setText(resourceMap.getString("lsbTotal.text")); // NOI18N
        lsbTotal.setName("lsbTotal"); // NOI18N
        psbContenu1.add(lsbTotal, java.awt.BorderLayout.NORTH);

        psbContenu10.setName("psbContenu10"); // NOI18N
        psbContenu10.setLayout(new java.awt.GridLayout(2, 0));

        psbContenu11.setName("psbContenu11"); // NOI18N
        psbContenu11.setLayout(new java.awt.BorderLayout());

        lsbJour.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        lsbJour.setText(resourceMap.getString("lsbJour.text")); // NOI18N
        lsbJour.setName("lsbJour"); // NOI18N
        psbContenu11.add(lsbJour, java.awt.BorderLayout.NORTH);

        spsbJour.setName("spsbJour"); // NOI18N

        lsbJour2.setName("lsbJour2"); // NOI18N
        spsbJour.setViewportView(lsbJour2);

        psbContenu11.add(spsbJour, java.awt.BorderLayout.CENTER);

        psbContenu10.add(psbContenu11);

        psbContenu12.setName("psbContenu12"); // NOI18N
        psbContenu12.setLayout(new java.awt.BorderLayout());

        lsbHeure.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        lsbHeure.setText(resourceMap.getString("lsbHeure.text")); // NOI18N
        lsbHeure.setName("lsbHeure"); // NOI18N
        psbContenu12.add(lsbHeure, java.awt.BorderLayout.NORTH);

        spsbHeure.setName("spsbHeure"); // NOI18N

        lsbHeure2.setName("lsbHeure2"); // NOI18N
        spsbHeure.setViewportView(lsbHeure2);

        psbContenu12.add(spsbHeure, java.awt.BorderLayout.CENTER);

        psbContenu10.add(psbContenu12);

        psbContenu1.add(psbContenu10, java.awt.BorderLayout.CENTER);

        lsbGrapheHeure.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        lsbGrapheHeure.setText(resourceMap.getString("lsbGrapheHeure.text")); // NOI18N
        lsbGrapheHeure.setName("lsbGrapheHeure"); // NOI18N
        lsbGrapheHeure.setPreferredSize(new java.awt.Dimension(47, 100));
        psbContenu1.add(lsbGrapheHeure, java.awt.BorderLayout.SOUTH);

        psbContenu.add(psbContenu1);

        psbContenu2.setName("psbContenu2"); // NOI18N
        psbContenu2.setLayout(new java.awt.BorderLayout());

        lsbFlux.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        lsbFlux.setText(resourceMap.getString("lsbFlux.text")); // NOI18N
        lsbFlux.setName("lsbFlux"); // NOI18N
        psbContenu2.add(lsbFlux, java.awt.BorderLayout.NORTH);

        spsbFlux.setName("spsbFlux"); // NOI18N

        lsbFlux2.setName("lsbFlux2"); // NOI18N
        spsbFlux.setViewportView(lsbFlux2);

        psbContenu2.add(spsbFlux, java.awt.BorderLayout.CENTER);

        psbContenu.add(psbContenu2);

        psBaseDonnees.add(psbContenu, java.awt.BorderLayout.CENTER);

        tpStats.addTab(resourceMap.getString("psBaseDonnees.TabConstraints.tabTitle"), psBaseDonnees); // NOI18N

        psRecherche.setName("psRecherche"); // NOI18N
        psRecherche.setLayout(new java.awt.BorderLayout());

        psRecherche2.setName("psRecherche2"); // NOI18N

        tsrRecherche.setColumns(30);
        tsrRecherche.setText(resourceMap.getString("tsrRecherche.text")); // NOI18N
        tsrRecherche.setName("tsrRecherche"); // NOI18N
        psRecherche2.add(tsrRecherche);

        bsrRecherche.setText(resourceMap.getString("bsrRecherche.text")); // NOI18N
        bsrRecherche.setName("bsrRecherche"); // NOI18N
        bsrRecherche.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bsrRechercheActionPerformed(evt);
            }
        });
        psRecherche2.add(bsrRecherche);

        lsrRecherche.setText(resourceMap.getString("lsrRecherche.text")); // NOI18N
        lsrRecherche.setName("lsrRecherche"); // NOI18N
        psRecherche2.add(lsrRecherche);

        psRecherche.add(psRecherche2, java.awt.BorderLayout.PAGE_START);

        jScrollPane1.setName("jScrollPane1"); // NOI18N

        javax.swing.tree.DefaultMutableTreeNode treeNode1 = new javax.swing.tree.DefaultMutableTreeNode("Résultat");
        tsrResultat.setModel(new javax.swing.tree.DefaultTreeModel(treeNode1));
        tsrResultat.setName("tsrResultat"); // NOI18N
        jScrollPane1.setViewportView(tsrResultat);

        psRecherche.add(jScrollPane1, java.awt.BorderLayout.CENTER);

        tpStats.addTab(resourceMap.getString("psRecherche.TabConstraints.tabTitle"), psRecherche); // NOI18N

        tpPrincipal.addTab(resourceMap.getString("tpStats.TabConstraints.tabTitle"), tpStats); // NOI18N

        tpCorpus.setName("tpCorpus"); // NOI18N

        pTags.setName("pTags"); // NOI18N
        pTags.setLayout(new java.awt.BorderLayout());

        sptListe.setBorder(Charte.getBorder());
        sptListe.setName("sptListe"); // NOI18N

        ltListe.setName("ltListe"); // NOI18N
        ltListe.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
            public void valueChanged(javax.swing.event.ListSelectionEvent evt) {
                ltListeValueChanged(evt);
            }
        });
        sptListe.setViewportView(ltListe);

        pTags.add(sptListe, java.awt.BorderLayout.WEST);

        ptGestion.setName("ptGestion"); // NOI18N
        ptGestion.setLayout(new java.awt.BorderLayout(20, 0));

        jLabel54.setText(resourceMap.getString("jLabel54.text")); // NOI18N
        jLabel54.setName("jLabel54"); // NOI18N
        ptGestion.add(jLabel54, java.awt.BorderLayout.PAGE_START);

        ptGestion2.setName("ptGestion2"); // NOI18N

        ptGestion3.setName("ptGestion3"); // NOI18N
        ptGestion3.setLayout(new java.awt.GridLayout(3, 1));

        ptgNouveau.setName("ptgNouveau"); // NOI18N
        ptgNouveau.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.LEFT));

        jLabel57.setText(resourceMap.getString("jLabel57.text")); // NOI18N
        jLabel57.setName("jLabel57"); // NOI18N
        ptgNouveau.add(jLabel57);

        jLabel59.setText(resourceMap.getString("jLabel59.text")); // NOI18N
        jLabel59.setName("jLabel59"); // NOI18N
        ptgNouveau.add(jLabel59);

        ttgnNom.setColumns(10);
        ttgnNom.setText(resourceMap.getString("ttgnNom.text")); // NOI18N
        ttgnNom.setName("ttgnNom"); // NOI18N
        ptgNouveau.add(ttgnNom);

        jLabel60.setText(resourceMap.getString("jLabel60.text")); // NOI18N
        jLabel60.setName("jLabel60"); // NOI18N
        ptgNouveau.add(jLabel60);

        ttgnNo.setColumns(3);
        ttgnNo.setFormatterFactory(new javax.swing.text.DefaultFormatterFactory(new javax.swing.text.NumberFormatter(new java.text.DecimalFormat("#0"))));
        ttgnNo.setText(resourceMap.getString("ttgnNo.text")); // NOI18N
        ttgnNo.setName("ttgnNo"); // NOI18N
        ptgNouveau.add(ttgnNo);

        btgnAjouter.setText(resourceMap.getString("btgnAjouter.text")); // NOI18N
        btgnAjouter.setName("btgnAjouter"); // NOI18N
        btgnAjouter.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btgnAjouterActionPerformed(evt);
            }
        });
        ptgNouveau.add(btgnAjouter);

        ptGestion3.add(ptgNouveau);

        ptgExistant.setName("ptgExistant"); // NOI18N
        ptgExistant.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.LEFT));

        jLabel55.setText(resourceMap.getString("jLabel55.text")); // NOI18N
        jLabel55.setName("jLabel55"); // NOI18N
        ptgExistant.add(jLabel55);

        jLabel58.setText(resourceMap.getString("jLabel58.text")); // NOI18N
        jLabel58.setName("jLabel58"); // NOI18N
        ptgExistant.add(jLabel58);

        ttgeNom.setColumns(10);
        ttgeNom.setText(resourceMap.getString("ttgeNom.text")); // NOI18N
        ttgeNom.setName("ttgeNom"); // NOI18N
        ptgExistant.add(ttgeNom);

        jLabel56.setText(resourceMap.getString("jLabel56.text")); // NOI18N
        jLabel56.setName("jLabel56"); // NOI18N
        ptgExistant.add(jLabel56);

        ttgeNo.setColumns(3);
        ttgeNo.setFormatterFactory(new javax.swing.text.DefaultFormatterFactory(new javax.swing.text.NumberFormatter(new java.text.DecimalFormat("#0"))));
        ttgeNo.setName("ttgeNo"); // NOI18N
        ptgExistant.add(ttgeNo);

        btgeModifier.setText(resourceMap.getString("btgeModifier.text")); // NOI18N
        btgeModifier.setName("btgeModifier"); // NOI18N
        btgeModifier.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btgeModifierActionPerformed(evt);
            }
        });
        ptgExistant.add(btgeModifier);

        btgeSupprimer.setText(resourceMap.getString("btgeSupprimer.text")); // NOI18N
        btgeSupprimer.setName("btgeSupprimer"); // NOI18N
        btgeSupprimer.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btgeSupprimerActionPerformed(evt);
            }
        });
        ptgExistant.add(btgeSupprimer);

        ptGestion3.add(ptgExistant);

        jPanel12.setName("jPanel12"); // NOI18N

        jLabel77.setText(resourceMap.getString("jLabel77.text")); // NOI18N
        jLabel77.setName("jLabel77"); // NOI18N
        jPanel12.add(jLabel77);

        ptGestion3.add(jPanel12);

        ptGestion2.add(ptGestion3);

        ptGestion.add(ptGestion2, java.awt.BorderLayout.CENTER);

        pTags.add(ptGestion, java.awt.BorderLayout.CENTER);

        tpCorpus.addTab(resourceMap.getString("pTags.TabConstraints.tabTitle"), pTags); // NOI18N

        pSources.setName("pSources"); // NOI18N
        pSources.setLayout(new java.awt.BorderLayout());

        spsListe.setBorder(Charte.getBorder());
        spsListe.setName("spsListe"); // NOI18N

        lsListe.setName("lsListe"); // NOI18N
        spsListe.setViewportView(lsListe);

        pSources.add(spsListe, java.awt.BorderLayout.LINE_START);

        psGestion.setName("psGestion"); // NOI18N
        psGestion.setLayout(new java.awt.BorderLayout());

        psGestion2.setName("psGestion2"); // NOI18N
        psGestion2.setLayout(new java.awt.GridLayout(9, 1));

        psGestion25.setName("psGestion25"); // NOI18N

        jLabel64.setText(resourceMap.getString("jLabel64.text")); // NOI18N
        jLabel64.setName("jLabel64"); // NOI18N
        psGestion25.add(jLabel64);

        psGestion2.add(psGestion25);

        psGestion26.setName("psGestion26"); // NOI18N
        psGestion26.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.LEFT));

        psGestion261.setName("psGestion261"); // NOI18N
        psGestion261.setLayout(new java.awt.BorderLayout(5, 0));

        jLabel65.setText(resourceMap.getString("jLabel65.text")); // NOI18N
        jLabel65.setName("jLabel65"); // NOI18N
        psGestion261.add(jLabel65, java.awt.BorderLayout.WEST);

        tsgnNom.setColumns(35);
        tsgnNom.setText(resourceMap.getString("tsgnNom.text")); // NOI18N
        tsgnNom.setName("tsgnNom"); // NOI18N
        psGestion261.add(tsgnNom, java.awt.BorderLayout.CENTER);

        psGestion26.add(psGestion261);

        psGestion2.add(psGestion26);

        psGestion27.setName("psGestion27"); // NOI18N
        psGestion27.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.LEFT));

        psGestion271.setName("psGestion271"); // NOI18N
        psGestion271.setLayout(new java.awt.BorderLayout(5, 0));

        jLabel66.setText(resourceMap.getString("jLabel66.text")); // NOI18N
        jLabel66.setName("jLabel66"); // NOI18N
        psGestion271.add(jLabel66, java.awt.BorderLayout.WEST);

        tsgnHomepage.setColumns(50);
        tsgnHomepage.setText(resourceMap.getString("tsgnHomepage.text")); // NOI18N
        tsgnHomepage.setName("tsgnHomepage"); // NOI18N
        psGestion271.add(tsgnHomepage, java.awt.BorderLayout.CENTER);

        psGestion27.add(psGestion271);

        psGestion2.add(psGestion27);

        psGestion28.setName("psGestion28"); // NOI18N

        bsgnAjouter.setText(resourceMap.getString("bsgnAjouter.text")); // NOI18N
        bsgnAjouter.setName("bsgnAjouter"); // NOI18N
        bsgnAjouter.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bsgnAjouterActionPerformed(evt);
            }
        });
        psGestion28.add(bsgnAjouter);

        psGestion2.add(psGestion28);

        psGestion21.setName("psGestion21"); // NOI18N

        jLabel61.setText(resourceMap.getString("jLabel61.text")); // NOI18N
        jLabel61.setName("jLabel61"); // NOI18N
        psGestion21.add(jLabel61);

        psGestion2.add(psGestion21);

        psGestion22.setName("psGestion22"); // NOI18N
        psGestion22.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.LEFT));

        psGestion221.setName("psGestion221"); // NOI18N
        psGestion221.setLayout(new java.awt.BorderLayout(5, 0));

        jLabel62.setText(resourceMap.getString("jLabel62.text")); // NOI18N
        jLabel62.setName("jLabel62"); // NOI18N
        psGestion221.add(jLabel62, java.awt.BorderLayout.WEST);

        tsgeNom.setColumns(35);
        tsgeNom.setText(resourceMap.getString("tsgeNom.text")); // NOI18N
        tsgeNom.setName("tsgeNom"); // NOI18N
        psGestion221.add(tsgeNom, java.awt.BorderLayout.CENTER);

        psGestion22.add(psGestion221);

        psGestion2.add(psGestion22);

        psGestion23.setName("psGestion23"); // NOI18N
        psGestion23.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.LEFT));

        psGestion231.setName("psGestion231"); // NOI18N
        psGestion231.setLayout(new java.awt.BorderLayout(5, 0));

        jLabel63.setText(resourceMap.getString("jLabel63.text")); // NOI18N
        jLabel63.setName("jLabel63"); // NOI18N
        psGestion231.add(jLabel63, java.awt.BorderLayout.WEST);

        tsgeHomepage.setColumns(50);
        tsgeHomepage.setText(resourceMap.getString("tsgeHomepage.text")); // NOI18N
        tsgeHomepage.setName("tsgeHomepage"); // NOI18N
        psGestion231.add(tsgeHomepage, java.awt.BorderLayout.CENTER);

        psGestion23.add(psGestion231);

        psGestion2.add(psGestion23);

        psGestion24.setName("psGestion24"); // NOI18N

        bsgeModifier.setText(resourceMap.getString("bsgeModifier.text")); // NOI18N
        bsgeModifier.setName("bsgeModifier"); // NOI18N
        bsgeModifier.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bsgeModifierActionPerformed(evt);
            }
        });
        psGestion24.add(bsgeModifier);

        bsgeSupprimer.setText(resourceMap.getString("bsgeSupprimer.text")); // NOI18N
        bsgeSupprimer.setName("bsgeSupprimer"); // NOI18N
        bsgeSupprimer.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bsgeSupprimerActionPerformed(evt);
            }
        });
        psGestion24.add(bsgeSupprimer);

        psGestion2.add(psGestion24);

        psGestion29.setName("psGestion29"); // NOI18N

        jLabel78.setText(resourceMap.getString("jLabel78.text")); // NOI18N
        jLabel78.setName("jLabel78"); // NOI18N
        psGestion29.add(jLabel78);

        psGestion2.add(psGestion29);

        psGestion.add(psGestion2, java.awt.BorderLayout.NORTH);

        pSources.add(psGestion, java.awt.BorderLayout.CENTER);

        tpCorpus.addTab(resourceMap.getString("pSources.TabConstraints.tabTitle"), pSources); // NOI18N

        pFlux.setName("pFlux"); // NOI18N
        pFlux.setLayout(new java.awt.BorderLayout());

        pfListes.setName("pfListes"); // NOI18N
        pfListes.setLayout(new java.awt.BorderLayout());

        spfListe.setBorder(Charte.getBorder());
        spfListe.setName("spfListe"); // NOI18N

        lfListe.setName("lfListe"); // NOI18N
        spfListe.setViewportView(lfListe);

        pfListes.add(spfListe, java.awt.BorderLayout.LINE_START);

        pFlux.add(pfListes, java.awt.BorderLayout.WEST);

        pfGestion.setName("pfGestion"); // NOI18N
        pfGestion.setLayout(new java.awt.BorderLayout());

        pfGestion2.setName("pfGestion2"); // NOI18N
        pfGestion2.setLayout(new java.awt.GridLayout(13, 0));

        pfGestion21.setName("pfGestion21"); // NOI18N

        jLabel69.setText(resourceMap.getString("jLabel69.text")); // NOI18N
        jLabel69.setName("jLabel69"); // NOI18N
        pfGestion21.add(jLabel69);

        pfGestion2.add(pfGestion21);

        pfGestion22.setName("pfGestion22"); // NOI18N
        pfGestion22.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.LEFT));

        jLabel70.setText(resourceMap.getString("jLabel70.text")); // NOI18N
        jLabel70.setName("jLabel70"); // NOI18N
        pfGestion22.add(jLabel70);

        tfgnNom.setColumns(35);
        tfgnNom.setText(resourceMap.getString("tfgnNom.text")); // NOI18N
        tfgnNom.setName("tfgnNom"); // NOI18N
        pfGestion22.add(tfgnNom);

        pfGestion2.add(pfGestion22);

        pfGestion23.setName("pfGestion23"); // NOI18N
        pfGestion23.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.LEFT));

        jLabel71.setText(resourceMap.getString("jLabel71.text")); // NOI18N
        jLabel71.setName("jLabel71"); // NOI18N
        pfGestion23.add(jLabel71);

        tfgnUrl.setColumns(50);
        tfgnUrl.setText(resourceMap.getString("tfgnUrl.text")); // NOI18N
        tfgnUrl.setName("tfgnUrl"); // NOI18N
        pfGestion23.add(tfgnUrl);

        pfGestion2.add(pfGestion23);

        pfGestion24.setName("pfGestion24"); // NOI18N
        pfGestion24.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.LEFT));

        jLabel72.setText(resourceMap.getString("jLabel72.text")); // NOI18N
        jLabel72.setName("jLabel72"); // NOI18N
        pfGestion24.add(jLabel72);

        cbfgnSource.setMaximumRowCount(20);
        cbfgnSource.setName("cbfgnSource"); // NOI18N
        pfGestion24.add(cbfgnSource);

        pfGestion2.add(pfGestion24);

        pfGestion25.setName("pfGestion25"); // NOI18N

        bfgnAjouter.setText(resourceMap.getString("bfgnAjouter.text")); // NOI18N
        bfgnAjouter.setName("bfgnAjouter"); // NOI18N
        bfgnAjouter.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bfgnAjouterActionPerformed(evt);
            }
        });
        pfGestion25.add(bfgnAjouter);

        pfGestion2.add(pfGestion25);

        pfGestion26.setName("pfGestion26"); // NOI18N

        jLabel73.setText(resourceMap.getString("jLabel73.text")); // NOI18N
        jLabel73.setName("jLabel73"); // NOI18N
        pfGestion26.add(jLabel73);

        pfGestion2.add(pfGestion26);

        pfGestion27.setName("pfGestion27"); // NOI18N
        pfGestion27.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.LEFT));

        jLabel74.setText(resourceMap.getString("jLabel74.text")); // NOI18N
        jLabel74.setName("jLabel74"); // NOI18N
        pfGestion27.add(jLabel74);

        tfgeNom.setColumns(35);
        tfgeNom.setText(resourceMap.getString("tfgeNom.text")); // NOI18N
        tfgeNom.setName("tfgeNom"); // NOI18N
        pfGestion27.add(tfgeNom);

        pfGestion2.add(pfGestion27);

        pfGestion28.setName("pfGestion28"); // NOI18N
        pfGestion28.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.LEFT));

        jLabel75.setText(resourceMap.getString("jLabel75.text")); // NOI18N
        jLabel75.setName("jLabel75"); // NOI18N
        pfGestion28.add(jLabel75);

        tfgeUrl.setColumns(50);
        tfgeUrl.setText(resourceMap.getString("tfgeUrl.text")); // NOI18N
        tfgeUrl.setName("tfgeUrl"); // NOI18N
        pfGestion28.add(tfgeUrl);

        pfGestion2.add(pfGestion28);

        pfGestion29.setName("pfGestion29"); // NOI18N
        pfGestion29.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.LEFT));

        jLabel76.setText(resourceMap.getString("jLabel76.text")); // NOI18N
        jLabel76.setName("jLabel76"); // NOI18N
        pfGestion29.add(jLabel76);

        cbfgeSource.setMaximumRowCount(20);
        cbfgeSource.setName("cbfgeSource"); // NOI18N
        pfGestion29.add(cbfgeSource);

        pfGestion2.add(pfGestion29);

        pfGestion210.setName("pfGestion210"); // NOI18N

        bfgeModifier.setText(resourceMap.getString("bfgeModifier.text")); // NOI18N
        bfgeModifier.setName("bfgeModifier"); // NOI18N
        bfgeModifier.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bfgeModifierActionPerformed(evt);
            }
        });
        pfGestion210.add(bfgeModifier);

        bfgeSupprimer.setText(resourceMap.getString("bfgeSupprimer.text")); // NOI18N
        bfgeSupprimer.setName("bfgeSupprimer"); // NOI18N
        bfgeSupprimer.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bfgeSupprimerActionPerformed(evt);
            }
        });
        pfGestion210.add(bfgeSupprimer);

        pfGestion2.add(pfGestion210);

        pfGestion211.setName("pfGestion211"); // NOI18N

        jLabel79.setText(resourceMap.getString("jLabel79.text")); // NOI18N
        jLabel79.setName("jLabel79"); // NOI18N
        pfGestion211.add(jLabel79);

        pfGestion2.add(pfGestion211);

        pfGestion212.setName("pfGestion212"); // NOI18N

        jLabel80.setText(resourceMap.getString("jLabel80.text")); // NOI18N
        jLabel80.setName("jLabel80"); // NOI18N
        pfGestion212.add(jLabel80);

        cbfgeTag.setName("cbfgeTag"); // NOI18N
        pfGestion212.add(cbfgeTag);

        bfgeAjouterTag.setText(resourceMap.getString("bfgeAjouterTag.text")); // NOI18N
        bfgeAjouterTag.setName("bfgeAjouterTag"); // NOI18N
        bfgeAjouterTag.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bfgeAjouterTagActionPerformed(evt);
            }
        });
        pfGestion212.add(bfgeAjouterTag);

        pfGestion2.add(pfGestion212);

        pfGestion3.setName("pfGestion3"); // NOI18N

        jLabel81.setText(resourceMap.getString("jLabel81.text")); // NOI18N
        jLabel81.setName("jLabel81"); // NOI18N
        pfGestion3.add(jLabel81);

        bfgeSupprimerTag.setText(resourceMap.getString("bfgeSupprimerTag.text")); // NOI18N
        bfgeSupprimerTag.setName("bfgeSupprimerTag"); // NOI18N
        bfgeSupprimerTag.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bfgeSupprimerTagActionPerformed(evt);
            }
        });
        pfGestion3.add(bfgeSupprimerTag);

        pfGestion2.add(pfGestion3);

        pfGestion.add(pfGestion2, java.awt.BorderLayout.PAGE_START);

        spfTags.setBorder(Charte.getBorder());
        spfTags.setName("spfTags"); // NOI18N

        lfTags.setName("lfTags"); // NOI18N
        spfTags.setViewportView(lfTags);

        pfGestion.add(spfTags, java.awt.BorderLayout.CENTER);

        pFlux.add(pfGestion, java.awt.BorderLayout.CENTER);

        tpCorpus.addTab(resourceMap.getString("pFlux.TabConstraints.tabTitle"), pFlux); // NOI18N

        tpPrincipal.addTab(resourceMap.getString("tpCorpus.TabConstraints.tabTitle"), tpCorpus); // NOI18N

        tpCollecte.setName("tpCollecte"); // NOI18N

        pSousCorpus.setName("pSousCorpus"); // NOI18N
        pSousCorpus.setLayout(new java.awt.BorderLayout());

        pcLancement.setName("pcLancement"); // NOI18N
        pcLancement.setLayout(new java.awt.GridLayout(4, 1));

        pcLancementArticles.setName("pcLancementArticles"); // NOI18N
        pcLancementArticles.setLayout(new java.awt.BorderLayout());

        jLabel7.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jLabel7.setText(resourceMap.getString("jLabel7.text")); // NOI18N
        jLabel7.setName("jLabel7"); // NOI18N
        pcLancementArticles.add(jLabel7, java.awt.BorderLayout.WEST);

        pcLancementArticles2.setName("pcLancementArticles2"); // NOI18N
        pcLancementArticles2.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.LEFT));

        bcCollecte.setText(resourceMap.getString("bcCollecte.text")); // NOI18N
        bcCollecte.setName("bcCollecte"); // NOI18N
        bcCollecte.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bcCollecteActionPerformed(evt);
            }
        });
        pcLancementArticles2.add(bcCollecte);

        bcLemmatisation.setText(resourceMap.getString("bcLemmatisation.text")); // NOI18N
        bcLemmatisation.setName("bcLemmatisation"); // NOI18N
        bcLemmatisation.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bcLemmatisationActionPerformed(evt);
            }
        });
        pcLancementArticles2.add(bcLemmatisation);

        bcLemmatisation2.setText(resourceMap.getString("bcLemmatisation2.text")); // NOI18N
        bcLemmatisation2.setName("bcLemmatisation2"); // NOI18N
        bcLemmatisation2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bcLemmatisation2ActionPerformed(evt);
            }
        });
        pcLancementArticles2.add(bcLemmatisation2);

        bcCapture.setText(resourceMap.getString("bcCapture.text")); // NOI18N
        bcCapture.setName("bcCapture"); // NOI18N
        bcCapture.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bcCaptureActionPerformed(evt);
            }
        });
        pcLancementArticles2.add(bcCapture);

        lcNbFlux.setText(resourceMap.getString("lcNbFlux.text")); // NOI18N
        lcNbFlux.setName("lcNbFlux"); // NOI18N
        pcLancementArticles2.add(lcNbFlux);

        pcLancementArticles.add(pcLancementArticles2, java.awt.BorderLayout.CENTER);

        pcLancement.add(pcLancementArticles);

        pcLancementSujets.setName("pcLancementSujets"); // NOI18N
        pcLancementSujets.setLayout(new java.awt.BorderLayout());

        jLabel25.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jLabel25.setText(resourceMap.getString("jLabel25.text")); // NOI18N
        jLabel25.setName("jLabel25"); // NOI18N
        pcLancementSujets.add(jLabel25, java.awt.BorderLayout.WEST);

        pcLancementSujets2.setName("pcLancementSujets2"); // NOI18N
        pcLancementSujets2.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.LEFT));

        bcCollecteSujets.setText(resourceMap.getString("bcCollecteSujets.text")); // NOI18N
        bcCollecteSujets.setName("bcCollecteSujets"); // NOI18N
        bcCollecteSujets.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bcCollecteSujetsActionPerformed(evt);
            }
        });
        pcLancementSujets2.add(bcCollecteSujets);

        pcLancementSujets.add(pcLancementSujets2, java.awt.BorderLayout.CENTER);

        pcLancement.add(pcLancementSujets);

        pcTempsReel.setName("pcTempsReel"); // NOI18N
        pcTempsReel.setLayout(new java.awt.BorderLayout());

        jLabel28.setText(resourceMap.getString("jLabel28.text")); // NOI18N
        jLabel28.setName("jLabel28"); // NOI18N
        pcTempsReel.add(jLabel28, java.awt.BorderLayout.LINE_START);

        pcTempsReel2.setName("pcTempsReel2"); // NOI18N
        pcTempsReel2.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.LEFT));

        tcDelaiCollecte.setColumns(2);
        tcDelaiCollecte.setFormatterFactory(new javax.swing.text.DefaultFormatterFactory(new javax.swing.text.NumberFormatter(new java.text.DecimalFormat("#0"))));
        tcDelaiCollecte.setHorizontalAlignment(javax.swing.JTextField.TRAILING);
        tcDelaiCollecte.setText(resourceMap.getString("tcDelaiCollecte.text")); // NOI18N
        tcDelaiCollecte.setName("tcDelaiCollecte"); // NOI18N
        tcDelaiCollecte.addPropertyChangeListener(new java.beans.PropertyChangeListener() {
            public void propertyChange(java.beans.PropertyChangeEvent evt) {
                tcDelaiCollectePropertyChange(evt);
            }
        });
        pcTempsReel2.add(tcDelaiCollecte);

        jLabel38.setText(resourceMap.getString("jLabel38.text")); // NOI18N
        jLabel38.setName("jLabel38"); // NOI18N
        pcTempsReel2.add(jLabel38);

        pcTempsReel.add(pcTempsReel2, java.awt.BorderLayout.CENTER);

        pcLancement.add(pcTempsReel);

        pcDiffere.setName("pcDiffere"); // NOI18N
        pcDiffere.setLayout(new java.awt.BorderLayout());

        jLabel26.setText(resourceMap.getString("jLabel26.text")); // NOI18N
        jLabel26.setName("jLabel26"); // NOI18N
        pcDiffere.add(jLabel26, java.awt.BorderLayout.WEST);

        pcDiffere2.setName("pcDiffere2"); // NOI18N
        pcDiffere2.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.LEFT));

        bcToutCorpus.setSelected(true);
        bcToutCorpus.setText(resourceMap.getString("bcToutCorpus.text")); // NOI18N
        bcToutCorpus.setName("bcToutCorpus"); // NOI18N
        bcToutCorpus.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bcToutCorpusActionPerformed(evt);
            }
        });
        pcDiffere2.add(bcToutCorpus);

        bcCorpusPartiel.setText(resourceMap.getString("bcCorpusPartiel.text")); // NOI18N
        bcCorpusPartiel.setName("bcCorpusPartiel"); // NOI18N
        bcCorpusPartiel.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bcCorpusPartielActionPerformed(evt);
            }
        });
        pcDiffere2.add(bcCorpusPartiel);

        bcCorpusJour.setText(resourceMap.getString("bcCorpusJour.text")); // NOI18N
        bcCorpusJour.setName("bcCorpusJour"); // NOI18N
        bcCorpusJour.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bcCorpusJourActionPerformed(evt);
            }
        });
        pcDiffere2.add(bcCorpusJour);

        tcCorpusPartielDate.setColumns(6);
        tcCorpusPartielDate.setFormatterFactory(new javax.swing.text.DefaultFormatterFactory(new javax.swing.text.DateFormatter(java.text.DateFormat.getDateInstance(java.text.DateFormat.SHORT))));
        tcCorpusPartielDate.setHorizontalAlignment(javax.swing.JTextField.CENTER);
        tcCorpusPartielDate.setText(resourceMap.getString("tcCorpusPartielDate.text")); // NOI18N
        tcCorpusPartielDate.setName("tcCorpusPartielDate"); // NOI18N
        pcDiffere2.add(tcCorpusPartielDate);

        pcDiffere.add(pcDiffere2, java.awt.BorderLayout.CENTER);

        pcLancement.add(pcDiffere);

        pSousCorpus.add(pcLancement, java.awt.BorderLayout.PAGE_START);

        pcSelection.setName("pcSelection"); // NOI18N
        pcSelection.setLayout(new java.awt.BorderLayout());
        pSousCorpus.add(pcSelection, java.awt.BorderLayout.CENTER);

        tpCollecte.addTab(resourceMap.getString("pSousCorpus.TabConstraints.tabTitle"), pSousCorpus); // NOI18N

        pCollecte.setName("pCollecte"); // NOI18N
        pCollecte.setLayout(new java.awt.BorderLayout());

        lcEtat2.setText(resourceMap.getString("lcEtat2.text")); // NOI18N
        lcEtat2.setName("lcEtat2"); // NOI18N
        pCollecte.add(lcEtat2, java.awt.BorderLayout.SOUTH);

        pcProcess.setName("pcProcess"); // NOI18N
        pcProcess.setLayout(new java.awt.GridLayout(2, 0));

        lcEtat.setText(resourceMap.getString("lcEtat.text")); // NOI18N
        lcEtat.setName("lcEtat"); // NOI18N
        pcProcess.add(lcEtat);

        pcProcess2.setName("pcProcess2"); // NOI18N
        pcProcess2.setLayout(new java.awt.GridLayout(1, 2));

        lcLemmatisation.setText(resourceMap.getString("lcLemmatisation.text")); // NOI18N
        lcLemmatisation.setName("lcLemmatisation"); // NOI18N
        pcProcess2.add(lcLemmatisation);

        lcCapture.setText(resourceMap.getString("lcCapture.text")); // NOI18N
        lcCapture.setName("lcCapture"); // NOI18N
        pcProcess2.add(lcCapture);

        pcProcess.add(pcProcess2);

        pCollecte.add(pcProcess, java.awt.BorderLayout.NORTH);

        pCollecte2.setName("pCollecte2"); // NOI18N
        pCollecte2.setLayout(new java.awt.BorderLayout());

        spCollecte.setName("spCollecte"); // NOI18N

        lCollecte.setFont(lCollecte.getFont());
        lCollecte.setEnabled(false);
        lCollecte.setFocusable(false);
        lCollecte.setName("lCollecte"); // NOI18N
        lCollecte.setRequestFocusEnabled(false);
        spCollecte.setViewportView(lCollecte);

        pCollecte2.add(spCollecte, java.awt.BorderLayout.CENTER);

        jSeparator3.setName("jSeparator3"); // NOI18N
        pCollecte2.add(jSeparator3, java.awt.BorderLayout.NORTH);

        pCollecte.add(pCollecte2, java.awt.BorderLayout.CENTER);

        tpCollecte.addTab(resourceMap.getString("pCollecte.TabConstraints.tabTitle"), pCollecte); // NOI18N

        pSujets.setName("pSujets"); // NOI18N
        pSujets.setLayout(new java.awt.BorderLayout());

        lcEtat3.setText(resourceMap.getString("lcEtat3.text")); // NOI18N
        lcEtat3.setName("lcEtat3"); // NOI18N
        pSujets.add(lcEtat3, java.awt.BorderLayout.NORTH);

        spCollecteSujets.setName("spCollecteSujets"); // NOI18N

        lCollecteSujets.setName("lCollecteSujets"); // NOI18N
        spCollecteSujets.setViewportView(lCollecteSujets);

        pSujets.add(spCollecteSujets, java.awt.BorderLayout.CENTER);

        tpCollecte.addTab(resourceMap.getString("pSujets.TabConstraints.tabTitle"), pSujets); // NOI18N

        tpPrincipal.addTab(resourceMap.getString("tpCollecte.TabConstraints.tabTitle"), tpCollecte); // NOI18N

        tpExperiences.setName("tpExperiences"); // NOI18N

        peFichiers.setName("peFichiers"); // NOI18N
        peFichiers.setLayout(new java.awt.GridLayout(1, 2, 10, 0));

        peFichiers1.setName("peFichiers1"); // NOI18N
        peFichiers1.setLayout(null);

        befInclArticles.setText(resourceMap.getString("befInclArticles.text")); // NOI18N
        befInclArticles.setHorizontalAlignment(javax.swing.SwingConstants.LEADING);
        befInclArticles.setName("befInclArticles"); // NOI18N
        befInclArticles.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                befInclArticlesActionPerformed(evt);
            }
        });
        peFichiers1.add(befInclArticles);
        befInclArticles.setBounds(0, 220, 350, 23);

        befInclInstances.setText(resourceMap.getString("befInclInstances.text")); // NOI18N
        befInclInstances.setHorizontalAlignment(javax.swing.SwingConstants.LEADING);
        befInclInstances.setName("befInclInstances"); // NOI18N
        befInclInstances.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                befInclInstancesActionPerformed(evt);
            }
        });
        peFichiers1.add(befInclInstances);
        befInclInstances.setBounds(0, 320, 350, 23);

        lefLignesLuesInstances.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        lefLignesLuesInstances.setText(resourceMap.getString("lefLignesLuesInstances.text")); // NOI18N
        lefLignesLuesInstances.setName("lefLignesLuesInstances"); // NOI18N
        peFichiers1.add(lefLignesLuesInstances);
        lefLignesLuesInstances.setBounds(0, 340, 350, 20);

        jLabel22.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jLabel22.setText(resourceMap.getString("jLabel22.text")); // NOI18N
        jLabel22.setName("jLabel22"); // NOI18N
        peFichiers1.add(jLabel22);
        jLabel22.setBounds(0, 10, 350, 14);

        jLabel23.setText(resourceMap.getString("jLabel23.text")); // NOI18N
        jLabel23.setName("jLabel23"); // NOI18N
        peFichiers1.add(jLabel23);
        jLabel23.setBounds(0, 30, 350, 50);

        befInclIPTC.setText(resourceMap.getString("befInclIPTC.text")); // NOI18N
        befInclIPTC.setHorizontalAlignment(javax.swing.SwingConstants.LEADING);
        befInclIPTC.setName("befInclIPTC"); // NOI18N
        befInclIPTC.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                befInclIPTCActionPerformed(evt);
            }
        });
        peFichiers1.add(befInclIPTC);
        befInclIPTC.setBounds(0, 80, 350, 23);

        lefLignesLuesIPTC.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        lefLignesLuesIPTC.setText(resourceMap.getString("lefLignesLuesIPTC.text")); // NOI18N
        lefLignesLuesIPTC.setName("lefLignesLuesIPTC"); // NOI18N
        peFichiers1.add(lefLignesLuesIPTC);
        lefLignesLuesIPTC.setBounds(0, 100, 350, 20);

        jLabel42.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jLabel42.setText(resourceMap.getString("jLabel42.text")); // NOI18N
        jLabel42.setName("jLabel42"); // NOI18N
        peFichiers1.add(jLabel42);
        jLabel42.setBounds(0, 140, 350, 14);

        befInclOnto.setText(resourceMap.getString("befInclOnto.text")); // NOI18N
        befInclOnto.setHorizontalAlignment(javax.swing.SwingConstants.LEADING);
        befInclOnto.setName("befInclOnto"); // NOI18N
        befInclOnto.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                befInclOntoActionPerformed(evt);
            }
        });
        peFichiers1.add(befInclOnto);
        befInclOnto.setBounds(0, 360, 350, 23);

        jLabel43.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jLabel43.setText(resourceMap.getString("jLabel43.text")); // NOI18N
        jLabel43.setName("jLabel43"); // NOI18N
        peFichiers1.add(jLabel43);
        jLabel43.setBounds(0, 520, 350, 14);

        befInclAbstract.setText(resourceMap.getString("befInclAbstract.text")); // NOI18N
        befInclAbstract.setHorizontalAlignment(javax.swing.SwingConstants.LEADING);
        befInclAbstract.setName("befInclAbstract"); // NOI18N
        befInclAbstract.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                befInclAbstractActionPerformed(evt);
            }
        });
        peFichiers1.add(befInclAbstract);
        befInclAbstract.setBounds(0, 250, 350, 23);

        jSeparator2.setName("jSeparator2"); // NOI18N
        peFichiers1.add(jSeparator2);
        jSeparator2.setBounds(0, 130, 350, 2);

        befLemConcepts.setText(resourceMap.getString("befLemConcepts.text")); // NOI18N
        befLemConcepts.setHorizontalAlignment(javax.swing.SwingConstants.LEADING);
        befLemConcepts.setName("befLemConcepts"); // NOI18N
        befLemConcepts.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                befLemConceptsActionPerformed(evt);
            }
        });
        peFichiers1.add(befLemConcepts);
        befLemConcepts.setBounds(0, 280, 350, 23);

        lefLemmaConcepts.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        lefLemmaConcepts.setText(resourceMap.getString("lefLemmaConcepts.text")); // NOI18N
        lefLemmaConcepts.setName("lefLemmaConcepts"); // NOI18N
        peFichiers1.add(lefLemmaConcepts);
        lefLemmaConcepts.setBounds(0, 300, 350, 20);

        befInclCategories.setText(resourceMap.getString("befInclCategories.text")); // NOI18N
        befInclCategories.setHorizontalAlignment(javax.swing.SwingConstants.LEADING);
        befInclCategories.setName("befInclCategories"); // NOI18N
        befInclCategories.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                befInclCategoriesActionPerformed(evt);
            }
        });
        peFichiers1.add(befInclCategories);
        befInclCategories.setBounds(0, 400, 350, 23);

        lefLignesLuesCategories.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        lefLignesLuesCategories.setText(resourceMap.getString("lefLignesLuesCategories.text")); // NOI18N
        lefLignesLuesCategories.setName("lefLignesLuesCategories"); // NOI18N
        peFichiers1.add(lefLignesLuesCategories);
        lefLignesLuesCategories.setBounds(0, 420, 350, 20);

        jLabel2.setText(resourceMap.getString("jLabel2.text")); // NOI18N
        jLabel2.setName("jLabel2"); // NOI18N
        peFichiers1.add(jLabel2);
        jLabel2.setBounds(0, 160, 350, 60);

        befInclCateLabels.setText(resourceMap.getString("befInclCateLabels.text")); // NOI18N
        befInclCateLabels.setHorizontalAlignment(javax.swing.SwingConstants.LEADING);
        befInclCateLabels.setName("befInclCateLabels"); // NOI18N
        befInclCateLabels.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                befInclCateLabelsActionPerformed(evt);
            }
        });
        peFichiers1.add(befInclCateLabels);
        befInclCateLabels.setBounds(0, 440, 350, 23);

        lefLignesLuesCateLabels.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        lefLignesLuesCateLabels.setText(resourceMap.getString("lefLignesLuesCateLabels.text")); // NOI18N
        lefLignesLuesCateLabels.setHorizontalTextPosition(javax.swing.SwingConstants.LEADING);
        lefLignesLuesCateLabels.setName("lefLignesLuesCateLabels"); // NOI18N
        peFichiers1.add(lefLignesLuesCateLabels);
        lefLignesLuesCateLabels.setBounds(0, 460, 350, 20);

        jButton1.setText(resourceMap.getString("jButton1.text")); // NOI18N
        jButton1.setHorizontalAlignment(javax.swing.SwingConstants.LEADING);
        jButton1.setName("jButton1"); // NOI18N
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton1ActionPerformed(evt);
            }
        });
        peFichiers1.add(jButton1);
        jButton1.setBounds(0, 480, 350, 23);

        lefLemmaCategories.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        lefLemmaCategories.setText(resourceMap.getString("lefLemmaCategories.text")); // NOI18N
        lefLemmaCategories.setName("lefLemmaCategories"); // NOI18N
        peFichiers1.add(lefLemmaCategories);
        lefLemmaCategories.setBounds(0, 500, 350, 20);

        lefLignesLuesOntologie.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        lefLignesLuesOntologie.setText(resourceMap.getString("lefLignesLuesOntologie.text")); // NOI18N
        lefLignesLuesOntologie.setName("lefLignesLuesOntologie"); // NOI18N
        peFichiers1.add(lefLignesLuesOntologie);
        lefLignesLuesOntologie.setBounds(0, 380, 350, 20);

        peFichiers.add(peFichiers1);

        peFichiers2.setName("peFichiers2"); // NOI18N
        peFichiers2.setLayout(null);

        jLabel3.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jLabel3.setText(resourceMap.getString("jLabel3.text")); // NOI18N
        jLabel3.setName("jLabel3"); // NOI18N
        peFichiers2.add(jLabel3);
        jLabel3.setBounds(0, 10, 350, 14);

        lefLienOnto.setText(resourceMap.getString("lefLienOnto.text")); // NOI18N
        lefLienOnto.setName("lefLienOnto"); // NOI18N
        lefLienOnto.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                lefLienOntoActionPerformed(evt);
            }
        });
        peFichiers2.add(lefLienOnto);
        lefLienOnto.setBounds(10, 30, 340, 23);

        lefOntoLie.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        lefOntoLie.setText(resourceMap.getString("lefOntoLie.text")); // NOI18N
        lefOntoLie.setName("lefOntoLie"); // NOI18N
        peFichiers2.add(lefOntoLie);
        lefOntoLie.setBounds(10, 50, 340, 20);

        lefLienWiki.setText(resourceMap.getString("lefLienWiki.text")); // NOI18N
        lefLienWiki.setName("lefLienWiki"); // NOI18N
        lefLienWiki.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                lefLienWikiActionPerformed(evt);
            }
        });
        peFichiers2.add(lefLienWiki);
        lefLienWiki.setBounds(10, 70, 340, 23);

        lefWikiLie.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        lefWikiLie.setText(resourceMap.getString("lefWikiLie.text")); // NOI18N
        lefWikiLie.setName("lefWikiLie"); // NOI18N
        peFichiers2.add(lefWikiLie);
        lefWikiLie.setBounds(10, 90, 340, 20);

        lefPretraitementOnto.setText(resourceMap.getString("lefPretraitementOnto.text")); // NOI18N
        lefPretraitementOnto.setName("lefPretraitementOnto"); // NOI18N
        peFichiers2.add(lefPretraitementOnto);
        lefPretraitementOnto.setBounds(10, 110, 340, 23);

        lefPretraitementWiki.setText(resourceMap.getString("lefPretraitementWiki.text")); // NOI18N
        lefPretraitementWiki.setName("lefPretraitementWiki"); // NOI18N
        peFichiers2.add(lefPretraitementWiki);
        lefPretraitementWiki.setBounds(10, 150, 340, 23);

        peFichiers.add(peFichiers2);

        tpExperiences.addTab(resourceMap.getString("peFichiers.TabConstraints.tabTitle"), peFichiers); // NOI18N

        peExperiences2.setName("peExperiences2"); // NOI18N
        peExperiences2.setLayout(new java.awt.BorderLayout());

        peeExperiences2.setName("peeExperiences2"); // NOI18N
        peeExperiences2.setLayout(new java.awt.BorderLayout());

        peeCorpus2.setName("peeCorpus2"); // NOI18N
        peeCorpus2.setPreferredSize(new java.awt.Dimension(690, 110));
        peeCorpus2.setLayout(null);

        leeCTitre2.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        leeCTitre2.setText(resourceMap.getString("leeCTitre2.text")); // NOI18N
        leeCTitre2.setName("leeCTitre2"); // NOI18N
        peeCorpus2.add(leeCTitre2);
        leeCTitre2.setBounds(10, 0, 680, 14);

        leeCDesc2.setText(resourceMap.getString("leeCDesc2.text")); // NOI18N
        leeCDesc2.setName("leeCDesc2"); // NOI18N
        peeCorpus2.add(leeCDesc2);
        leeCDesc2.setBounds(10, 20, 680, 20);

        jLabel24.setText(resourceMap.getString("jLabel24.text")); // NOI18N
        jLabel24.setName("jLabel24"); // NOI18N
        peeCorpus2.add(jLabel24);
        jLabel24.setBounds(10, 40, 300, 20);

        teeCNbArticles2.setFormatterFactory(new javax.swing.text.DefaultFormatterFactory(new javax.swing.text.NumberFormatter(new java.text.DecimalFormat("#0"))));
        teeCNbArticles2.setText(resourceMap.getString("teeCNbArticles2.text")); // NOI18N
        teeCNbArticles2.setName("teeCNbArticles2"); // NOI18N
        peeCorpus2.add(teeCNbArticles2);
        teeCNbArticles2.setBounds(310, 40, 40, 20);

        beeCNew2.setText(resourceMap.getString("beeCNew2.text")); // NOI18N
        beeCNew2.setName("beeCNew2"); // NOI18N
        beeCNew2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                beeCNew2ActionPerformed(evt);
            }
        });
        peeCorpus2.add(beeCNew2);
        beeCNew2.setBounds(400, 40, 80, 23);

        jLabel4.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jLabel4.setText(resourceMap.getString("jLabel4.text")); // NOI18N
        jLabel4.setName("jLabel4"); // NOI18N
        peeCorpus2.add(jLabel4);
        jLabel4.setBounds(350, 40, 50, 20);

        leecLoadStatus2.setText(resourceMap.getString("leecLoadStatus2.text")); // NOI18N
        leecLoadStatus2.setName("leecLoadStatus2"); // NOI18N
        peeCorpus2.add(leecLoadStatus2);
        leecLoadStatus2.setBounds(490, 40, 220, 20);

        peeExperiences2.add(peeCorpus2, java.awt.BorderLayout.PAGE_START);

        speExperiences2.setName("speExperiences2"); // NOI18N
        peeExperiences2.add(speExperiences2, java.awt.BorderLayout.CENTER);

        peExperiences2.add(peeExperiences2, java.awt.BorderLayout.CENTER);

        tpExperiences.addTab(resourceMap.getString("peExperiences2.TabConstraints.tabTitle"), peExperiences2); // NOI18N

        peExperiences.setName("peExperiences"); // NOI18N
        peExperiences.setLayout(new java.awt.BorderLayout());

        peeExperiences.setName("peeExperiences"); // NOI18N
        peeExperiences.setLayout(new java.awt.BorderLayout());

        peeCorpus.setName("peeCorpus"); // NOI18N
        peeCorpus.setPreferredSize(new java.awt.Dimension(690, 110));
        peeCorpus.setLayout(null);

        leeCTitre.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        leeCTitre.setText(resourceMap.getString("leeCTitre.text")); // NOI18N
        leeCTitre.setName("leeCTitre"); // NOI18N
        peeCorpus.add(leeCTitre);
        leeCTitre.setBounds(10, 0, 680, 14);

        leeCDesc.setText(resourceMap.getString("leeCDesc.text")); // NOI18N
        leeCDesc.setName("leeCDesc"); // NOI18N
        peeCorpus.add(leeCDesc);
        leeCDesc.setBounds(10, 20, 680, 20);

        jLabel20.setText(resourceMap.getString("jLabel20.text")); // NOI18N
        jLabel20.setName("jLabel20"); // NOI18N
        peeCorpus.add(jLabel20);
        jLabel20.setBounds(20, 50, 130, 20);

        beeCLoad.setText(resourceMap.getString("beeCLoad.text")); // NOI18N
        beeCLoad.setName("beeCLoad"); // NOI18N
        beeCLoad.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                beeCLoadActionPerformed(evt);
            }
        });
        peeCorpus.add(beeCLoad);
        beeCLoad.setBounds(150, 50, 90, 23);

        jLabel18.setText(resourceMap.getString("jLabel18.text")); // NOI18N
        jLabel18.setName("jLabel18"); // NOI18N
        peeCorpus.add(jLabel18);
        jLabel18.setBounds(20, 80, 150, 20);

        teeCNbArticles.setFormatterFactory(new javax.swing.text.DefaultFormatterFactory(new javax.swing.text.NumberFormatter(new java.text.DecimalFormat("#0"))));
        teeCNbArticles.setText(resourceMap.getString("teeCNbArticles.text")); // NOI18N
        teeCNbArticles.setName("teeCNbArticles"); // NOI18N
        peeCorpus.add(teeCNbArticles);
        teeCNbArticles.setBounds(170, 80, 30, 20);

        jLabel9.setText(resourceMap.getString("jLabel9.text")); // NOI18N
        jLabel9.setName("jLabel9"); // NOI18N
        peeCorpus.add(jLabel9);
        jLabel9.setBounds(210, 80, 100, 20);

        beeCNew.setText(resourceMap.getString("beeCNew.text")); // NOI18N
        beeCNew.setName("beeCNew"); // NOI18N
        beeCNew.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                beeCNewActionPerformed(evt);
            }
        });
        peeCorpus.add(beeCNew);
        beeCNew.setBounds(310, 80, 80, 23);

        jSeparator5.setOrientation(javax.swing.SwingConstants.VERTICAL);
        jSeparator5.setName("jSeparator5"); // NOI18N
        peeCorpus.add(jSeparator5);
        jSeparator5.setBounds(10, 40, 10, 50);

        jSeparator7.setName("jSeparator7"); // NOI18N
        peeCorpus.add(jSeparator7);
        jSeparator7.setBounds(10, 60, 10, 10);

        jSeparator6.setName("jSeparator6"); // NOI18N
        peeCorpus.add(jSeparator6);
        jSeparator6.setBounds(10, 90, 10, 10);

        leeCLoadStatus.setText(resourceMap.getString("leeCLoadStatus.text")); // NOI18N
        leeCLoadStatus.setName("leeCLoadStatus"); // NOI18N
        peeCorpus.add(leeCLoadStatus);
        leeCLoadStatus.setBounds(250, 50, 440, 20);

        leeCNewStatus.setText(resourceMap.getString("leeCNewStatus.text")); // NOI18N
        leeCNewStatus.setName("leeCNewStatus"); // NOI18N
        peeCorpus.add(leeCNewStatus);
        leeCNewStatus.setBounds(400, 80, 290, 20);

        peeExperiences.add(peeCorpus, java.awt.BorderLayout.NORTH);

        speExperiences.setName("speExperiences"); // NOI18N
        peeExperiences.add(speExperiences, java.awt.BorderLayout.CENTER);

        peExperiences.add(peeExperiences, java.awt.BorderLayout.CENTER);

        tpExperiences.addTab(resourceMap.getString("peExperiences.TabConstraints.tabTitle"), peExperiences); // NOI18N

        peThesaurus.setName("peThesaurus"); // NOI18N
        peThesaurus.setLayout(new java.awt.BorderLayout());

        leThesaurus.setText(resourceMap.getString("leThesaurus.text")); // NOI18N
        leThesaurus.setName("leThesaurus"); // NOI18N
        peThesaurus.add(leThesaurus, java.awt.BorderLayout.PAGE_START);

        speThesaurus.setName("speThesaurus"); // NOI18N

        teThesaurus.setBackground(resourceMap.getColor("teThesaurus.background")); // NOI18N
        treeNode1 = new javax.swing.tree.DefaultMutableTreeNode("Taxonomie IPTC");
        teThesaurus.setModel(new javax.swing.tree.DefaultTreeModel(treeNode1));
        teThesaurus.setName("teThesaurus"); // NOI18N
        teThesaurus.setRowHeight(30);
        speThesaurus.setViewportView(teThesaurus);

        peThesaurus.add(speThesaurus, java.awt.BorderLayout.CENTER);

        tpExperiences.addTab(resourceMap.getString("peThesaurus.TabConstraints.tabTitle"), peThesaurus); // NOI18N

        peCorpus.setName("peCorpus"); // NOI18N
        peCorpus.setLayout(new java.awt.BorderLayout());

        speCorpus.setName("speCorpus"); // NOI18N
        peCorpus.add(speCorpus, java.awt.BorderLayout.CENTER);

        tpExperiences.addTab(resourceMap.getString("peCorpus.TabConstraints.tabTitle"), peCorpus); // NOI18N

        peSparql.setName("peSparql"); // NOI18N
        peSparql.setLayout(null);

        lesRequete.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        lesRequete.setText(resourceMap.getString("lesRequete.text")); // NOI18N
        lesRequete.setName("lesRequete"); // NOI18N
        peSparql.add(lesRequete);
        lesRequete.setBounds(0, 0, 710, 14);

        spesRequete.setName("spesRequete"); // NOI18N

        taesRequete.setColumns(20);
        taesRequete.setLineWrap(true);
        taesRequete.setRows(5);
        taesRequete.setText(resourceMap.getString("taesRequete.text")); // NOI18N
        taesRequete.setWrapStyleWord(true);
        taesRequete.setName("taesRequete"); // NOI18N
        spesRequete.setViewportView(taesRequete);

        peSparql.add(spesRequete);
        spesRequete.setBounds(0, 24, 716, 230);

        besRequete.setText(resourceMap.getString("besRequete.text")); // NOI18N
        besRequete.setName("besRequete"); // NOI18N
        besRequete.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                besRequeteActionPerformed(evt);
            }
        });
        peSparql.add(besRequete);
        besRequete.setBounds(260, 260, 190, 23);

        spesReponse.setName("spesReponse"); // NOI18N

        taesReponse.setColumns(20);
        taesReponse.setEditable(false);
        taesReponse.setLineWrap(true);
        taesReponse.setRows(5);
        taesReponse.setText(resourceMap.getString("taesReponse.text")); // NOI18N
        taesReponse.setWrapStyleWord(true);
        taesReponse.setName("taesReponse"); // NOI18N
        spesReponse.setViewportView(taesReponse);

        peSparql.add(spesReponse);
        spesReponse.setBounds(0, 313, 716, 260);

        lesReponse.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        lesReponse.setText(resourceMap.getString("lesReponse.text")); // NOI18N
        lesReponse.setName("lesReponse"); // NOI18N
        peSparql.add(lesReponse);
        lesReponse.setBounds(0, 290, 710, 14);

        tpExperiences.addTab(resourceMap.getString("peSparql.TabConstraints.tabTitle"), peSparql); // NOI18N

        peExperiencesOld.setName("peExperiencesOld"); // NOI18N
        peExperiencesOld.setLayout(new java.awt.GridLayout(1, 2, 10, 0));

        peExperiencesOld1.setName("peExperiencesOld1"); // NOI18N
        peExperiencesOld1.setLayout(null);

        leeo1Titre.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        leeo1Titre.setText(resourceMap.getString("leeo1Titre.text")); // NOI18N
        leeo1Titre.setName("leeo1Titre"); // NOI18N
        peExperiencesOld1.add(leeo1Titre);
        leeo1Titre.setBounds(0, 0, 350, 14);

        beeoRecupArticles.setText(resourceMap.getString("beeoRecupArticles.text")); // NOI18N
        beeoRecupArticles.setToolTipText(resourceMap.getString("beeoRecupArticles.toolTipText")); // NOI18N
        beeoRecupArticles.setName("beeoRecupArticles"); // NOI18N
        beeoRecupArticles.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                beeoRecupArticlesActionPerformed(evt);
            }
        });
        peExperiencesOld1.add(beeoRecupArticles);
        beeoRecupArticles.setBounds(0, 60, 350, 23);

        jLabel11.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jLabel11.setText(resourceMap.getString("jLabel11.text")); // NOI18N
        jLabel11.setName("jLabel11"); // NOI18N
        peExperiencesOld1.add(jLabel11);
        jLabel11.setBounds(0, 90, 350, 14);

        beeoSetCorpus.setText(resourceMap.getString("beeoSetCorpus.text")); // NOI18N
        beeoSetCorpus.setToolTipText(resourceMap.getString("beeoSetCorpus.toolTipText")); // NOI18N
        beeoSetCorpus.setName("beeoSetCorpus"); // NOI18N
        beeoSetCorpus.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                beeoSetCorpusActionPerformed(evt);
            }
        });
        peExperiencesOld1.add(beeoSetCorpus);
        beeoSetCorpus.setBounds(0, 110, 350, 23);

        jLabel12.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jLabel12.setText(resourceMap.getString("jLabel12.text")); // NOI18N
        jLabel12.setName("jLabel12"); // NOI18N
        peExperiencesOld1.add(jLabel12);
        jLabel12.setBounds(0, 140, 350, 14);

        beeoLoadCorpus.setText(resourceMap.getString("beeoLoadCorpus.text")); // NOI18N
        beeoLoadCorpus.setToolTipText(resourceMap.getString("beeoLoadCorpus.toolTipText")); // NOI18N
        beeoLoadCorpus.setName("beeoLoadCorpus"); // NOI18N
        beeoLoadCorpus.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                beeoLoadCorpusActionPerformed(evt);
            }
        });
        peExperiencesOld1.add(beeoLoadCorpus);
        beeoLoadCorpus.setBounds(0, 180, 350, 23);

        jLabel16.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jLabel16.setText(resourceMap.getString("jLabel16.text")); // NOI18N
        jLabel16.setName("jLabel16"); // NOI18N
        peExperiencesOld1.add(jLabel16);
        jLabel16.setBounds(0, 210, 350, 14);

        beeoSaveCorpus.setText(resourceMap.getString("beeoSaveCorpus.text")); // NOI18N
        beeoSaveCorpus.setToolTipText(resourceMap.getString("beeoSaveCorpus.toolTipText")); // NOI18N
        beeoSaveCorpus.setName("beeoSaveCorpus"); // NOI18N
        beeoSaveCorpus.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                beeoSaveCorpusActionPerformed(evt);
            }
        });
        peExperiencesOld1.add(beeoSaveCorpus);
        beeoSaveCorpus.setBounds(0, 240, 350, 23);

        jLabel17.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jLabel17.setText(resourceMap.getString("jLabel17.text")); // NOI18N
        jLabel17.setName("jLabel17"); // NOI18N
        peExperiencesOld1.add(jLabel17);
        jLabel17.setBounds(0, 270, 350, 14);

        beeoExpDBPedia.setText(resourceMap.getString("beeoExpDBPedia.text")); // NOI18N
        beeoExpDBPedia.setToolTipText(resourceMap.getString("beeoExpDBPedia.toolTipText")); // NOI18N
        beeoExpDBPedia.setName("beeoExpDBPedia"); // NOI18N
        beeoExpDBPedia.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                beeoExpDBPediaActionPerformed(evt);
            }
        });
        peExperiencesOld1.add(beeoExpDBPedia);
        beeoExpDBPedia.setBounds(0, 360, 350, 23);

        jLabel13.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jLabel13.setText(resourceMap.getString("jLabel13.text")); // NOI18N
        jLabel13.setName("jLabel13"); // NOI18N
        peExperiencesOld1.add(jLabel13);
        jLabel13.setBounds(0, 390, 350, 14);

        jLabel30.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jLabel30.setText(resourceMap.getString("jLabel30.text")); // NOI18N
        jLabel30.setName("jLabel30"); // NOI18N
        peExperiencesOld1.add(jLabel30);
        jLabel30.setBounds(0, 160, 350, 14);

        jLabel37.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jLabel37.setText(resourceMap.getString("jLabel37.text")); // NOI18N
        jLabel37.setName("jLabel37"); // NOI18N
        peExperiencesOld1.add(jLabel37);
        jLabel37.setBounds(0, 410, 350, 14);

        jSeparator1.setName("jSeparator1"); // NOI18N
        peExperiencesOld1.add(jSeparator1);
        jSeparator1.setBounds(0, 230, 350, 10);

        beeoThematiques.setText(resourceMap.getString("beeoThematiques.text")); // NOI18N
        beeoThematiques.setToolTipText(resourceMap.getString("beeoThematiques.toolTipText")); // NOI18N
        beeoThematiques.setName("beeoThematiques"); // NOI18N
        beeoThematiques.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                beeoThematiquesActionPerformed(evt);
            }
        });
        peExperiencesOld1.add(beeoThematiques);
        beeoThematiques.setBounds(0, 430, 350, 23);

        jFormattedTextField10.setColumns(3);
        jFormattedTextField10.setFormatterFactory(new javax.swing.text.DefaultFormatterFactory(new javax.swing.text.NumberFormatter(new java.text.DecimalFormat("#0"))));
        jFormattedTextField10.setText(resourceMap.getString("jFormattedTextField10.text")); // NOI18N
        jFormattedTextField10.setName("jFormattedTextField10"); // NOI18N
        peExperiencesOld1.add(jFormattedTextField10);
        jFormattedTextField10.setBounds(250, 30, 30, 20);

        jLabel1.setText(resourceMap.getString("jLabel1.text")); // NOI18N
        jLabel1.setName("jLabel1"); // NOI18N
        peExperiencesOld1.add(jLabel1);
        jLabel1.setBounds(70, 30, 175, 20);

        beeoCalculDirect.setText(resourceMap.getString("beeoCalculDirect.text")); // NOI18N
        beeoCalculDirect.setToolTipText(resourceMap.getString("beeoCalculDirect.toolTipText")); // NOI18N
        beeoCalculDirect.setName("beeoCalculDirect"); // NOI18N
        beeoCalculDirect.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                beeoCalculDirectActionPerformed(evt);
            }
        });
        peExperiencesOld1.add(beeoCalculDirect);
        beeoCalculDirect.setBounds(0, 290, 350, 23);

        jLabel19.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jLabel19.setText(resourceMap.getString("jLabel19.text")); // NOI18N
        jLabel19.setName("jLabel19"); // NOI18N
        peExperiencesOld1.add(jLabel19);
        jLabel19.setBounds(0, 320, 350, 14);

        jLabel40.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jLabel40.setText(resourceMap.getString("jLabel40.text")); // NOI18N
        jLabel40.setName("jLabel40"); // NOI18N
        peExperiencesOld1.add(jLabel40);
        jLabel40.setBounds(0, 340, 350, 14);

        peExperiencesOld.add(peExperiencesOld1);

        peExperiencesOld2.setName("peExperiencesOld2"); // NOI18N
        peExperiencesOld2.setLayout(null);

        leeo2Titre.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        leeo2Titre.setText(resourceMap.getString("leeo2Titre.text")); // NOI18N
        leeo2Titre.setName("leeo2Titre"); // NOI18N
        peExperiencesOld2.add(leeo2Titre);
        leeo2Titre.setBounds(0, 0, 350, 14);

        jFormattedTextField1.setColumns(2);
        jFormattedTextField1.setFormatterFactory(new javax.swing.text.DefaultFormatterFactory(new javax.swing.text.NumberFormatter(new java.text.DecimalFormat("#0"))));
        jFormattedTextField1.setText(resourceMap.getString("jFormattedTextField1.text")); // NOI18N
        jFormattedTextField1.setName("jFormattedTextField1"); // NOI18N
        peExperiencesOld2.add(jFormattedTextField1);
        jFormattedTextField1.setBounds(320, 20, 30, 20);

        jLabel14.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jLabel14.setText(resourceMap.getString("jLabel14.text")); // NOI18N
        jLabel14.setName("jLabel14"); // NOI18N
        peExperiencesOld2.add(jLabel14);
        jLabel14.setBounds(310, 20, 10, 20);

        beeExtractionJour.setText(resourceMap.getString("beeExtractionJour.text")); // NOI18N
        beeExtractionJour.setName("beeExtractionJour"); // NOI18N
        beeExtractionJour.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                beeExtractionJourActionPerformed(evt);
            }
        });
        peExperiencesOld2.add(beeExtractionJour);
        beeExtractionJour.setBounds(0, 20, 250, 23);

        jFormattedTextField2.setColumns(2);
        jFormattedTextField2.setFormatterFactory(new javax.swing.text.DefaultFormatterFactory(new javax.swing.text.NumberFormatter(new java.text.DecimalFormat("#0"))));
        jFormattedTextField2.setName("jFormattedTextField2"); // NOI18N
        peExperiencesOld2.add(jFormattedTextField2);
        jFormattedTextField2.setBounds(260, 20, 20, 20);

        jLabel29.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jLabel29.setText(resourceMap.getString("jLabel29.text")); // NOI18N
        jLabel29.setName("jLabel29"); // NOI18N
        peExperiencesOld2.add(jLabel29);
        jLabel29.setBounds(280, 20, 10, 20);

        jFormattedTextField3.setColumns(2);
        jFormattedTextField3.setFormatterFactory(new javax.swing.text.DefaultFormatterFactory(new javax.swing.text.NumberFormatter(new java.text.DecimalFormat("#0"))));
        jFormattedTextField3.setName("jFormattedTextField3"); // NOI18N
        peExperiencesOld2.add(jFormattedTextField3);
        jFormattedTextField3.setBounds(290, 20, 20, 20);

        jLabel10.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jLabel10.setText(resourceMap.getString("jLabel10.text")); // NOI18N
        jLabel10.setName("jLabel10"); // NOI18N
        peExperiencesOld2.add(jLabel10);
        jLabel10.setBounds(0, 100, 350, 14);

        jLabel15.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jLabel15.setText(resourceMap.getString("jLabel15.text")); // NOI18N
        jLabel15.setName("jLabel15"); // NOI18N
        peExperiencesOld2.add(jLabel15);
        jLabel15.setBounds(0, 50, 350, 14);

        beeoExtractionEntre.setText(resourceMap.getString("beeoExtractionEntre.text")); // NOI18N
        beeoExtractionEntre.setName("beeoExtractionEntre"); // NOI18N
        beeoExtractionEntre.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                beeoExtractionEntreActionPerformed(evt);
            }
        });
        peExperiencesOld2.add(beeoExtractionEntre);
        beeoExtractionEntre.setBounds(0, 70, 120, 23);

        jFormattedTextField4.setColumns(2);
        jFormattedTextField4.setFormatterFactory(new javax.swing.text.DefaultFormatterFactory(new javax.swing.text.NumberFormatter(new java.text.DecimalFormat("#0"))));
        jFormattedTextField4.setName("jFormattedTextField4"); // NOI18N
        peExperiencesOld2.add(jFormattedTextField4);
        jFormattedTextField4.setBounds(130, 70, 20, 20);

        jLabel31.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jLabel31.setText(resourceMap.getString("jLabel31.text")); // NOI18N
        jLabel31.setName("jLabel31"); // NOI18N
        peExperiencesOld2.add(jLabel31);
        jLabel31.setBounds(150, 70, 10, 20);

        jFormattedTextField5.setColumns(2);
        jFormattedTextField5.setFormatterFactory(new javax.swing.text.DefaultFormatterFactory(new javax.swing.text.NumberFormatter(new java.text.DecimalFormat("#0"))));
        jFormattedTextField5.setName("jFormattedTextField5"); // NOI18N
        peExperiencesOld2.add(jFormattedTextField5);
        jFormattedTextField5.setBounds(160, 70, 20, 20);

        jLabel32.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jLabel32.setText(resourceMap.getString("jLabel32.text")); // NOI18N
        jLabel32.setName("jLabel32"); // NOI18N
        peExperiencesOld2.add(jLabel32);
        jLabel32.setBounds(180, 70, 10, 20);

        jFormattedTextField6.setColumns(2);
        jFormattedTextField6.setFormatterFactory(new javax.swing.text.DefaultFormatterFactory(new javax.swing.text.NumberFormatter(new java.text.DecimalFormat("#0"))));
        jFormattedTextField6.setName("jFormattedTextField6"); // NOI18N
        peExperiencesOld2.add(jFormattedTextField6);
        jFormattedTextField6.setBounds(190, 70, 30, 20);

        jFormattedTextField7.setColumns(2);
        jFormattedTextField7.setFormatterFactory(new javax.swing.text.DefaultFormatterFactory(new javax.swing.text.NumberFormatter(new java.text.DecimalFormat("#0"))));
        jFormattedTextField7.setName("jFormattedTextField7"); // NOI18N
        peExperiencesOld2.add(jFormattedTextField7);
        jFormattedTextField7.setBounds(260, 70, 20, 20);

        jLabel33.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jLabel33.setText(resourceMap.getString("jLabel33.text")); // NOI18N
        jLabel33.setName("jLabel33"); // NOI18N
        peExperiencesOld2.add(jLabel33);
        jLabel33.setBounds(280, 70, 10, 20);

        jFormattedTextField8.setColumns(2);
        jFormattedTextField8.setFormatterFactory(new javax.swing.text.DefaultFormatterFactory(new javax.swing.text.NumberFormatter(new java.text.DecimalFormat("#0"))));
        jFormattedTextField8.setName("jFormattedTextField8"); // NOI18N
        peExperiencesOld2.add(jFormattedTextField8);
        jFormattedTextField8.setBounds(290, 70, 20, 20);

        jLabel34.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jLabel34.setText(resourceMap.getString("jLabel34.text")); // NOI18N
        jLabel34.setName("jLabel34"); // NOI18N
        peExperiencesOld2.add(jLabel34);
        jLabel34.setBounds(310, 70, 10, 20);

        jFormattedTextField9.setColumns(2);
        jFormattedTextField9.setFormatterFactory(new javax.swing.text.DefaultFormatterFactory(new javax.swing.text.NumberFormatter(new java.text.DecimalFormat("#0"))));
        jFormattedTextField9.setName("jFormattedTextField9"); // NOI18N
        peExperiencesOld2.add(jFormattedTextField9);
        jFormattedTextField9.setBounds(320, 70, 30, 20);

        jLabel35.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jLabel35.setText(resourceMap.getString("jLabel35.text")); // NOI18N
        jLabel35.setName("jLabel35"); // NOI18N
        peExperiencesOld2.add(jLabel35);
        jLabel35.setBounds(220, 70, 40, 20);

        beeoRienFaire.setText(resourceMap.getString("beeoRienFaire.text")); // NOI18N
        beeoRienFaire.setName("beeoRienFaire"); // NOI18N
        beeoRienFaire.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                beeoRienFaireActionPerformed(evt);
            }
        });
        peExperiencesOld2.add(beeoRienFaire);
        beeoRienFaire.setBounds(0, 120, 350, 23);

        jLabel36.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jLabel36.setText(resourceMap.getString("jLabel36.text")); // NOI18N
        jLabel36.setName("jLabel36"); // NOI18N
        peExperiencesOld2.add(jLabel36);
        jLabel36.setBounds(0, 150, 350, 14);

        peExperiencesOld.add(peExperiencesOld2);

        tpExperiences.addTab(resourceMap.getString("peExperiencesOld.TabConstraints.tabTitle"), peExperiencesOld); // NOI18N

        tpPrincipal.addTab(resourceMap.getString("tpExperiences.TabConstraints.tabTitle"), tpExperiences); // NOI18N

        tpAnalyse.setName("tpAnalyse"); // NOI18N

        pasExtraction.setName("pasExtraction"); // NOI18N
        pasExtraction.setLayout(new java.awt.BorderLayout());

        paseExtraction1.setName("paseExtraction1"); // NOI18N
        paseExtraction1.setLayout(new java.awt.BorderLayout());

        paseExplications.setName("paseExplications"); // NOI18N
        paseExplications.setLayout(new java.awt.BorderLayout());

        jLabel48.setText(resourceMap.getString("jLabel48.text")); // NOI18N
        jLabel48.setName("jLabel48"); // NOI18N
        paseExplications.add(jLabel48, java.awt.BorderLayout.CENTER);

        paseExtraction1.add(paseExplications, java.awt.BorderLayout.NORTH);

        paseDeroulement2.setName("paseDeroulement2"); // NOI18N
        paseDeroulement2.setLayout(new java.awt.GridLayout(6, 1));

        laseDeroulement1.setText(resourceMap.getString("laseDeroulement1.text")); // NOI18N
        laseDeroulement1.setName("laseDeroulement1"); // NOI18N
        paseDeroulement2.add(laseDeroulement1);

        laseDeroulement2.setText(resourceMap.getString("laseDeroulement2.text")); // NOI18N
        laseDeroulement2.setName("laseDeroulement2"); // NOI18N
        paseDeroulement2.add(laseDeroulement2);

        laseDeroulement3.setText(resourceMap.getString("laseDeroulement3.text")); // NOI18N
        laseDeroulement3.setName("laseDeroulement3"); // NOI18N
        paseDeroulement2.add(laseDeroulement3);

        laseDeroulement4.setText(resourceMap.getString("laseDeroulement4.text")); // NOI18N
        laseDeroulement4.setName("laseDeroulement4"); // NOI18N
        paseDeroulement2.add(laseDeroulement4);

        laseDeroulement5.setText(resourceMap.getString("laseDeroulement5.text")); // NOI18N
        laseDeroulement5.setName("laseDeroulement5"); // NOI18N
        paseDeroulement2.add(laseDeroulement5);

        laseDeroulement6.setText(resourceMap.getString("laseDeroulement6.text")); // NOI18N
        laseDeroulement6.setName("laseDeroulement6"); // NOI18N
        paseDeroulement2.add(laseDeroulement6);

        paseExtraction1.add(paseDeroulement2, java.awt.BorderLayout.CENTER);

        paseStatut.setName("paseStatut"); // NOI18N

        laseNbSujets.setText(resourceMap.getString("laseNbSujets.text")); // NOI18N
        laseNbSujets.setName("laseNbSujets"); // NOI18N
        paseStatut.add(laseNbSujets);

        paseExtraction1.add(paseStatut, java.awt.BorderLayout.SOUTH);

        pasExtraction.add(paseExtraction1, java.awt.BorderLayout.NORTH);

        paseExtraction2.setName("paseExtraction2"); // NOI18N
        paseExtraction2.setLayout(new java.awt.BorderLayout());

        paseDate.setName("paseDate"); // NOI18N

        jLabel8.setText(resourceMap.getString("jLabel8.text")); // NOI18N
        jLabel8.setName("jLabel8"); // NOI18N
        paseDate.add(jLabel8);

        taseDateDebut.setColumns(6);
        taseDateDebut.setFormatterFactory(new javax.swing.text.DefaultFormatterFactory(new javax.swing.text.DateFormatter(java.text.DateFormat.getDateInstance(java.text.DateFormat.SHORT))));
        taseDateDebut.setHorizontalAlignment(javax.swing.JTextField.CENTER);
        taseDateDebut.setText(resourceMap.getString("taseDateDebut.text")); // NOI18N
        taseDateDebut.setName("taseDateDebut"); // NOI18N
        taseDateDebut.addPropertyChangeListener(new java.beans.PropertyChangeListener() {
            public void propertyChange(java.beans.PropertyChangeEvent evt) {
                taseDateDebutPropertyChange(evt);
            }
        });
        taseDateDebut.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                taseDateDebutKeyTyped(evt);
            }
        });
        paseDate.add(taseDateDebut);

        jLabel21.setText(resourceMap.getString("jLabel21.text")); // NOI18N
        jLabel21.setName("jLabel21"); // NOI18N
        paseDate.add(jLabel21);

        taseDateFin.setColumns(6);
        taseDateFin.setFormatterFactory(new javax.swing.text.DefaultFormatterFactory(new javax.swing.text.DateFormatter(java.text.DateFormat.getDateInstance(java.text.DateFormat.SHORT))));
        taseDateFin.setHorizontalAlignment(javax.swing.JTextField.CENTER);
        taseDateFin.setText(resourceMap.getString("taseDateFin.text")); // NOI18N
        taseDateFin.setName("taseDateFin"); // NOI18N
        taseDateFin.addPropertyChangeListener(new java.beans.PropertyChangeListener() {
            public void propertyChange(java.beans.PropertyChangeEvent evt) {
                taseDateFinPropertyChange(evt);
            }
        });
        taseDateFin.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                taseDateFinKeyTyped(evt);
            }
        });
        paseDate.add(taseDateFin);

        jLabel27.setText(resourceMap.getString("jLabel27.text")); // NOI18N
        jLabel27.setName("jLabel27"); // NOI18N
        paseDate.add(jLabel27);

        baseLancer.setText(resourceMap.getString("baseLancer.text")); // NOI18N
        baseLancer.setName("baseLancer"); // NOI18N
        baseLancer.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                baseLancerActionPerformed(evt);
            }
        });
        paseDate.add(baseLancer);

        baseCharger.setText(resourceMap.getString("baseCharger.text")); // NOI18N
        baseCharger.setName("baseCharger"); // NOI18N
        baseCharger.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                baseChargerActionPerformed(evt);
            }
        });
        paseDate.add(baseCharger);

        baseCaptures.setText(resourceMap.getString("baseCaptures.text")); // NOI18N
        baseCaptures.setName("baseCaptures"); // NOI18N
        baseCaptures.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                baseCapturesActionPerformed(evt);
            }
        });
        paseDate.add(baseCaptures);

        paseExtraction2.add(paseDate, java.awt.BorderLayout.NORTH);

        paseFlux.setName("paseFlux"); // NOI18N
        paseFlux.setLayout(new java.awt.BorderLayout());

        paseFlux2.setName("paseFlux2"); // NOI18N
        paseFlux2.setLayout(new java.awt.BorderLayout());

        jLabel82.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jLabel82.setText(resourceMap.getString("jLabel82.text")); // NOI18N
        jLabel82.setName("jLabel82"); // NOI18N
        paseFlux2.add(jLabel82, java.awt.BorderLayout.PAGE_START);

        paseFlux.add(paseFlux2, java.awt.BorderLayout.CENTER);

        paseExtraction2.add(paseFlux, java.awt.BorderLayout.CENTER);

        pasExtraction.add(paseExtraction2, java.awt.BorderLayout.CENTER);

        tpAnalyse.addTab(resourceMap.getString("pasExtraction.TabConstraints.tabTitle"), pasExtraction); // NOI18N

        pasSujets.setName("pasSujets"); // NOI18N
        pasSujets.setLayout(new java.awt.BorderLayout());

        lassNbSujets.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        lassNbSujets.setText(resourceMap.getString("lassNbSujets.text")); // NOI18N
        lassNbSujets.setName("lassNbSujets"); // NOI18N
        pasSujets.add(lassNbSujets, java.awt.BorderLayout.NORTH);

        spassListe.setName("spassListe"); // NOI18N

        treeNode1 = new javax.swing.tree.DefaultMutableTreeNode("Sujets d'actualité");
        tassListe.setModel(new javax.swing.tree.DefaultTreeModel(treeNode1));
        tassListe.setName("tassListe"); // NOI18N
        spassListe.setViewportView(tassListe);

        pasSujets.add(spassListe, java.awt.BorderLayout.CENTER);

        tpAnalyse.addTab(resourceMap.getString("pasSujets.TabConstraints.tabTitle"), pasSujets); // NOI18N

        pasSujets2.setName("pasSujets2"); // NOI18N
        pasSujets2.setLayout(new java.awt.GridLayout(1, 2));

        pass2Sujets.setName("pass2Sujets"); // NOI18N
        pass2Sujets.setLayout(new java.awt.BorderLayout());

        lass2NbSujets.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        lass2NbSujets.setText(resourceMap.getString("lass2NbSujets.text")); // NOI18N
        lass2NbSujets.setName("lass2NbSujets"); // NOI18N
        pass2Sujets.add(lass2NbSujets, java.awt.BorderLayout.NORTH);

        spass2Liste.setName("spass2Liste"); // NOI18N

        treeNode1 = new javax.swing.tree.DefaultMutableTreeNode("Sujets d'actualité");
        tass2Liste.setModel(new javax.swing.tree.DefaultTreeModel(treeNode1));
        tass2Liste.setName("tass2Liste"); // NOI18N
        spass2Liste.setViewportView(tass2Liste);

        pass2Sujets.add(spass2Liste, java.awt.BorderLayout.CENTER);

        pasSujets2.add(pass2Sujets);

        pass2Sources.setName("pass2Sources"); // NOI18N
        pass2Sources.setLayout(new java.awt.BorderLayout());

        lass2NbSources.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        lass2NbSources.setText(resourceMap.getString("lass2NbSources.text")); // NOI18N
        lass2NbSources.setName("lass2NbSources"); // NOI18N
        pass2Sources.add(lass2NbSources, java.awt.BorderLayout.NORTH);

        spass2Sources.setName("spass2Sources"); // NOI18N

        lass2Sources.setName("lass2Sources"); // NOI18N
        spass2Sources.setViewportView(lass2Sources);

        pass2Sources.add(spass2Sources, java.awt.BorderLayout.CENTER);

        pasSujets2.add(pass2Sources);

        tpAnalyse.addTab(resourceMap.getString("pasSujets2.TabConstraints.tabTitle"), pasSujets2); // NOI18N

        pasURLs.setName("pasURLs"); // NOI18N
        pasURLs.setLayout(new java.awt.BorderLayout());

        spasuListe.setName("spasuListe"); // NOI18N

        lasuListe.setName("lasuListe"); // NOI18N
        spasuListe.setViewportView(lasuListe);

        pasURLs.add(spasuListe, java.awt.BorderLayout.CENTER);

        tpAnalyse.addTab(resourceMap.getString("pasURLs.TabConstraints.tabTitle"), pasURLs); // NOI18N

        pasManip.setName("pasManip"); // NOI18N
        pasManip.setLayout(new java.awt.BorderLayout());

        pasmMenu.setName("pasmMenu"); // NOI18N
        pasmMenu.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.LEFT));

        basmAnnuler.setText(resourceMap.getString("basmAnnuler.text")); // NOI18N
        basmAnnuler.setToolTipText(resourceMap.getString("basmAnnuler.toolTipText")); // NOI18N
        basmAnnuler.setName("basmAnnuler"); // NOI18N
        basmAnnuler.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                basmAnnulerActionPerformed(evt);
            }
        });
        pasmMenu.add(basmAnnuler);

        jLabel41.setText(resourceMap.getString("jLabel41.text")); // NOI18N
        jLabel41.setName("jLabel41"); // NOI18N
        pasmMenu.add(jLabel41);

        tasmRechercher.setColumns(20);
        tasmRechercher.setText(resourceMap.getString("tasmRechercher.text")); // NOI18N
        tasmRechercher.setName("tasmRechercher"); // NOI18N
        pasmMenu.add(tasmRechercher);

        basmRechercherEt.setText(resourceMap.getString("basmRechercherEt.text")); // NOI18N
        basmRechercherEt.setToolTipText(resourceMap.getString("basmRechercherEt.toolTipText")); // NOI18N
        basmRechercherEt.setName("basmRechercherEt"); // NOI18N
        basmRechercherEt.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                basmRechercherEtActionPerformed(evt);
            }
        });
        pasmMenu.add(basmRechercherEt);

        basmRechercherOu.setText(resourceMap.getString("basmRechercherOu.text")); // NOI18N
        basmRechercherOu.setToolTipText(resourceMap.getString("basmRechercherOu.toolTipText")); // NOI18N
        basmRechercherOu.setName("basmRechercherOu"); // NOI18N
        basmRechercherOu.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                basmRechercherOuActionPerformed(evt);
            }
        });
        pasmMenu.add(basmRechercherOu);

        basmSelectAll.setText(resourceMap.getString("basmSelectAll.text")); // NOI18N
        basmSelectAll.setToolTipText(resourceMap.getString("basmSelectAll.toolTipText")); // NOI18N
        basmSelectAll.setName("basmSelectAll"); // NOI18N
        basmSelectAll.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                basmSelectAllActionPerformed(evt);
            }
        });
        pasmMenu.add(basmSelectAll);

        basmDeselectAll.setText(resourceMap.getString("basmDeselectAll.text")); // NOI18N
        basmDeselectAll.setToolTipText(resourceMap.getString("basmDeselectAll.toolTipText")); // NOI18N
        basmDeselectAll.setName("basmDeselectAll"); // NOI18N
        basmDeselectAll.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                basmDeselectAllActionPerformed(evt);
            }
        });
        pasmMenu.add(basmDeselectAll);

        pasManip.add(pasmMenu, java.awt.BorderLayout.PAGE_START);

        spasm1.setDividerLocation(300);
        spasm1.setName("spasm1"); // NOI18N

        spasmListes.setDividerLocation(150);
        spasmListes.setName("spasmListes"); // NOI18N

        pasmArticles.setName("pasmArticles"); // NOI18N
        pasmArticles.setLayout(new java.awt.BorderLayout());

        spasmArticles.setName("spasmArticles"); // NOI18N

        lasmArticles.setName("lasmArticles"); // NOI18N
        lasmArticles.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
            public void valueChanged(javax.swing.event.ListSelectionEvent evt) {
                lasmArticlesValueChanged(evt);
            }
        });
        spasmArticles.setViewportView(lasmArticles);

        pasmArticles.add(spasmArticles, java.awt.BorderLayout.CENTER);

        lasmArticles2.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        lasmArticles2.setText(resourceMap.getString("lasmArticles2.text")); // NOI18N
        lasmArticles2.setName("lasmArticles2"); // NOI18N
        pasmArticles.add(lasmArticles2, java.awt.BorderLayout.PAGE_START);

        spasmListes.setRightComponent(pasmArticles);

        pasmSujets.setName("pasmSujets"); // NOI18N
        pasmSujets.setLayout(new java.awt.BorderLayout());

        spasmSujets.setName("spasmSujets"); // NOI18N

        lasmSujets.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
        lasmSujets.setName("lasmSujets"); // NOI18N
        lasmSujets.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
            public void valueChanged(javax.swing.event.ListSelectionEvent evt) {
                lasmSujetsValueChanged(evt);
            }
        });
        spasmSujets.setViewportView(lasmSujets);

        pasmSujets.add(spasmSujets, java.awt.BorderLayout.CENTER);

        lasmSujets2.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        lasmSujets2.setText(resourceMap.getString("lasmSujets2.text")); // NOI18N
        lasmSujets2.setName("lasmSujets2"); // NOI18N
        pasmSujets.add(lasmSujets2, java.awt.BorderLayout.PAGE_START);

        spasmListes.setLeftComponent(pasmSujets);
        pasmSujets.getAccessibleContext().setAccessibleParent(spasmListes);

        spasm1.setLeftComponent(spasmListes);

        pasmActions.setName("pasmActions"); // NOI18N
        pasmActions.setLayout(new java.awt.BorderLayout());

        pasmMenuA.setName("pasmMenuA"); // NOI18N
        pasmMenuA.setLayout(new javax.swing.BoxLayout(pasmMenuA, javax.swing.BoxLayout.PAGE_AXIS));

        jPanel10.setMaximumSize(new java.awt.Dimension(50, 20));
        jPanel10.setName("jPanel10"); // NOI18N
        pasmMenuA.add(jPanel10);

        jLabelNbArticlesDansLaClassification.setText(resourceMap.getString("jLabelNbArticlesDansLaClassification.text")); // NOI18N
        jLabelNbArticlesDansLaClassification.setName("jLabelNbArticlesDansLaClassification"); // NOI18N
        pasmMenuA.add(jLabelNbArticlesDansLaClassification);

        jLabel46.setText(resourceMap.getString("jLabel46.text")); // NOI18N
        jLabel46.setName("jLabel46"); // NOI18N
        pasmMenuA.add(jLabel46);

        basmNouveau.setText(resourceMap.getString("basmNouveau.text")); // NOI18N
        basmNouveau.setToolTipText(resourceMap.getString("basmNouveau.toolTipText")); // NOI18N
        basmNouveau.setName("basmNouveau"); // NOI18N
        basmNouveau.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                basmNouveauActionPerformed(evt);
            }
        });
        pasmMenuA.add(basmNouveau);

        basmEdit.setText(resourceMap.getString("basmEdit.text")); // NOI18N
        basmEdit.setToolTipText(resourceMap.getString("basmEdit.toolTipText")); // NOI18N
        basmEdit.setMargin(new java.awt.Insets(2, 5, 2, 14));
        basmEdit.setName("basmEdit"); // NOI18N
        basmEdit.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                basmEditActionPerformed(evt);
            }
        });
        pasmMenuA.add(basmEdit);

        basmFusion.setText(resourceMap.getString("basmFusion.text")); // NOI18N
        basmFusion.setToolTipText(resourceMap.getString("basmFusion.toolTipText")); // NOI18N
        basmFusion.setMargin(new java.awt.Insets(2, 5, 2, 5));
        basmFusion.setName("basmFusion"); // NOI18N
        basmFusion.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                basmFusionActionPerformed(evt);
            }
        });
        pasmMenuA.add(basmFusion);

        jButton2.setText(resourceMap.getString("jButton2.text")); // NOI18N
        jButton2.setToolTipText(resourceMap.getString("jButton2.toolTipText")); // NOI18N
        jButton2.setMargin(new java.awt.Insets(2, 5, 2, 14));
        jButton2.setName("jButton2"); // NOI18N
        jButton2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton2ActionPerformed(evt);
            }
        });
        pasmMenuA.add(jButton2);

        basmRetrier.setText(resourceMap.getString("basmRetrier.text")); // NOI18N
        basmRetrier.setToolTipText(resourceMap.getString("basmRetrier.toolTipText")); // NOI18N
        basmRetrier.setName("basmRetrier"); // NOI18N
        basmRetrier.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                basmRetrierActionPerformed(evt);
            }
        });
        pasmMenuA.add(basmRetrier);

        jPanel2.setMaximumSize(new java.awt.Dimension(50, 20));
        jPanel2.setName("jPanel2"); // NOI18N
        pasmMenuA.add(jPanel2);

        jLabel44.setText(resourceMap.getString("jLabel44.text")); // NOI18N
        jLabel44.setName("jLabel44"); // NOI18N
        pasmMenuA.add(jLabel44);

        basmValider.setText(resourceMap.getString("basmValider.text")); // NOI18N
        basmValider.setToolTipText(resourceMap.getString("basmValider.toolTipText")); // NOI18N
        basmValider.setName("basmValider"); // NOI18N
        basmValider.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                basmValiderActionPerformed(evt);
            }
        });
        pasmMenuA.add(basmValider);

        basmInvalider.setText(resourceMap.getString("basmInvalider.text")); // NOI18N
        basmInvalider.setToolTipText(resourceMap.getString("basmInvalider.toolTipText")); // NOI18N
        basmInvalider.setName("basmInvalider"); // NOI18N
        basmInvalider.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                basmInvaliderActionPerformed(evt);
            }
        });
        pasmMenuA.add(basmInvalider);

        basmTransferer.setText(resourceMap.getString("basmTransferer.text")); // NOI18N
        basmTransferer.setToolTipText(resourceMap.getString("basmTransferer.toolTipText")); // NOI18N
        basmTransferer.setMargin(new java.awt.Insets(2, 14, 2, 5));
        basmTransferer.setName("basmTransferer"); // NOI18N
        basmTransferer.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                basmTransfererActionPerformed(evt);
            }
        });
        pasmMenuA.add(basmTransferer);

        jPanel3.setMaximumSize(new java.awt.Dimension(50, 20));
        jPanel3.setName("jPanel3"); // NOI18N
        pasmMenuA.add(jPanel3);

        jLabel45.setText(resourceMap.getString("jLabel45.text")); // NOI18N
        jLabel45.setName("jLabel45"); // NOI18N
        pasmMenuA.add(jLabel45);

        lasmArticlesRestants.setText(resourceMap.getString("lasmArticlesRestants.text")); // NOI18N
        lasmArticlesRestants.setName("lasmArticlesRestants"); // NOI18N
        pasmMenuA.add(lasmArticlesRestants);

        jPanel1.setAlignmentX(0.0F);
        jPanel1.setMaximumSize(new java.awt.Dimension(32767, 20));
        jPanel1.setName("jPanel1"); // NOI18N
        jPanel1.setLayout(new javax.swing.BoxLayout(jPanel1, javax.swing.BoxLayout.LINE_AXIS));

        jLabel47.setText(resourceMap.getString("jLabel47.text")); // NOI18N
        jLabel47.setMaximumSize(new java.awt.Dimension(52, 14));
        jLabel47.setName("jLabel47"); // NOI18N
        jPanel1.add(jLabel47);

        tasmAutoPrecision.setColumns(3);
        tasmAutoPrecision.setFormatterFactory(new javax.swing.text.DefaultFormatterFactory(new javax.swing.text.NumberFormatter(new java.text.DecimalFormat("#0"))));
        tasmAutoPrecision.setHorizontalAlignment(javax.swing.JTextField.TRAILING);
        tasmAutoPrecision.setText(resourceMap.getString("tasmAutoPrecision.text")); // NOI18N
        tasmAutoPrecision.setMaximumSize(new java.awt.Dimension(30, 20));
        tasmAutoPrecision.setName("tasmAutoPrecision"); // NOI18N
        jPanel1.add(tasmAutoPrecision);

        pasmMenuA.add(jPanel1);

        basmClassAuto.setText(resourceMap.getString("basmClassAuto.text")); // NOI18N
        basmClassAuto.setToolTipText(resourceMap.getString("basmClassAuto.toolTipText")); // NOI18N
        basmClassAuto.setName("basmClassAuto"); // NOI18N
        basmClassAuto.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                basmClassAutoActionPerformed(evt);
            }
        });
        pasmMenuA.add(basmClassAuto);

        jLabel67.setText(resourceMap.getString("jLabel67.text")); // NOI18N
        jLabel67.setName("jLabel67"); // NOI18N
        pasmMenuA.add(jLabel67);

        jPanel11.setAlignmentX(0.0F);
        jPanel11.setMaximumSize(new java.awt.Dimension(32767, 20));
        jPanel11.setName("jPanel11"); // NOI18N
        jPanel11.setPreferredSize(new java.awt.Dimension(79, 20));
        jPanel11.setLayout(new javax.swing.BoxLayout(jPanel11, javax.swing.BoxLayout.LINE_AXIS));

        jLabel68.setText(resourceMap.getString("jLabel68.text")); // NOI18N
        jLabel68.setMaximumSize(new java.awt.Dimension(52, 14));
        jLabel68.setName("jLabel68"); // NOI18N
        jPanel11.add(jLabel68);

        tasmAutoPrecision2.setColumns(3);
        tasmAutoPrecision2.setHorizontalAlignment(javax.swing.JTextField.TRAILING);
        tasmAutoPrecision2.setText(resourceMap.getString("tasmAutoPrecision2.text")); // NOI18N
        tasmAutoPrecision2.setMaximumSize(new java.awt.Dimension(30, 20));
        tasmAutoPrecision2.setName("tasmAutoPrecision2"); // NOI18N
        jPanel11.add(tasmAutoPrecision2);

        pasmMenuA.add(jPanel11);

        basmClusterAuto.setText(resourceMap.getString("basmClusterAuto.text")); // NOI18N
        basmClusterAuto.setToolTipText(resourceMap.getString("basmClusterAuto.toolTipText")); // NOI18N
        basmClusterAuto.setName("basmClusterAuto"); // NOI18N
        basmClusterAuto.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                basmClusterAutoActionPerformed(evt);
            }
        });
        pasmMenuA.add(basmClusterAuto);

        lasmAutoStatut.setText(resourceMap.getString("lasmAutoStatut.text")); // NOI18N
        lasmAutoStatut.setMaximumSize(new java.awt.Dimension(150, 14));
        lasmAutoStatut.setName("lasmAutoStatut"); // NOI18N
        pasmMenuA.add(lasmAutoStatut);

        jPanel4.setMaximumSize(new java.awt.Dimension(50, 20));
        jPanel4.setName("jPanel4"); // NOI18N
        pasmMenuA.add(jPanel4);

        jLabel39.setText(resourceMap.getString("jLabel39.text")); // NOI18N
        jLabel39.setName("jLabel39"); // NOI18N
        pasmMenuA.add(jLabel39);

        basmExportExcel.setText(resourceMap.getString("basmExportExcel.text")); // NOI18N
        basmExportExcel.setToolTipText(resourceMap.getString("basmExportExcel.toolTipText")); // NOI18N
        basmExportExcel.setName("basmExportExcel"); // NOI18N
        basmExportExcel.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                basmExportExcelActionPerformed(evt);
            }
        });
        pasmMenuA.add(basmExportExcel);

        jButton3.setText(resourceMap.getString("jButton3.text")); // NOI18N
        jButton3.setToolTipText(resourceMap.getString("jButton3.toolTipText")); // NOI18N
        jButton3.setName("jButton3"); // NOI18N
        jButton3.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton3ActionPerformed(evt);
            }
        });
        pasmMenuA.add(jButton3);

        basmSauvegarder.setText(resourceMap.getString("basmSauvegarder.text")); // NOI18N
        basmSauvegarder.setToolTipText(resourceMap.getString("basmSauvegarder.toolTipText")); // NOI18N
        basmSauvegarder.setName("basmSauvegarder"); // NOI18N
        basmSauvegarder.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                basmSauvegarderActionPerformed(evt);
            }
        });
        pasmMenuA.add(basmSauvegarder);

        lasmStatutSave.setText(resourceMap.getString("lasmStatutSave.text")); // NOI18N
        lasmStatutSave.setMaximumSize(new java.awt.Dimension(150, 14));
        lasmStatutSave.setName("lasmStatutSave"); // NOI18N
        pasmMenuA.add(lasmStatutSave);

        pasmActions.add(pasmMenuA, java.awt.BorderLayout.WEST);

        pasmDestinations.setName("pasmDestinations"); // NOI18N
        pasmDestinations.setLayout(new java.awt.BorderLayout());

        spasmDestinations.setName("spasmDestinations"); // NOI18N

        lasmDestinations.setName("lasmDestinations"); // NOI18N
        lasmDestinations.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
            public void valueChanged(javax.swing.event.ListSelectionEvent evt) {
                lasmDestinationsValueChanged(evt);
            }
        });
        spasmDestinations.setViewportView(lasmDestinations);

        pasmDestinations.add(spasmDestinations, java.awt.BorderLayout.CENTER);

        lasmDestinations2.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        lasmDestinations2.setText(resourceMap.getString("lasmDestinations2.text")); // NOI18N
        lasmDestinations2.setName("lasmDestinations2"); // NOI18N
        pasmDestinations.add(lasmDestinations2, java.awt.BorderLayout.PAGE_START);

        pasmActions.add(pasmDestinations, java.awt.BorderLayout.CENTER);

        spasm1.setRightComponent(pasmActions);

        pasManip.add(spasm1, java.awt.BorderLayout.CENTER);

        tpAnalyse.addTab(resourceMap.getString("pasManip.TabConstraints.tabTitle"), pasManip); // NOI18N

        pasDiachronie.setName("pasDiachronie"); // NOI18N
        pasDiachronie.setLayout(new java.awt.BorderLayout());

        pasdMenu.setName("pasdMenu"); // NOI18N
        pasdMenu.setLayout(new java.awt.BorderLayout());

        pasdMenu2.setName("pasdMenu2"); // NOI18N

        basdGenerer.setText(resourceMap.getString("basdGenerer.text")); // NOI18N
        basdGenerer.setName("basdGenerer"); // NOI18N
        basdGenerer.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                basdGenererActionPerformed(evt);
            }
        });
        pasdMenu2.add(basdGenerer);

        lasdGenerer.setText(resourceMap.getString("lasdGenerer.text")); // NOI18N
        lasdGenerer.setName("lasdGenerer"); // NOI18N
        pasdMenu2.add(lasdGenerer);

        pasdMenu.add(pasdMenu2, java.awt.BorderLayout.SOUTH);

        pasDiachronie.add(pasdMenu, java.awt.BorderLayout.NORTH);

        tpasDiachronie.setName("tpasDiachronie"); // NOI18N

        pasdParSujet.setName("pasdParSujet"); // NOI18N
        pasdParSujet.setLayout(new java.awt.BorderLayout());

        pasdsMenu.setName("pasdsMenu"); // NOI18N

        basdsExportExcel.setText(resourceMap.getString("basdsExportExcel.text")); // NOI18N
        basdsExportExcel.setToolTipText(resourceMap.getString("basdsExportExcel.toolTipText")); // NOI18N
        basdsExportExcel.setName("basdsExportExcel"); // NOI18N
        basdsExportExcel.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                basdsExportExcelActionPerformed(evt);
            }
        });
        pasdsMenu.add(basdsExportExcel);

        jLabel53.setText(resourceMap.getString("jLabel53.text")); // NOI18N
        jLabel53.setName("jLabel53"); // NOI18N
        pasdsMenu.add(jLabel53);

        pasdParSujet.add(pasdsMenu, java.awt.BorderLayout.NORTH);

        pasdParSujet2.setName("pasdParSujet2"); // NOI18N

        spasdListeSujets.setName("spasdListeSujets"); // NOI18N

        lasdListeSujets.setName("lasdListeSujets"); // NOI18N
        spasdListeSujets.setViewportView(lasdListeSujets);

        pasdParSujet2.setLeftComponent(spasdListeSujets);

        tpasdParSujet.setName("tpasdParSujet"); // NOI18N

        pasdsDiachronie.setName("pasdsDiachronie"); // NOI18N
        pasdsDiachronie.setLayout(new java.awt.BorderLayout());

        spasdsDiachronie.setName("spasdsDiachronie"); // NOI18N

        lasdsDiachronie.setName("lasdsDiachronie"); // NOI18N
        spasdsDiachronie.setViewportView(lasdsDiachronie);

        pasdsDiachronie.add(spasdsDiachronie, java.awt.BorderLayout.CENTER);

        tpasdParSujet.addTab(resourceMap.getString("pasdsDiachronie.TabConstraints.tabTitle"), pasdsDiachronie); // NOI18N

        pasdsVariete.setName("pasdsVariete"); // NOI18N
        pasdsVariete.setLayout(new javax.swing.BoxLayout(pasdsVariete, javax.swing.BoxLayout.PAGE_AXIS));

        lasdsvArticles.setText(resourceMap.getString("lasdsvArticles.text")); // NOI18N
        lasdsvArticles.setName("lasdsvArticles"); // NOI18N
        pasdsVariete.add(lasdsvArticles);

        lasdsvSources.setText(resourceMap.getString("lasdsvSources.text")); // NOI18N
        lasdsvSources.setName("lasdsvSources"); // NOI18N
        pasdsVariete.add(lasdsvSources);

        lasdsvCategories.setText(resourceMap.getString("lasdsvCategories.text")); // NOI18N
        lasdsvCategories.setName("lasdsvCategories"); // NOI18N
        pasdsVariete.add(lasdsvCategories);

        tpasdParSujet.addTab(resourceMap.getString("pasdsVariete.TabConstraints.tabTitle"), pasdsVariete); // NOI18N

        pasdsDistributionS.setName("pasdsDistributionS"); // NOI18N
        pasdsDistributionS.setLayout(new java.awt.BorderLayout());

        spasdsDistributionS.setName("spasdsDistributionS"); // NOI18N

        lasdsDistributionS.setName("lasdsDistributionS"); // NOI18N
        spasdsDistributionS.setViewportView(lasdsDistributionS);

        pasdsDistributionS.add(spasdsDistributionS, java.awt.BorderLayout.CENTER);

        tpasdParSujet.addTab(resourceMap.getString("pasdsDistributionS.TabConstraints.tabTitle"), pasdsDistributionS); // NOI18N

        pasdsDistributionC.setName("pasdsDistributionC"); // NOI18N
        pasdsDistributionC.setLayout(new java.awt.BorderLayout());

        spasdsDistributionC.setName("spasdsDistributionC"); // NOI18N

        lasdsDistributionC.setName("lasdsDistributionC"); // NOI18N
        spasdsDistributionC.setViewportView(lasdsDistributionC);

        pasdsDistributionC.add(spasdsDistributionC, java.awt.BorderLayout.CENTER);

        tpasdParSujet.addTab(resourceMap.getString("pasdsDistributionC.TabConstraints.tabTitle"), pasdsDistributionC); // NOI18N

        pasdParSujet2.setRightComponent(tpasdParSujet);

        pasdParSujet.add(pasdParSujet2, java.awt.BorderLayout.CENTER);

        tpasDiachronie.addTab(resourceMap.getString("pasdParSujet.TabConstraints.tabTitle"), pasdParSujet); // NOI18N

        pasdParSource.setName("pasdParSource"); // NOI18N
        pasdParSource.setLayout(new java.awt.BorderLayout());

        pasdoMenu.setName("pasdoMenu"); // NOI18N

        basdoExportExcel.setText(resourceMap.getString("basdoExportExcel.text")); // NOI18N
        basdoExportExcel.setToolTipText(resourceMap.getString("basdoExportExcel.toolTipText")); // NOI18N
        basdoExportExcel.setName("basdoExportExcel"); // NOI18N
        basdoExportExcel.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                basdoExportExcelActionPerformed(evt);
            }
        });
        pasdoMenu.add(basdoExportExcel);

        jLabel52.setText(resourceMap.getString("jLabel52.text")); // NOI18N
        jLabel52.setName("jLabel52"); // NOI18N
        pasdoMenu.add(jLabel52);

        pasdParSource.add(pasdoMenu, java.awt.BorderLayout.PAGE_START);

        pasdParSource2.setName("pasdParSource2"); // NOI18N

        spasdoListeSources.setName("spasdoListeSources"); // NOI18N

        lasdoListeSources.setName("lasdoListeSources"); // NOI18N
        spasdoListeSources.setViewportView(lasdoListeSources);

        pasdParSource2.setLeftComponent(spasdoListeSources);

        tpasdParSources.setName("tpasdParSources"); // NOI18N

        pasdoProduction.setName("pasdoProduction"); // NOI18N
        pasdoProduction.setLayout(new java.awt.BorderLayout());

        spasdoProduction.setName("spasdoProduction"); // NOI18N

        lasdoProduction.setName("lasdoProduction"); // NOI18N
        spasdoProduction.setViewportView(lasdoProduction);

        pasdoProduction.add(spasdoProduction, java.awt.BorderLayout.CENTER);

        tpasdParSources.addTab(resourceMap.getString("pasdoProduction.TabConstraints.tabTitle"), pasdoProduction); // NOI18N

        pasdoVariete.setName("pasdoVariete"); // NOI18N
        pasdoVariete.setLayout(new javax.swing.BoxLayout(pasdoVariete, javax.swing.BoxLayout.PAGE_AXIS));

        lasdoArticles.setText(resourceMap.getString("lasdoArticles.text")); // NOI18N
        lasdoArticles.setName("lasdoArticles"); // NOI18N
        pasdoVariete.add(lasdoArticles);

        lasdoSujets2.setText(resourceMap.getString("lasdoSujets2.text")); // NOI18N
        lasdoSujets2.setName("lasdoSujets2"); // NOI18N
        pasdoVariete.add(lasdoSujets2);

        lasdoExclus2.setText(resourceMap.getString("lasdoExclus2.text")); // NOI18N
        lasdoExclus2.setName("lasdoExclus2"); // NOI18N
        pasdoVariete.add(lasdoExclus2);

        lasdoPrimeurs2.setText(resourceMap.getString("lasdoPrimeurs2.text")); // NOI18N
        lasdoPrimeurs2.setName("lasdoPrimeurs2"); // NOI18N
        pasdoVariete.add(lasdoPrimeurs2);

        tpasdParSources.addTab(resourceMap.getString("pasdoVariete.TabConstraints.tabTitle"), pasdoVariete); // NOI18N

        pasdoDistribution.setName("pasdoDistribution"); // NOI18N
        pasdoDistribution.setLayout(new java.awt.BorderLayout());

        spasdoDistribution.setName("spasdoDistribution"); // NOI18N

        lasdoDistribution.setName("lasdoDistribution"); // NOI18N
        spasdoDistribution.setViewportView(lasdoDistribution);

        pasdoDistribution.add(spasdoDistribution, java.awt.BorderLayout.CENTER);

        tpasdParSources.addTab(resourceMap.getString("pasdoDistribution.TabConstraints.tabTitle"), pasdoDistribution); // NOI18N

        pasdoExclus.setName("pasdoExclus"); // NOI18N
        pasdoExclus.setLayout(new java.awt.BorderLayout());

        spasdoExclus.setName("spasdoExclus"); // NOI18N

        lasdoExclus.setName("lasdoExclus"); // NOI18N
        spasdoExclus.setViewportView(lasdoExclus);

        pasdoExclus.add(spasdoExclus, java.awt.BorderLayout.CENTER);

        tpasdParSources.addTab(resourceMap.getString("pasdoExclus.TabConstraints.tabTitle"), pasdoExclus); // NOI18N

        pasdoPrimeurs.setName("pasdoPrimeurs"); // NOI18N
        pasdoPrimeurs.setLayout(new java.awt.BorderLayout());

        spasdoPrimeurs.setName("spasdoPrimeurs"); // NOI18N

        lasdoPrimeurs.setName("lasdoPrimeurs"); // NOI18N
        spasdoPrimeurs.setViewportView(lasdoPrimeurs);

        pasdoPrimeurs.add(spasdoPrimeurs, java.awt.BorderLayout.CENTER);

        tpasdParSources.addTab(resourceMap.getString("pasdoPrimeurs.TabConstraints.tabTitle"), pasdoPrimeurs); // NOI18N

        pasdParSource2.setRightComponent(tpasdParSources);

        pasdParSource.add(pasdParSource2, java.awt.BorderLayout.CENTER);

        tpasDiachronie.addTab(resourceMap.getString("pasdParSource.TabConstraints.tabTitle"), pasdParSource); // NOI18N

        pasdGeneral.setName("pasdGeneral"); // NOI18N
        pasdGeneral.setLayout(new java.awt.BorderLayout());

        tpasdGeneral.setName("tpasdGeneral"); // NOI18N

        pasdgVariete.setName("pasdgVariete"); // NOI18N
        pasdgVariete.setLayout(new javax.swing.BoxLayout(pasdgVariete, javax.swing.BoxLayout.PAGE_AXIS));

        lasdgvArticles.setText(resourceMap.getString("lasdgvArticles.text")); // NOI18N
        lasdgvArticles.setName("lasdgvArticles"); // NOI18N
        pasdgVariete.add(lasdgvArticles);

        lasdgvSujets.setText(resourceMap.getString("lasdgvSujets.text")); // NOI18N
        lasdgvSujets.setName("lasdgvSujets"); // NOI18N
        pasdgVariete.add(lasdgvSujets);

        lasdgvSources.setText(resourceMap.getString("lasdgvSources.text")); // NOI18N
        lasdgvSources.setName("lasdgvSources"); // NOI18N
        pasdgVariete.add(lasdgvSources);

        lasdgvCategories.setText(resourceMap.getString("lasdgvCategories.text")); // NOI18N
        lasdgvCategories.setName("lasdgvCategories"); // NOI18N
        pasdgVariete.add(lasdgvCategories);

        tpasdGeneral.addTab(resourceMap.getString("pasdgVariete.TabConstraints.tabTitle"), pasdgVariete); // NOI18N

        pasdgDistributionS.setName("pasdgDistributionS"); // NOI18N
        pasdgDistributionS.setLayout(new java.awt.BorderLayout());

        spasdgDistributionS.setName("spasdgDistributionS"); // NOI18N

        lasdgDistributionS.setName("lasdgDistributionS"); // NOI18N
        spasdgDistributionS.setViewportView(lasdgDistributionS);

        pasdgDistributionS.add(spasdgDistributionS, java.awt.BorderLayout.CENTER);

        tpasdGeneral.addTab(resourceMap.getString("pasdgDistributionS.TabConstraints.tabTitle"), pasdgDistributionS); // NOI18N

        pasdgDistributionO.setName("pasdgDistributionO"); // NOI18N
        pasdgDistributionO.setLayout(new java.awt.BorderLayout());

        spasdgDistributionO.setName("spasdgDistributionO"); // NOI18N

        lasdgDistributionO.setName("lasdgDistributionO"); // NOI18N
        spasdgDistributionO.setViewportView(lasdgDistributionO);

        pasdgDistributionO.add(spasdgDistributionO, java.awt.BorderLayout.CENTER);

        tpasdGeneral.addTab(resourceMap.getString("pasdgDistributionO.TabConstraints.tabTitle"), pasdgDistributionO); // NOI18N

        pasdgDistributionC.setName("pasdgDistributionC"); // NOI18N
        pasdgDistributionC.setLayout(new java.awt.BorderLayout());

        spasdgDistributionC.setName("spasdgDistributionC"); // NOI18N

        lasdgDistributionC.setName("lasdgDistributionC"); // NOI18N
        spasdgDistributionC.setViewportView(lasdgDistributionC);

        pasdgDistributionC.add(spasdgDistributionC, java.awt.BorderLayout.CENTER);

        tpasdGeneral.addTab(resourceMap.getString("pasdgDistributionC.TabConstraints.tabTitle"), pasdgDistributionC); // NOI18N

        pasdgDistributionE.setName("pasdgDistributionE"); // NOI18N
        pasdgDistributionE.setLayout(new java.awt.BorderLayout());

        spasdgDistributionE.setName("spasdgDistributionE"); // NOI18N

        lasdgDistributionE.setName("lasdgDistributionE"); // NOI18N
        spasdgDistributionE.setViewportView(lasdgDistributionE);

        pasdgDistributionE.add(spasdgDistributionE, java.awt.BorderLayout.CENTER);

        tpasdGeneral.addTab(resourceMap.getString("pasdgDistributionE.TabConstraints.tabTitle"), pasdgDistributionE); // NOI18N

        pasdgDistributionP.setName("pasdgDistributionP"); // NOI18N
        pasdgDistributionP.setLayout(new java.awt.BorderLayout());

        spasdgDistributionP.setName("spasdgDistributionP"); // NOI18N

        lasdgDistributionP.setName("lasdgDistributionP"); // NOI18N
        spasdgDistributionP.setViewportView(lasdgDistributionP);

        pasdgDistributionP.add(spasdgDistributionP, java.awt.BorderLayout.CENTER);

        tpasdGeneral.addTab(resourceMap.getString("pasdgDistributionP.TabConstraints.tabTitle"), pasdgDistributionP); // NOI18N

        pasdGeneral.add(tpasdGeneral, java.awt.BorderLayout.CENTER);

        tpasDiachronie.addTab(resourceMap.getString("pasdGeneral.TabConstraints.tabTitle"), pasdGeneral); // NOI18N

        pasDiachronie.add(tpasDiachronie, java.awt.BorderLayout.CENTER);

        tpAnalyse.addTab(resourceMap.getString("pasDiachronie.TabConstraints.tabTitle"), pasDiachronie); // NOI18N

        pasConfrontation.setName("pasConfrontation"); // NOI18N
        pasConfrontation.setLayout(new java.awt.BorderLayout());

        jLabel49.setText(resourceMap.getString("jLabel49.text")); // NOI18N
        jLabel49.setName("jLabel49"); // NOI18N
        pasConfrontation.add(jLabel49, java.awt.BorderLayout.PAGE_START);

        jPanel5.setName("jPanel5"); // NOI18N
        jPanel5.setLayout(new java.awt.BorderLayout());

        jPanel6.setName("jPanel6"); // NOI18N
        jPanel6.setLayout(new java.awt.GridLayout(3, 1));

        jPanel7.setName("jPanel7"); // NOI18N

        jLabel50.setText(resourceMap.getString("jLabel50.text")); // NOI18N
        jLabel50.setName("jLabel50"); // NOI18N
        jPanel7.add(jLabel50);

        tascPageWeb.setColumns(50);
        tascPageWeb.setText(resourceMap.getString("tascPageWeb.text")); // NOI18N
        tascPageWeb.setName("tascPageWeb"); // NOI18N
        jPanel7.add(tascPageWeb);

        jPanel6.add(jPanel7);

        jPanel8.setName("jPanel8"); // NOI18N

        jLabel51.setText(resourceMap.getString("jLabel51.text")); // NOI18N
        jLabel51.setName("jLabel51"); // NOI18N
        jPanel8.add(jLabel51);

        tascFluxRSS.setColumns(50);
        tascFluxRSS.setText(resourceMap.getString("tascFluxRSS.text")); // NOI18N
        tascFluxRSS.setName("tascFluxRSS"); // NOI18N
        jPanel8.add(tascFluxRSS);

        jPanel6.add(jPanel8);

        jPanel9.setName("jPanel9"); // NOI18N

        bascConfrontation.setText(resourceMap.getString("bascConfrontation.text")); // NOI18N
        bascConfrontation.setName("bascConfrontation"); // NOI18N
        bascConfrontation.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bascConfrontationActionPerformed(evt);
            }
        });
        jPanel9.add(bascConfrontation);

        lascStatut.setText(resourceMap.getString("lascStatut.text")); // NOI18N
        lascStatut.setName("lascStatut"); // NOI18N
        jPanel9.add(lascStatut);

        jPanel6.add(jPanel9);

        jPanel5.add(jPanel6, java.awt.BorderLayout.NORTH);

        spascCaptures.setName("spascCaptures"); // NOI18N

        lascCaptures.setName("lascCaptures"); // NOI18N
        spascCaptures.setViewportView(lascCaptures);

        jPanel5.add(spascCaptures, java.awt.BorderLayout.CENTER);

        pasConfrontation.add(jPanel5, java.awt.BorderLayout.CENTER);

        tpAnalyse.addTab(resourceMap.getString("pasConfrontation.TabConstraints.tabTitle"), pasConfrontation); // NOI18N

        tpPrincipal.addTab(resourceMap.getString("tpAnalyse.TabConstraints.tabTitle"), tpAnalyse); // NOI18N

        getContentPane().add(tpPrincipal, java.awt.BorderLayout.CENTER);

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void formatAll() {
        Charte.formateAndFormateChildren(getContentPane());
    }

    private void formWindowClosing(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowClosing
        // TODO add your handling code here:
        exit();
    }//GEN-LAST:event_formWindowClosing

    private void bsbEtatActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bsbEtatActionPerformed
        // TODO add your handling code here:
        majQtDepeches();
    }//GEN-LAST:event_bsbEtatActionPerformed

    private void bsrRechercheActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bsrRechercheActionPerformed
        // TODO add your handling code here:
        effectueRecherche();
    }//GEN-LAST:event_bsrRechercheActionPerformed

    private void bcCollecteActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bcCollecteActionPerformed
        // TODO add your handling code here:
        if (bcCollecte.isSelected()) {
            lanceCollecteFlux();
        } else {
            stoppeCollecteFlux();
        }
    }//GEN-LAST:event_bcCollecteActionPerformed

    private void bcLemmatisationActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bcLemmatisationActionPerformed
        // TODO add your handling code here:
        if (bcLemmatisation.isSelected()) {
            lanceLemmatisationTempsReel();
        } else {
            stoppeLemmatisationTempsReel();
        }
    }//GEN-LAST:event_bcLemmatisationActionPerformed

    private void bcCaptureActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bcCaptureActionPerformed
        // TODO add your handling code here:
        if (bcCapture.isSelected()) {
            lanceCapturesEcran();
        } else {
            stoppeCapturesEcran();
        }
    }//GEN-LAST:event_bcCaptureActionPerformed

    private void bcCollecteSujetsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bcCollecteSujetsActionPerformed
        // TODO add your handling code here:
        if (bcCollecteSujets.isSelected()) {
            lanceCollecteSujets();
        } else {
            stoppeCollecteSujets();
        }
    }//GEN-LAST:event_bcCollecteSujetsActionPerformed

    private void taseDateDebutPropertyChange(java.beans.PropertyChangeEvent evt) {//GEN-FIRST:event_taseDateDebutPropertyChange
        // TODO add your handling code here:
    }//GEN-LAST:event_taseDateDebutPropertyChange

    private void taseDateFinPropertyChange(java.beans.PropertyChangeEvent evt) {//GEN-FIRST:event_taseDateFinPropertyChange
        // TODO add your handling code here:
    }//GEN-LAST:event_taseDateFinPropertyChange

    private void taseDateDebutKeyTyped(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_taseDateDebutKeyTyped
        // TODO add your handling code here
    }//GEN-LAST:event_taseDateDebutKeyTyped

    private void taseDateFinKeyTyped(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_taseDateFinKeyTyped
        // TODO add your handling code here:
    }//GEN-LAST:event_taseDateFinKeyTyped

    private void baseLancerActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_baseLancerActionPerformed
        // TODO add your handling code here:
        fenetreTemporelleAnalyseSynchroniqueChangee();
    }//GEN-LAST:event_baseLancerActionPerformed

    private void tjNbLignesPropertyChange(java.beans.PropertyChangeEvent evt) {//GEN-FIRST:event_tjNbLignesPropertyChange
        // TODO add your handling code here:
        try {
            Out.setBufferSize(Integer.parseInt(tjNbLignes.getText()));
        } catch (NumberFormatException nfe) {
        }
    }//GEN-LAST:event_tjNbLignesPropertyChange

    private void beeoRienFaireActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_beeoRienFaireActionPerformed
        // TODO add your handling code here:
}//GEN-LAST:event_beeoRienFaireActionPerformed

    private void beeoExtractionEntreActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_beeoExtractionEntreActionPerformed
        // TODO add your handling code here:
        dechargeDepechesEntreDates();
}//GEN-LAST:event_beeoExtractionEntreActionPerformed

    private void beeExtractionJourActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_beeExtractionJourActionPerformed
        // TODO add your handling code here:
        dechargeDepechesParDate();
}//GEN-LAST:event_beeExtractionJourActionPerformed

    private void beeoCalculDirectActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_beeoCalculDirectActionPerformed
        // TODO add your handling code here:
        calculDirectIPTC();
}//GEN-LAST:event_beeoCalculDirectActionPerformed

    private void beeoThematiquesActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_beeoThematiquesActionPerformed
        // TODO add your handling code here:
}//GEN-LAST:event_beeoThematiquesActionPerformed

    private void beeoExpDBPediaActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_beeoExpDBPediaActionPerformed
        // TODO add your handling code here:
        enrichisCorpus();
}//GEN-LAST:event_beeoExpDBPediaActionPerformed

    private void beeoSaveCorpusActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_beeoSaveCorpusActionPerformed
        // TODO add your handling code here:
        //sauvegardeCorpusOld();
}//GEN-LAST:event_beeoSaveCorpusActionPerformed

    private void beeoLoadCorpusActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_beeoLoadCorpusActionPerformed
        // TODO add your handling code here:
        //chargeCorpusOld();
}//GEN-LAST:event_beeoLoadCorpusActionPerformed

    private void beeoSetCorpusActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_beeoSetCorpusActionPerformed
        // TODO add your handling code here:
        //placeDepechesDansCorpusOld();
}//GEN-LAST:event_beeoSetCorpusActionPerformed

    private void beeoRecupArticlesActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_beeoRecupArticlesActionPerformed
        // TODO add your handling code here:
        //dechargeDepechesOld();
}//GEN-LAST:event_beeoRecupArticlesActionPerformed

    private void besRequeteActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_besRequeteActionPerformed
        // TODO add your handling code here:
        lanceRequeteDBPedia();
}//GEN-LAST:event_besRequeteActionPerformed

    private void beeCNewActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_beeCNewActionPerformed
        // TODO add your handling code here:
        dechargeDepeches();
        placeDepechesDansCorpus();
        sauvegardeCorpus();
}//GEN-LAST:event_beeCNewActionPerformed

    private void beeCLoadActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_beeCLoadActionPerformed
        // TODO add your handling code here:
        chargeCorpus();
}//GEN-LAST:event_beeCLoadActionPerformed

    private void beeCNew2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_beeCNew2ActionPerformed
        // TODO add your handling code here:
        creeCorpusClustering();
}//GEN-LAST:event_beeCNew2ActionPerformed

    private void lefLienWikiActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_lefLienWikiActionPerformed
        // TODO add your handling code here:
        lieConceptsWikipedia();
}//GEN-LAST:event_lefLienWikiActionPerformed

    private void lefLienOntoActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_lefLienOntoActionPerformed
        // TODO add your handling code here:
        lieConceptsOntologie();
}//GEN-LAST:event_lefLienOntoActionPerformed

    private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed
        // TODO add your handling code here:
        lemmatiseCategoriesWikiDBPedia();
}//GEN-LAST:event_jButton1ActionPerformed

    private void befInclCateLabelsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_befInclCateLabelsActionPerformed
        // TODO add your handling code here:
        parseDBPediaLabelsCategoriesWiki();
}//GEN-LAST:event_befInclCateLabelsActionPerformed

    private void befInclCategoriesActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_befInclCategoriesActionPerformed
        // TODO add your handling code here:
        parseDBPediaConceptsCategoriesWiki();
}//GEN-LAST:event_befInclCategoriesActionPerformed

    private void befLemConceptsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_befLemConceptsActionPerformed
        // TODO add your handling code here:
        lemmatiseConceptsDBPedia();
}//GEN-LAST:event_befLemConceptsActionPerformed

    private void befInclAbstractActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_befInclAbstractActionPerformed
        // TODO add your handling code here:
        parseDBPediaDescConcepts();
}//GEN-LAST:event_befInclAbstractActionPerformed

    private void befInclOntoActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_befInclOntoActionPerformed
        // TODO add your handling code here:
        parseDBPediaOntologie();
}//GEN-LAST:event_befInclOntoActionPerformed

    private void befInclIPTCActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_befInclIPTCActionPerformed
        // TODO add your handling code here:
        parseIPTCThemas();
}//GEN-LAST:event_befInclIPTCActionPerformed

    private void befInclInstancesActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_befInclInstancesActionPerformed
        // TODO add your handling code here:
        parseDBPediaConceptsCategories();
}//GEN-LAST:event_befInclInstancesActionPerformed

    private void befInclArticlesActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_befInclArticlesActionPerformed
        // TODO add your handling code here:
        parseDBPediaLabelsConcepts();
}//GEN-LAST:event_befInclArticlesActionPerformed

    private void bcLemmatisation2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bcLemmatisation2ActionPerformed
        // TODO add your handling code here:
        if (bcLemmatisation2.isSelected()) {
            lanceLemmatisationDifferee();
        } else {
            stoppeLemmatisationDifferee();
        }
    }//GEN-LAST:event_bcLemmatisation2ActionPerformed

    private void bcToutCorpusActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bcToutCorpusActionPerformed
        // TODO add your handling code here:
        if (bcToutCorpus.isSelected()) {
            bcCorpusPartiel.setSelected(false);
            bcCorpusJour.setSelected(false);
        } else {
            bcCorpusPartiel.setSelected(true);
        }
    }//GEN-LAST:event_bcToutCorpusActionPerformed

    private void bcCorpusPartielActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bcCorpusPartielActionPerformed
        // TODO add your handling code here:
        if (bcCorpusPartiel.isSelected()) {
            bcToutCorpus.setSelected(false);
            bcCorpusJour.setSelected(false);
        } else {
            bcToutCorpus.setSelected(true);
        }
    }//GEN-LAST:event_bcCorpusPartielActionPerformed

    private void tcDelaiCollectePropertyChange(java.beans.PropertyChangeEvent evt) {//GEN-FIRST:event_tcDelaiCollectePropertyChange
        // TODO add your handling code here:
        try {
            int i = Integer.parseInt(tcDelaiCollecte.getText());
        } catch (NumberFormatException nfe) {
            tcDelaiCollecte.setText("1");
        }
    }//GEN-LAST:event_tcDelaiCollectePropertyChange

    private void bcCorpusJourActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bcCorpusJourActionPerformed
        // TODO add your handling code here:
        if (bcCorpusJour.isSelected()) {
            bcCorpusPartiel.setSelected(false);
            bcToutCorpus.setSelected(false);
        } else {
            bcToutCorpus.setSelected(true);
        }
    }//GEN-LAST:event_bcCorpusJourActionPerformed

    private void baseCapturesActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_baseCapturesActionPerformed
        // TODO add your handling code here:
        exporteCaptures();
    }//GEN-LAST:event_baseCapturesActionPerformed

    private void lasmSujetsValueChanged(javax.swing.event.ListSelectionEvent evt) {//GEN-FIRST:event_lasmSujetsValueChanged
        // TODO add your handling code here:
        classSujetSelectionne();
    }//GEN-LAST:event_lasmSujetsValueChanged

    private void lasmArticlesValueChanged(javax.swing.event.ListSelectionEvent evt) {//GEN-FIRST:event_lasmArticlesValueChanged
        // TODO add your handling code here:
        classArticlesSelectionnes();
    }//GEN-LAST:event_lasmArticlesValueChanged

    private void basmValiderActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_basmValiderActionPerformed
        // TODO add your handling code here:
        classArticlesValides();
    }//GEN-LAST:event_basmValiderActionPerformed

    private void basmTransfererActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_basmTransfererActionPerformed
        // TODO add your handling code here:
        classArticlesTransferes();
    }//GEN-LAST:event_basmTransfererActionPerformed

    private void basmFusionActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_basmFusionActionPerformed
        // TODO add your handling code here:
        classSujetsFusionnes();
    }//GEN-LAST:event_basmFusionActionPerformed

    private void basmInvaliderActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_basmInvaliderActionPerformed
        // TODO add your handling code here:
        classArticlesInvalides();
    }//GEN-LAST:event_basmInvaliderActionPerformed

    private void lasmDestinationsValueChanged(javax.swing.event.ListSelectionEvent evt) {//GEN-FIRST:event_lasmDestinationsValueChanged
        // TODO add your handling code here:
        classDestinationSelectionnee();
    }//GEN-LAST:event_lasmDestinationsValueChanged

    private void basmNouveauActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_basmNouveauActionPerformed
        // TODO add your handling code here:
        classNouveauSujet();
    }//GEN-LAST:event_basmNouveauActionPerformed

    private void basmEditActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_basmEditActionPerformed
        // TODO add your handling code here:
        classRenommerSujet();
    }//GEN-LAST:event_basmEditActionPerformed

    private void basmExportExcelActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_basmExportExcelActionPerformed
        // TODO add your handling code here:
        classExportExcel();
    }//GEN-LAST:event_basmExportExcelActionPerformed

    private void basmAnnulerActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_basmAnnulerActionPerformed
        // TODO add your handling code here:
        classAnnulation();
    }//GEN-LAST:event_basmAnnulerActionPerformed

    private void basmSelectAllActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_basmSelectAllActionPerformed
        // TODO add your handling code here:
        classSelectAll();
    }//GEN-LAST:event_basmSelectAllActionPerformed

    private void basmDeselectAllActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_basmDeselectAllActionPerformed
        // TODO add your handling code here:
        classDeselectAll();
    }//GEN-LAST:event_basmDeselectAllActionPerformed

    private void basmSauvegarderActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_basmSauvegarderActionPerformed
        // TODO add your handling code here:
        classSave();
    }//GEN-LAST:event_basmSauvegarderActionPerformed

    private void baseChargerActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_baseChargerActionPerformed
        // TODO add your handling code here:
        classLoad();
    }//GEN-LAST:event_baseChargerActionPerformed

    private void basmRechercherEtActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_basmRechercherEtActionPerformed
        // TODO add your handling code here:
        classRechercherEt();
    }//GEN-LAST:event_basmRechercherEtActionPerformed

    private void basmRechercherOuActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_basmRechercherOuActionPerformed
        // TODO add your handling code here:
        classRechercherOu();
    }//GEN-LAST:event_basmRechercherOuActionPerformed

    private void basmClassAutoActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_basmClassAutoActionPerformed
        // TODO add your handling code here:
        classRechercherAuto();
    }//GEN-LAST:event_basmClassAutoActionPerformed

    private void basmRetrierActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_basmRetrierActionPerformed
        // TODO add your handling code here:
        classRetrier();
    }//GEN-LAST:event_basmRetrierActionPerformed

    private void jButton2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton2ActionPerformed
        // TODO add your handling code here:
        classSupprimerSujet();
    }//GEN-LAST:event_jButton2ActionPerformed

    private void jButton3ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton3ActionPerformed
        // TODO add your handling code here:
        classExportLexico();
    }//GEN-LAST:event_jButton3ActionPerformed

    private void bascConfrontationActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bascConfrontationActionPerformed
        // TODO add your handling code here:
        lanceConfrontationPageRSS();
    }//GEN-LAST:event_bascConfrontationActionPerformed

    private void basdGenererActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_basdGenererActionPerformed
        // TODO add your handling code here:
        genererStatistiques();
    }//GEN-LAST:event_basdGenererActionPerformed

    private void basdsExportExcelActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_basdsExportExcelActionPerformed
        // TODO add your handling code here:
        exportExcelAnalyseParSujet();
    }//GEN-LAST:event_basdsExportExcelActionPerformed

    private void basdoExportExcelActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_basdoExportExcelActionPerformed
        // TODO add your handling code here:
        exportExcelAnalyseParSource();
    }//GEN-LAST:event_basdoExportExcelActionPerformed

    private void btgeModifierActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btgeModifierActionPerformed
        // TODO add your handling code here:
        modifierTag();
    }//GEN-LAST:event_btgeModifierActionPerformed

    private void btgeSupprimerActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btgeSupprimerActionPerformed
        // TODO add your handling code here:
        supprimerTag();
    }//GEN-LAST:event_btgeSupprimerActionPerformed

    private void btgnAjouterActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btgnAjouterActionPerformed
        // TODO add your handling code here:
        ajouterTag();
    }//GEN-LAST:event_btgnAjouterActionPerformed

    private void ltListeValueChanged(javax.swing.event.ListSelectionEvent evt) {//GEN-FIRST:event_ltListeValueChanged
        // TODO add your handling code here:
        selectionTag();
    }//GEN-LAST:event_ltListeValueChanged

    private void bsgeModifierActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bsgeModifierActionPerformed
        // TODO add your handling code here:
        modifierSource();
    }//GEN-LAST:event_bsgeModifierActionPerformed

    private void bsgeSupprimerActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bsgeSupprimerActionPerformed
        // TODO add your handling code here:
        supprimerSource();
    }//GEN-LAST:event_bsgeSupprimerActionPerformed

    private void bsgnAjouterActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bsgnAjouterActionPerformed
        // TODO add your handling code here:
        ajouterSource();
    }//GEN-LAST:event_bsgnAjouterActionPerformed

    private void basmClusterAutoActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_basmClusterAutoActionPerformed
        // TODO add your handling code here:
        classClusteringAuto();
    }//GEN-LAST:event_basmClusterAutoActionPerformed

    private void bfgnAjouterActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bfgnAjouterActionPerformed
        // TODO add your handling code here:
        ajouterFlux();
    }//GEN-LAST:event_bfgnAjouterActionPerformed

    private void bfgeModifierActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bfgeModifierActionPerformed
        // TODO add your handling code here:
        modifierFlux();
    }//GEN-LAST:event_bfgeModifierActionPerformed

    private void bfgeSupprimerActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bfgeSupprimerActionPerformed
        // TODO add your handling code here:
        supprimerFlux();
    }//GEN-LAST:event_bfgeSupprimerActionPerformed

    private void bfgeAjouterTagActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bfgeAjouterTagActionPerformed
        // TODO add your handling code here:
        ajouterTagFlux();
    }//GEN-LAST:event_bfgeAjouterTagActionPerformed

    private void bfgeSupprimerTagActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bfgeSupprimerTagActionPerformed
        // TODO add your handling code here:
        supprimerTagFlux();
    }//GEN-LAST:event_bfgeSupprimerTagActionPerformed
    /**
     * @param args the command line arguments
     */
    /*public static void main(String args[]) {
    java.awt.EventQueue.invokeLater(new Runnable() {
    public void run() {
    new FenetrePrincipale().setVisible(true);
    }
    });
    }*/
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JToggleButton bascConfrontation;
    private javax.swing.JButton basdGenerer;
    private javax.swing.JButton basdoExportExcel;
    private javax.swing.JButton basdsExportExcel;
    private javax.swing.JButton baseCaptures;
    private javax.swing.JButton baseCharger;
    private javax.swing.JButton baseLancer;
    private javax.swing.JButton basmAnnuler;
    private javax.swing.JButton basmClassAuto;
    private javax.swing.JButton basmClusterAuto;
    private javax.swing.JButton basmDeselectAll;
    private javax.swing.JButton basmEdit;
    private javax.swing.JButton basmExportExcel;
    private javax.swing.JButton basmFusion;
    private javax.swing.JButton basmInvalider;
    private javax.swing.JButton basmNouveau;
    private javax.swing.JButton basmRechercherEt;
    private javax.swing.JButton basmRechercherOu;
    private javax.swing.JButton basmRetrier;
    private javax.swing.JButton basmSauvegarder;
    private javax.swing.JButton basmSelectAll;
    private javax.swing.JButton basmTransferer;
    private javax.swing.JButton basmValider;
    private javax.swing.JToggleButton bcCapture;
    private javax.swing.JToggleButton bcCollecte;
    private javax.swing.JToggleButton bcCollecteSujets;
    private javax.swing.JToggleButton bcCorpusJour;
    private javax.swing.JToggleButton bcCorpusPartiel;
    private javax.swing.JToggleButton bcLemmatisation;
    private javax.swing.JToggleButton bcLemmatisation2;
    private javax.swing.JToggleButton bcToutCorpus;
    private javax.swing.JButton beeCLoad;
    private javax.swing.JButton beeCNew;
    private javax.swing.JButton beeCNew2;
    private javax.swing.JButton beeExtractionJour;
    private javax.swing.JButton beeoCalculDirect;
    private javax.swing.JButton beeoExpDBPedia;
    private javax.swing.JButton beeoExtractionEntre;
    private javax.swing.JButton beeoLoadCorpus;
    private javax.swing.JButton beeoRecupArticles;
    private javax.swing.JButton beeoRienFaire;
    private javax.swing.JButton beeoSaveCorpus;
    private javax.swing.JButton beeoSetCorpus;
    private javax.swing.JButton beeoThematiques;
    private javax.swing.JButton befInclAbstract;
    private javax.swing.JButton befInclArticles;
    private javax.swing.JButton befInclCateLabels;
    private javax.swing.JButton befInclCategories;
    private javax.swing.JButton befInclIPTC;
    private javax.swing.JButton befInclInstances;
    private javax.swing.JButton befInclOnto;
    private javax.swing.JButton befLemConcepts;
    private javax.swing.JButton besRequete;
    private javax.swing.JButton bfgeAjouterTag;
    private javax.swing.JButton bfgeModifier;
    private javax.swing.JButton bfgeSupprimer;
    private javax.swing.JButton bfgeSupprimerTag;
    private javax.swing.JButton bfgnAjouter;
    private javax.swing.JButton bsbEtat;
    private javax.swing.JButton bsgeModifier;
    private javax.swing.JButton bsgeSupprimer;
    private javax.swing.JButton bsgnAjouter;
    private javax.swing.JButton bsrRecherche;
    private javax.swing.JButton btgeModifier;
    private javax.swing.JButton btgeSupprimer;
    private javax.swing.JButton btgnAjouter;
    private javax.swing.ButtonGroup buttonGroup1;
    private javax.swing.JComboBox cbfgeSource;
    private javax.swing.JComboBox cbfgeTag;
    private javax.swing.JComboBox cbfgnSource;
    private javax.swing.JButton jButton1;
    private javax.swing.JButton jButton2;
    private javax.swing.JButton jButton3;
    private javax.swing.JFormattedTextField jFormattedTextField1;
    private javax.swing.JFormattedTextField jFormattedTextField10;
    private javax.swing.JFormattedTextField jFormattedTextField2;
    private javax.swing.JFormattedTextField jFormattedTextField3;
    private javax.swing.JFormattedTextField jFormattedTextField4;
    private javax.swing.JFormattedTextField jFormattedTextField5;
    private javax.swing.JFormattedTextField jFormattedTextField6;
    private javax.swing.JFormattedTextField jFormattedTextField7;
    private javax.swing.JFormattedTextField jFormattedTextField8;
    private javax.swing.JFormattedTextField jFormattedTextField9;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel10;
    private javax.swing.JLabel jLabel11;
    private javax.swing.JLabel jLabel12;
    private javax.swing.JLabel jLabel13;
    private javax.swing.JLabel jLabel14;
    private javax.swing.JLabel jLabel15;
    private javax.swing.JLabel jLabel16;
    private javax.swing.JLabel jLabel17;
    private javax.swing.JLabel jLabel18;
    private javax.swing.JLabel jLabel19;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel20;
    private javax.swing.JLabel jLabel21;
    private javax.swing.JLabel jLabel22;
    private javax.swing.JLabel jLabel23;
    private javax.swing.JLabel jLabel24;
    private javax.swing.JLabel jLabel25;
    private javax.swing.JLabel jLabel26;
    private javax.swing.JLabel jLabel27;
    private javax.swing.JLabel jLabel28;
    private javax.swing.JLabel jLabel29;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel30;
    private javax.swing.JLabel jLabel31;
    private javax.swing.JLabel jLabel32;
    private javax.swing.JLabel jLabel33;
    private javax.swing.JLabel jLabel34;
    private javax.swing.JLabel jLabel35;
    private javax.swing.JLabel jLabel36;
    private javax.swing.JLabel jLabel37;
    private javax.swing.JLabel jLabel38;
    private javax.swing.JLabel jLabel39;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel40;
    private javax.swing.JLabel jLabel41;
    private javax.swing.JLabel jLabel42;
    private javax.swing.JLabel jLabel43;
    private javax.swing.JLabel jLabel44;
    private javax.swing.JLabel jLabel45;
    private javax.swing.JLabel jLabel46;
    private javax.swing.JLabel jLabel47;
    private javax.swing.JLabel jLabel48;
    private javax.swing.JLabel jLabel49;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel50;
    private javax.swing.JLabel jLabel51;
    private javax.swing.JLabel jLabel52;
    private javax.swing.JLabel jLabel53;
    private javax.swing.JLabel jLabel54;
    private javax.swing.JLabel jLabel55;
    private javax.swing.JLabel jLabel56;
    private javax.swing.JLabel jLabel57;
    private javax.swing.JLabel jLabel58;
    private javax.swing.JLabel jLabel59;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JLabel jLabel60;
    private javax.swing.JLabel jLabel61;
    private javax.swing.JLabel jLabel62;
    private javax.swing.JLabel jLabel63;
    private javax.swing.JLabel jLabel64;
    private javax.swing.JLabel jLabel65;
    private javax.swing.JLabel jLabel66;
    private javax.swing.JLabel jLabel67;
    private javax.swing.JLabel jLabel68;
    private javax.swing.JLabel jLabel69;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JLabel jLabel70;
    private javax.swing.JLabel jLabel71;
    private javax.swing.JLabel jLabel72;
    private javax.swing.JLabel jLabel73;
    private javax.swing.JLabel jLabel74;
    private javax.swing.JLabel jLabel75;
    private javax.swing.JLabel jLabel76;
    private javax.swing.JLabel jLabel77;
    private javax.swing.JLabel jLabel78;
    private javax.swing.JLabel jLabel79;
    private javax.swing.JLabel jLabel8;
    private javax.swing.JLabel jLabel80;
    private javax.swing.JLabel jLabel81;
    private javax.swing.JLabel jLabel82;
    private javax.swing.JLabel jLabel9;
    private javax.swing.JLabel jLabelNbArticlesDansLaClassification;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel10;
    private javax.swing.JPanel jPanel11;
    private javax.swing.JPanel jPanel12;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JPanel jPanel4;
    private javax.swing.JPanel jPanel5;
    private javax.swing.JPanel jPanel6;
    private javax.swing.JPanel jPanel7;
    private javax.swing.JPanel jPanel8;
    private javax.swing.JPanel jPanel9;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JSeparator jSeparator1;
    private javax.swing.JSeparator jSeparator2;
    private javax.swing.JSeparator jSeparator3;
    private javax.swing.JSeparator jSeparator5;
    private javax.swing.JSeparator jSeparator6;
    private javax.swing.JSeparator jSeparator7;
    private javax.swing.JList lCollecte;
    private javax.swing.JList lCollecteSujets;
    private javax.swing.JList lascCaptures;
    private javax.swing.JLabel lascStatut;
    private javax.swing.JLabel lasdGenerer;
    private javax.swing.JList lasdListeSujets;
    private javax.swing.JList lasdgDistributionC;
    private javax.swing.JList lasdgDistributionE;
    private javax.swing.JList lasdgDistributionO;
    private javax.swing.JList lasdgDistributionP;
    private javax.swing.JList lasdgDistributionS;
    private javax.swing.JLabel lasdgvArticles;
    private javax.swing.JLabel lasdgvCategories;
    private javax.swing.JLabel lasdgvSources;
    private javax.swing.JLabel lasdgvSujets;
    private javax.swing.JLabel lasdoArticles;
    private javax.swing.JList lasdoDistribution;
    private javax.swing.JList lasdoExclus;
    private javax.swing.JLabel lasdoExclus2;
    private javax.swing.JList lasdoListeSources;
    private javax.swing.JList lasdoPrimeurs;
    private javax.swing.JLabel lasdoPrimeurs2;
    private javax.swing.JList lasdoProduction;
    private javax.swing.JLabel lasdoSujets2;
    private javax.swing.JList lasdsDiachronie;
    private javax.swing.JList lasdsDistributionC;
    private javax.swing.JList lasdsDistributionS;
    private javax.swing.JLabel lasdsvArticles;
    private javax.swing.JLabel lasdsvCategories;
    private javax.swing.JLabel lasdsvSources;
    private javax.swing.JLabel laseDeroulement1;
    private javax.swing.JLabel laseDeroulement2;
    private javax.swing.JLabel laseDeroulement3;
    private javax.swing.JLabel laseDeroulement4;
    private javax.swing.JLabel laseDeroulement5;
    private javax.swing.JLabel laseDeroulement6;
    private javax.swing.JLabel laseNbSujets;
    private javax.swing.JList lasmArticles;
    private javax.swing.JLabel lasmArticles2;
    private javax.swing.JLabel lasmArticlesRestants;
    private javax.swing.JLabel lasmAutoStatut;
    private javax.swing.JList lasmDestinations;
    private javax.swing.JLabel lasmDestinations2;
    private javax.swing.JLabel lasmStatutSave;
    private javax.swing.JList lasmSujets;
    private javax.swing.JLabel lasmSujets2;
    private javax.swing.JLabel lass2NbSources;
    private javax.swing.JLabel lass2NbSujets;
    private javax.swing.JList lass2Sources;
    private javax.swing.JLabel lassNbSujets;
    private javax.swing.JList lasuListe;
    private javax.swing.JLabel lcCapture;
    private javax.swing.JLabel lcEtat;
    private javax.swing.JLabel lcEtat2;
    private javax.swing.JLabel lcEtat3;
    private javax.swing.JLabel lcLemmatisation;
    private javax.swing.JLabel lcNbFlux;
    private javax.swing.JLabel leThesaurus;
    private javax.swing.JLabel leeCDesc;
    private javax.swing.JLabel leeCDesc2;
    private javax.swing.JLabel leeCLoadStatus;
    private javax.swing.JLabel leeCNewStatus;
    private javax.swing.JLabel leeCTitre;
    private javax.swing.JLabel leeCTitre2;
    private javax.swing.JLabel leecLoadStatus2;
    private javax.swing.JLabel leeo1Titre;
    private javax.swing.JLabel leeo2Titre;
    private javax.swing.JLabel lefLemmaCategories;
    private javax.swing.JLabel lefLemmaConcepts;
    private javax.swing.JButton lefLienOnto;
    private javax.swing.JButton lefLienWiki;
    private javax.swing.JLabel lefLignesLuesCateLabels;
    private javax.swing.JLabel lefLignesLuesCategories;
    private javax.swing.JLabel lefLignesLuesIPTC;
    private javax.swing.JLabel lefLignesLuesInstances;
    private javax.swing.JLabel lefLignesLuesOntologie;
    private javax.swing.JLabel lefOntoLie;
    private javax.swing.JButton lefPretraitementOnto;
    private javax.swing.JButton lefPretraitementWiki;
    private javax.swing.JLabel lefWikiLie;
    private javax.swing.JLabel lesReponse;
    private javax.swing.JLabel lesRequete;
    private javax.swing.JList lfListe;
    private javax.swing.JList lfTags;
    private javax.swing.JLabel ljInfoCollecte;
    private javax.swing.JLabel ljmActu;
    private javax.swing.JLabel ljmGraphe;
    private javax.swing.JList lsListe;
    private javax.swing.JLabel lsbEtat;
    private javax.swing.JLabel lsbFlux;
    private javax.swing.JList lsbFlux2;
    private javax.swing.JLabel lsbGrapheHeure;
    private javax.swing.JLabel lsbHeure;
    private javax.swing.JList lsbHeure2;
    private javax.swing.JLabel lsbJour;
    private javax.swing.JList lsbJour2;
    private javax.swing.JLabel lsbTotal;
    private javax.swing.JLabel lsrRecherche;
    private javax.swing.JList ltListe;
    private javax.swing.JPanel pCollecte;
    private javax.swing.JPanel pCollecte2;
    private javax.swing.JPanel pFlux;
    private javax.swing.JPanel pJAffichage;
    private javax.swing.JPanel pJournal;
    private javax.swing.JPanel pSources;
    private javax.swing.JPanel pSousCorpus;
    private javax.swing.JPanel pSujets;
    private javax.swing.JPanel pTags;
    private javax.swing.JPanel pasConfrontation;
    private javax.swing.JPanel pasDiachronie;
    private javax.swing.JPanel pasExtraction;
    private javax.swing.JPanel pasManip;
    private javax.swing.JPanel pasSujets;
    private javax.swing.JPanel pasSujets2;
    private javax.swing.JPanel pasURLs;
    private javax.swing.JPanel pasdGeneral;
    private javax.swing.JPanel pasdMenu;
    private javax.swing.JPanel pasdMenu2;
    private javax.swing.JPanel pasdParSource;
    private javax.swing.JSplitPane pasdParSource2;
    private javax.swing.JPanel pasdParSujet;
    private javax.swing.JSplitPane pasdParSujet2;
    private javax.swing.JPanel pasdgDistributionC;
    private javax.swing.JPanel pasdgDistributionE;
    private javax.swing.JPanel pasdgDistributionO;
    private javax.swing.JPanel pasdgDistributionP;
    private javax.swing.JPanel pasdgDistributionS;
    private javax.swing.JPanel pasdgVariete;
    private javax.swing.JPanel pasdoDistribution;
    private javax.swing.JPanel pasdoExclus;
    private javax.swing.JPanel pasdoMenu;
    private javax.swing.JPanel pasdoPrimeurs;
    private javax.swing.JPanel pasdoProduction;
    private javax.swing.JPanel pasdoVariete;
    private javax.swing.JPanel pasdsDiachronie;
    private javax.swing.JPanel pasdsDistributionC;
    private javax.swing.JPanel pasdsDistributionS;
    private javax.swing.JPanel pasdsMenu;
    private javax.swing.JPanel pasdsVariete;
    private javax.swing.JPanel paseDate;
    private javax.swing.JPanel paseDeroulement2;
    private javax.swing.JPanel paseExplications;
    private javax.swing.JPanel paseExtraction1;
    private javax.swing.JPanel paseExtraction2;
    private javax.swing.JPanel paseFlux;
    private javax.swing.JPanel paseFlux2;
    private javax.swing.JPanel paseStatut;
    private javax.swing.JPanel pasmActions;
    private javax.swing.JPanel pasmArticles;
    private javax.swing.JPanel pasmDestinations;
    private javax.swing.JPanel pasmMenu;
    private javax.swing.JPanel pasmMenuA;
    private javax.swing.JPanel pasmSujets;
    private javax.swing.JPanel pass2Sources;
    private javax.swing.JPanel pass2Sujets;
    private javax.swing.JPanel pcDiffere;
    private javax.swing.JPanel pcDiffere2;
    private javax.swing.JPanel pcLancement;
    private javax.swing.JPanel pcLancementArticles;
    private javax.swing.JPanel pcLancementArticles2;
    private javax.swing.JPanel pcLancementSujets;
    private javax.swing.JPanel pcLancementSujets2;
    private javax.swing.JPanel pcProcess;
    private javax.swing.JPanel pcProcess2;
    private javax.swing.JPanel pcSelection;
    private javax.swing.JPanel pcTempsReel;
    private javax.swing.JPanel pcTempsReel2;
    private javax.swing.JPanel peCorpus;
    private javax.swing.JPanel peExperiences;
    private javax.swing.JPanel peExperiences2;
    private javax.swing.JPanel peExperiencesOld;
    private javax.swing.JPanel peExperiencesOld1;
    private javax.swing.JPanel peExperiencesOld2;
    private javax.swing.JPanel peFichiers;
    private javax.swing.JPanel peFichiers1;
    private javax.swing.JPanel peFichiers2;
    private javax.swing.JPanel peSparql;
    private javax.swing.JPanel peThesaurus;
    private javax.swing.JPanel peeCorpus;
    private javax.swing.JPanel peeCorpus2;
    private javax.swing.JPanel peeExperiences;
    private javax.swing.JPanel peeExperiences2;
    private javax.swing.JPanel pfGestion;
    private javax.swing.JPanel pfGestion2;
    private javax.swing.JPanel pfGestion21;
    private javax.swing.JPanel pfGestion210;
    private javax.swing.JPanel pfGestion211;
    private javax.swing.JPanel pfGestion212;
    private javax.swing.JPanel pfGestion22;
    private javax.swing.JPanel pfGestion23;
    private javax.swing.JPanel pfGestion24;
    private javax.swing.JPanel pfGestion25;
    private javax.swing.JPanel pfGestion26;
    private javax.swing.JPanel pfGestion27;
    private javax.swing.JPanel pfGestion28;
    private javax.swing.JPanel pfGestion29;
    private javax.swing.JPanel pfGestion3;
    private javax.swing.JPanel pfListes;
    private javax.swing.JPanel pjMemoire;
    private javax.swing.JPanel pjMenu;
    private javax.swing.JPanel psBaseDonnees;
    private javax.swing.JPanel psGestion;
    private javax.swing.JPanel psGestion2;
    private javax.swing.JPanel psGestion21;
    private javax.swing.JPanel psGestion22;
    private javax.swing.JPanel psGestion221;
    private javax.swing.JPanel psGestion23;
    private javax.swing.JPanel psGestion231;
    private javax.swing.JPanel psGestion24;
    private javax.swing.JPanel psGestion25;
    private javax.swing.JPanel psGestion26;
    private javax.swing.JPanel psGestion261;
    private javax.swing.JPanel psGestion27;
    private javax.swing.JPanel psGestion271;
    private javax.swing.JPanel psGestion28;
    private javax.swing.JPanel psGestion29;
    private javax.swing.JPanel psRecherche;
    private javax.swing.JPanel psRecherche2;
    private javax.swing.JPanel psbContenu;
    private javax.swing.JPanel psbContenu1;
    private javax.swing.JPanel psbContenu10;
    private javax.swing.JPanel psbContenu11;
    private javax.swing.JPanel psbContenu12;
    private javax.swing.JPanel psbContenu2;
    private javax.swing.JPanel psbMenu;
    private javax.swing.JPanel ptGestion;
    private javax.swing.JPanel ptGestion2;
    private javax.swing.JPanel ptGestion3;
    private javax.swing.JPanel ptgExistant;
    private javax.swing.JPanel ptgNouveau;
    private javax.swing.JScrollPane spCollecte;
    private javax.swing.JScrollPane spCollecteSujets;
    private javax.swing.JScrollPane spascCaptures;
    private javax.swing.JScrollPane spasdListeSujets;
    private javax.swing.JScrollPane spasdgDistributionC;
    private javax.swing.JScrollPane spasdgDistributionE;
    private javax.swing.JScrollPane spasdgDistributionO;
    private javax.swing.JScrollPane spasdgDistributionP;
    private javax.swing.JScrollPane spasdgDistributionS;
    private javax.swing.JScrollPane spasdoDistribution;
    private javax.swing.JScrollPane spasdoExclus;
    private javax.swing.JScrollPane spasdoListeSources;
    private javax.swing.JScrollPane spasdoPrimeurs;
    private javax.swing.JScrollPane spasdoProduction;
    private javax.swing.JScrollPane spasdsDiachronie;
    private javax.swing.JScrollPane spasdsDistributionC;
    private javax.swing.JScrollPane spasdsDistributionS;
    private javax.swing.JSplitPane spasm1;
    private javax.swing.JScrollPane spasmArticles;
    private javax.swing.JScrollPane spasmDestinations;
    private javax.swing.JSplitPane spasmListes;
    private javax.swing.JScrollPane spasmSujets;
    private javax.swing.JScrollPane spass2Liste;
    private javax.swing.JScrollPane spass2Sources;
    private javax.swing.JScrollPane spassListe;
    private javax.swing.JScrollPane spasuListe;
    private javax.swing.JScrollPane speCorpus;
    private javax.swing.JScrollPane speExperiences;
    private javax.swing.JScrollPane speExperiences2;
    private javax.swing.JScrollPane speThesaurus;
    private javax.swing.JScrollPane spesReponse;
    private javax.swing.JScrollPane spesRequete;
    private javax.swing.JScrollPane spfListe;
    private javax.swing.JScrollPane spfTags;
    private javax.swing.JScrollPane spjErreurs;
    private javax.swing.JScrollPane spjInfos;
    private javax.swing.JScrollPane spsListe;
    private javax.swing.JScrollPane spsbFlux;
    private javax.swing.JScrollPane spsbHeure;
    private javax.swing.JScrollPane spsbJour;
    private javax.swing.JScrollPane sptListe;
    private javax.swing.JTextArea taesReponse;
    private javax.swing.JTextArea taesRequete;
    private javax.swing.JTextField tascFluxRSS;
    private javax.swing.JTextField tascPageWeb;
    private javax.swing.JFormattedTextField taseDateDebut;
    private javax.swing.JFormattedTextField taseDateFin;
    private javax.swing.JFormattedTextField tasmAutoPrecision;
    private javax.swing.JFormattedTextField tasmAutoPrecision2;
    private javax.swing.JTextField tasmRechercher;
    private javax.swing.JTree tass2Liste;
    private javax.swing.JTree tassListe;
    private javax.swing.JFormattedTextField tcCorpusPartielDate;
    private javax.swing.JFormattedTextField tcDelaiCollecte;
    private javax.swing.JTree teThesaurus;
    private javax.swing.JFormattedTextField teeCNbArticles;
    private javax.swing.JFormattedTextField teeCNbArticles2;
    private javax.swing.JTextField tfgeNom;
    private javax.swing.JTextField tfgeUrl;
    private javax.swing.JTextField tfgnNom;
    private javax.swing.JTextField tfgnUrl;
    private javax.swing.JTextArea tjErreurs;
    private javax.swing.JTextArea tjInfos;
    private javax.swing.JFormattedTextField tjNbLignes;
    private javax.swing.JTabbedPane tpAnalyse;
    private javax.swing.JTabbedPane tpCollecte;
    private javax.swing.JTabbedPane tpCorpus;
    private javax.swing.JTabbedPane tpExperiences;
    private javax.swing.JTabbedPane tpPrincipal;
    private javax.swing.JTabbedPane tpStats;
    private javax.swing.JTabbedPane tpasDiachronie;
    private javax.swing.JTabbedPane tpasdGeneral;
    private javax.swing.JTabbedPane tpasdParSources;
    private javax.swing.JTabbedPane tpasdParSujet;
    private javax.swing.JTextField tsgeHomepage;
    private javax.swing.JTextField tsgeNom;
    private javax.swing.JTextField tsgnHomepage;
    private javax.swing.JTextField tsgnNom;
    private javax.swing.JTextField tsrRecherche;
    private javax.swing.JTree tsrResultat;
    private javax.swing.JFormattedTextField ttgeNo;
    private javax.swing.JTextField ttgeNom;
    private javax.swing.JFormattedTextField ttgnNo;
    private javax.swing.JTextField ttgnNom;
    // End of variables declaration//GEN-END:variables

    // Custom methods and attributes
    private void exit() {
        baseIPRI.disconnect();
        System.exit(0);
    }
    private Timer timerCollecteFlux = new Timer(1000, new ActionListener() {

        public void actionPerformed(ActionEvent ae) {
            actualiseInfosCollecteFlux();
        }
    });
    private static int compteurMemoire = 1;
    private Vector<Long> memMin = new Vector<Long>();
    private Vector<Long> memMax = new Vector<Long>();
    long memMin0 = Long.MAX_VALUE;
    long memMax0 = Long.MIN_VALUE;
    private Timer timerStatsMemoire = new Timer(1000, new ActionListener() {

        public void actionPerformed(ActionEvent ae) {
            compteurMemoire--;
            System.gc();
            long mem = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
            if (mem > memMax0) {
                memMax0 = mem;
            }
            if (mem < memMin0) {
                memMin0 = mem;
            }
            ljmActu.setText("Utilisation de la mémoire : " + (mem / 1024 / 1024) +
                    " Mo / " + (Runtime.getRuntime().maxMemory() / 1024 / 1024) + " Mo");

            if (compteurMemoire == 0) {
                compteurMemoire = 60;
                memMin.add(new Long(memMin0));
                memMax.add(new Long(memMax0));
                memMin0 = Long.MAX_VALUE;
                memMax0 = Long.MIN_VALUE;
                ljmGraphe.repaint();
            }
        }
    });
    private Vector<String> statsParJour = new Vector<String>();
    private Vector<String> statsParHeure = new Vector<String>();
    private Vector<String> statsParFlux = new Vector<String>();

    private void initStats() {
        statsParJour.addElement("-aucune donnée encore-");
        statsParHeure.addElement("-aucune donnée encore-");
        statsParFlux.addElement("-aucune donnée encore-");
        lsbJour2 = new JList(statsParJour);
        lsbJour2.setEnabled(false);
        spsbJour.setViewportView(lsbJour2);
        lsbHeure2 = new JList(statsParHeure);
        lsbHeure2.setEnabled(false);
        spsbHeure.setViewportView(lsbHeure2);
        lsbFlux2 = new JList(statsParFlux);
        lsbFlux2.setEnabled(false);
        spsbFlux.setViewportView(lsbFlux2);
    }

    private void majQtDepeches() {
        new Thread() {

            @Override
            public void run() {
                if (baseIPRI.connect() != Database.DB_OK) {
                    lsbTotal.setText("ATTENTION : Connexion impossible à la base de données IPRI.");
                    return;
                }
                initStats();
                try {
                    RSSFeedDatabase base = new RSSFeedDatabase(baseIPRI);
                    Out.printInfo("Récupération des articles au total");
                    int total = base.getRssItemCount();
                    Out.printInfo("Récupération des articles au total terminée");
                    lsbTotal.setText("Nombre d'articles total : " + total);
                    Out.printInfo("Récupération des articles par jour");
                    Vector<RSSItemCount> res = base.getRssItemCountByDay();
                    Out.printInfo("Récupération des articles par jour terminée");
                    statsParJour.clear();
                    for (int i = 0; i < res.size(); i++) {
                        statsParJour.addElement("<html>" + res.elementAt(i).getPubDate() + " : " +
                                res.elementAt(i).getCount() + " (" +
                                (((10000 * res.elementAt(i).getCount()) / total) / 100.0) + "%)");
                    }
                    lsbJour2 = new JList(statsParJour);
                    lsbJour2.setEnabled(false);
                    spsbJour.setViewportView(lsbJour2);
                    Out.printInfo("Récupération des articles par heure");
                    res = base.getRssItemCountByHour();
                    Out.printInfo("Récupération des articles par heure terminée");
                    RSSItemCount[] aTrier = new RSSItemCount[res.size()];
                    res.toArray(aTrier);
                    Arrays.sort(aTrier, new ComparateurRSSItemCount(ComparateurRSSItemCount.CROISSANT));
                    statsParHeure.clear();
                    for (int i = 0; i < aTrier.length; i++) {
                        double pourcent = (((10000 * aTrier[i].getCount()) / total) / 100.0);
                        statsParHeure.addElement("<html>" + aTrier[i].getPubDate() + " : " +
                                aTrier[i].getCount() + " (" +
                                pourcent + "%)");
                        nbDepechesParHeure[i] = pourcent;
                    }
                    lsbHeure2 = new JList(statsParHeure);
                    lsbHeure2.setEnabled(false);
                    spsbHeure.setViewportView(lsbHeure2);
                    lsbGrapheHeure.repaint();
                    Out.printInfo("Récupération des articles par flux");
                    res = base.getRssItemCountByFeed();
                    Out.printInfo("Récupération des articles par flux terminée");
                    aTrier = new RSSItemCount[res.size()];
                    res.toArray(aTrier);
                    Arrays.sort(aTrier, new ComparateurRSSItemCount2(ComparateurRSSItemCount2.DECROISSANT));
                    statsParFlux.clear();
                    for (int i = 0; i < aTrier.length; i++) {
                        statsParFlux.addElement("<html>" + aTrier[i].getName() + " : " +
                                aTrier[i].getCount() +
                                " <i>(dernier : " + aTrier[i].getPubDate() + ")</i>");
                    }
                    lsbFlux2 = new JList(statsParFlux);
                    lsbFlux2.setEnabled(false);
                    spsbFlux.setViewportView(lsbFlux2);
                } catch (NoBaseException nbe) {
                    lsbTotal.setText("Base indisponible.");
                }
            }
        }.start();
    }
    private double[] nbDepechesParHeure = new double[24];
    private Collecteur[] collecteurs;
    private Vector<Collecteur> poolALancer = new Vector<Collecteur>();
    private RSSSaver collecteur;

    private void initCollecteFlux() {
        if (baseIPRI.connect() != Database.DB_OK) {
            lcEtat2.setText("ATTENTION : Connexion impossible à la base de données IPRI.");
            return;
        } else {
            lcEtat2.setText("Collecte des flux RSS lancée.");
        }
        collecteur = new RSSSaver(baseIPRI);
        collecteur.desactiveLemmatisation();
        collecteur.start();
        RSSFeedInfoExtended[] listeFlux0;
        try {
            listeFlux0 = collecteur.getFeedsList();
        } catch (NoBaseException nbe) {
            listeFlux0 = new RSSFeedInfoExtended[0];
        }
        final RSSFeedInfoExtended[] listeFlux = listeFlux0;
        collecteurs = new Collecteur[listeFlux.length];
        for (int i = 0; i < listeFlux.length; i++) {
            collecteurs[i] = new Collecteur(collecteur, listeFlux[i], tcDelaiCollecte);
            collecteurs[i].setPriority(Thread.MIN_PRIORITY);
        }
        lCollecte = new JList(collecteurs);
        lCollecte.setEnabled(false);
        spCollecte.setViewportView(lCollecte);
        new Thread(){
            @Override
            public void run(){
                while(true){
                    int nbCollectesEnCours = 0;
                    for(int i=0; i<collecteurs.length; i++){
                        if(collecteurs[i].isEnTrainDeLire()){
                            nbCollectesEnCours++;
                        }
                    }
                    if(nbCollectesEnCours < 10 && poolALancer.size() > 0){
                        for(int i=nbCollectesEnCours; i<10 && poolALancer.size() > 0; i++){
                            poolALancer.elementAt(0).start();
                            poolALancer.removeElementAt(0);
                        }
                    }
                    try{
                        Thread.sleep(1000);
                    } catch(InterruptedException ie){

                    }
                }
            }
        }.start();
    }

    private void lanceCollecteFlux() {
        for (int i = 0; i < collecteurs.length; i++) {
            poolALancer.addElement(collecteurs[i]);
        }
    }
    Vector<Collecteur> vieuxCollecteurs = new Vector<Collecteur>();

    private void stoppeCollecteFlux() {
        for (int i = 0; i < collecteurs.length; i++) {
            if (collecteurs[i].isRunning()) {
                collecteurs[i].fin();
                vieuxCollecteurs.addElement(collecteurs[i]);
            }
            Collecteur c = new Collecteur(collecteurs[i].getCollecteur(), collecteurs[i].getFlux(), tcDelaiCollecte);
            c.setPriority(Thread.MIN_PRIORITY);
            collecteurs[i] = c;
        }
    }

    private void actualiseInfosCollecteFlux() {
        if (collecteur != null) { // Pour pouvoir désactiver la collecte lors de tests (obsolète d'ailleurs)
            for (int i = 0; i < collecteurs.length; i++) {
                String id = collecteurs[i].getFlux().ID;
                int nbPlantes = 1;
                for(int j = 0 ; j < vieuxCollecteurs.size(); j++){
                    if(vieuxCollecteurs.elementAt(j).getFlux().ID.equals(id)){
                        nbPlantes++;
                    }
                }
                if (collecteurs[i].getTemps() > 60000 * Integer.parseInt(tcDelaiCollecte.getText()) * nbPlantes && collecteurs[i].isRunning()) {
                    collecteurs[i].fin();
                    collecteurs[i].setPlante(true);
                    vieuxCollecteurs.addElement(collecteurs[i]);
                    Collecteur c = new Collecteur(collecteurs[i].getCollecteur(), collecteurs[i].getFlux(), tcDelaiCollecte);
                    c.setPriority(Thread.MIN_PRIORITY);
                    c.start();
                    collecteurs[i] = c;
                }
            }
            Vector<Collecteur> tousCollecteurs = new Vector<Collecteur>();
            for(int i=0; i<collecteurs.length; i++){
                tousCollecteurs.addElement(collecteurs[i]);
            }
            tousCollecteurs.addAll(vieuxCollecteurs);
            Collecteur[] tousCollecteurs2 = new Collecteur[tousCollecteurs.size()];
            tousCollecteurs.toArray(tousCollecteurs2);
            int x1 = lCollecte.getFirstVisibleIndex();
            int x2 = lCollecte.getLastVisibleIndex();
            lCollecte = new JList(tousCollecteurs2);
            lCollecte.setEnabled(false);
            spCollecte.setViewportView(lCollecte);
            lCollecte.ensureIndexIsVisible(x2);
            lCollecte.ensureIndexIsVisible(x1);
            //lCollecte.repaint();
            for (int i = 0; i < vieuxCollecteurs.size(); i++) {
                Collecteur c = vieuxCollecteurs.elementAt(i);
                if (c.isStopped()) {
                    vieuxCollecteurs.remove(c);
                }
            }
            int nbCollectesEnCours = 0;
            for (int i = 0; i < collecteurs.length; i++) {
                if (collecteurs[i].isEnTrainDeLire()) {
                    nbCollectesEnCours++;
                }
            }
            lcEtat.setText("Articles à traiter : " + collecteur.getEntreesEnReserve() +
                    " --- Lectures en cours : " + nbCollectesEnCours +
                    " --- Lectures plantées : " + vieuxCollecteurs.size());
            ljInfoCollecte.setText(lcEtat.getText() + " --- " +
                    lcLemmatisation.getText() + " --- " +
                    lcCapture.getText());
        }
    }

    private void lanceLemmatisationTempsReel() {
        collecteur.activeLemmatisation();
        Out.printInfo("Lemmatisation " + (collecteur.getStatutLemmatisation() ? "activée" : "désativée"));
    }

    private void stoppeLemmatisationTempsReel() {
        collecteur.desactiveLemmatisation();
        Out.printInfo("Lemmatisation " + (collecteur.getStatutLemmatisation() ? "activée" : "désativée"));
    }
    private CollecteurSujets collecteurSujets;
    private NewsSaver collecteurNews;

    private void initCollecteSujets() {
        if (baseIPRI.connect() != Database.DB_OK) {
            lcEtat3.setText("ATTENTION : Connexion impossible à la base de données IPRI.");
            return;
        } else {
            lcEtat3.setText("Collecte des sujets lancée.");
        }
        collecteurNews = new NewsSaver(baseIPRI);
        collecteurNews.start();
        collecteurSujets = new CollecteurSujets(collecteurNews);
        collecteurSujets.setPriority(Thread.MIN_PRIORITY);
        lCollecteSujets = new JList(new CollecteurSujets[]{collecteurSujets});
        lCollecteSujets.setEnabled(false);
        spCollecteSujets.setViewportView(lCollecteSujets);
    }

    private void lanceCollecteSujets() {
        collecteurSujets.start();
    }
    Vector<CollecteurSujets> vieuxCollecteursSujets = new Vector<CollecteurSujets>();

    private void stoppeCollecteSujets() {
        if (collecteurSujets.isRunning()) {
            collecteurSujets.fin();
            vieuxCollecteursSujets.addElement(collecteurSujets);
        }
        CollecteurSujets c = new CollecteurSujets(collecteurNews);
        c.setPriority(Thread.MIN_PRIORITY);
        collecteurSujets = c;
    }

    public void changeTag() {
        stoppeCollecteFlux();
        bcCollecte.setSelected(false);
        bcLemmatisation.setSelected(false);
        try {
            RSSFeedDatabase base = new RSSFeedDatabase(baseIPRI);

            Tag[] listeTags = panelFluxCollecte.listeTagsAcceptes();
            Vector<RSSFeedInfoExtended> listeFlux = base.getExtendedRSSFeedList(listeTags);

            lcNbFlux.setText(listeFlux.size() + " flux");

            final RSSFeedInfoExtended[] liste = collecteur.getFeedsList(listeFlux);
            collecteurs = new Collecteur[liste.length];
            for (int i = 0; i < liste.length; i++) {
                collecteurs[i] = new Collecteur(collecteur, liste[i], tcDelaiCollecte);
                collecteurs[i].setPriority(Thread.MIN_PRIORITY);
            }
            lCollecte = new JList(collecteurs);
            lCollecte.setEnabled(false);
            spCollecte.setViewportView(lCollecte);
        } catch (NoBaseException nbe) {
            lcNbFlux.setText("Base indisponible.");
        }
    }

    /*private void dechargeDepechesOld() {
    new Thread() {

    @Override
    public void run() {
    try {
    long time = System.currentTimeMillis();
    int nbDepeches = Integer.parseInt(jFormattedTextField10.getText());
    if (nbDepeches < 0) {
    nbDepeches = 0;
    } else if (nbDepeches > 200) {
    nbDepeches = 200;
    }
    if (baseIPRI.connect() != Database.DB_OK) {
    jLabel11.setText("ATTENTION : Connexion impossible à la base de données IPRI.");
    return;
    } else {
    jLabel11.setText("Récupération des articles en cours.");
    }
    RSSFeedDatabase base = new RSSFeedDatabase(baseIPRI);
    Vector<RSSItem> resultat = new Vector<RSSItem>(base.getAnAmountOfRssItem(500));
    Vector<RSSItem> conserves = new Vector<RSSItem>();
    for (int i = 0; i < resultat.size(); i++) {
    // Elimination des articles avec un chapeau vide
    // (moins de 10 caractères)
    String chapeau = resultat.elementAt(i).getDescription();
    if (chapeau.length() < 10) {
    // rien
    } else {
    conserves.add(resultat.elementAt(i));
    }
    }
    liste = new RSSItem[Math.min(nbDepeches, conserves.size())];
    for (int i = 0; i < liste.length; i++) {
    liste[i] = conserves.elementAt(i);
    }
    long elapsed = System.currentTimeMillis() - time;
    jLabel11.setText(liste.length + " article" + (liste.length > 1 ? "s" : "") +
    " récupéré" + (liste.length > 1 ? "s" : "") + " en " + (elapsed / 1000) + " seconde" +
    ((elapsed / 1000) > 1 ? "s" : "") + ".");
    } catch(NoBaseException nbe){
    jLabel11.setText("Base indisponible.");
    }
    }
    }.start();
    }*/
    private void dechargeDepeches() {
        new Thread() {

            @Override
            public void run() {
                try {
                    long time = System.currentTimeMillis();
                    int nbDepeches = Integer.parseInt(jFormattedTextField10.getText());
                    if (nbDepeches < 0) {
                        nbDepeches = 0;
                    } else if (nbDepeches > 200) {
                        nbDepeches = 200;
                    }
                    if (baseIPRI.connect() != Database.DB_OK) {
                        leeCNewStatus.setText("ATTENTION : Connexion impossible à la base de données IPRI.");
                        return;
                    } else {
                        leeCNewStatus.setText("Récupération des articles en cours.");
                    }
                    RSSFeedDatabase base = new RSSFeedDatabase(baseIPRI);
                    Vector<RSSItem> resultat = new Vector<RSSItem>(base.getAnAmountOfRssItem(500));
                    Vector<RSSItem> conserves = new Vector<RSSItem>();
                    for (int i = 0; i < resultat.size(); i++) {
                        // Elimination des articles avec un chapeau vide
                        // (moins de 10 caractères)
                        String chapeau = resultat.elementAt(i).getDescription();
                        if (chapeau.length() < 10) {
                            // rien
                        } else {
                            conserves.add(resultat.elementAt(i));
                        }
                    }
                    liste = new RSSItem[Math.min(nbDepeches, conserves.size())];
                    for (int i = 0; i < liste.length; i++) {
                        liste[i] = conserves.elementAt(i);
                    }
                    long elapsed = System.currentTimeMillis() - time;
                    leeCNewStatus.setText(liste.length + " article" + (liste.length > 1 ? "s" : "") +
                            " récupéré" + (liste.length > 1 ? "s" : "") + " en " + (elapsed / 1000) + " seconde" +
                            ((elapsed / 1000) > 1 ? "s" : "") + ".");
                } catch (NoBaseException nbe) {
                    leeCNewStatus.setText("Base indisponible.");
                }
            }
        }.start();
    }
    private RSSItem[] liste = new RSSItem[200];

    /*private void placeDepechesDansCorpusOld() {
    new Thread() {

    @Override
    public void run() {
    long time = System.currentTimeMillis();
    jLabel12.setText("Constitution du corpus en cours.");
    for (int i = 0; i < liste.length; i++) {
    tableCorpus.setArticleAt(i, liste[i].getId(),
    liste[i].getTitle(), liste[i].getDescription(), new ThemaItem());
    }
    long elapsed = System.currentTimeMillis() - time;
    jLabel12.setText("Corpus constitué en " + (elapsed / 1000) + " seconde" +
    ((elapsed / 1000) > 1 ? "s" : "") + ".");
    }
    }.start();
    }*/
    private void placeDepechesDansCorpus() {
        new Thread() {

            @Override
            public void run() {
                long time = System.currentTimeMillis();
                leeCNewStatus.setText("Constitution du corpus en cours.");
                for (int i = 0; i < liste.length; i++) {
                    tableCorpus.setArticleAt(i, liste[i].getId(),
                            liste[i].getTitle(), liste[i].getDescription(), new ThemaItem());
                }
                long elapsed = System.currentTimeMillis() - time;
                leeCNewStatus.setText("Corpus constitué en " + (elapsed / 1000) + " seconde" +
                        ((elapsed / 1000) > 1 ? "s" : "") + ".");
                leeCDesc.setText("Corpus actuellement choisi : " + liste.length + " articles.");
                completeExperiences();
            }
        }.start();
    }

    private void completeExperiences() {
        tableExperiences.completeExperiences();
        tableCorpus.actualise();
    }

    private void completeExperiences2() {
        tableExperiences2.completeExperiences();
    }
    private ThemaGraph themaGraph = null;
    private boolean IPTCCharge = false;

    private void afficheArbreIPTC() {
        new Thread() {

            @Override
            public void run() {
                try {
                    if (baseIPRI.connect() != Database.DB_OK) {
                        leThesaurus.setText("ATTENTION : Connexion impossible à la base de données IPRI.");
                        return;
                    } else {
                        leThesaurus.setText("Récupération de la taxonomie IPTC en cours.");
                    }
                    ThesaurusDatabase base = new ThesaurusDatabase(baseIPRI);
                    Vector<ThemaItem> racines = new Vector<ThemaItem>(base.getTopClasses(1));
                    ThemaItem[] tRacines = new ThemaItem[racines.size()];
                    racines.toArray(tRacines);
                    Arrays.sort(tRacines, new ComparateurIPTC());
                    DefaultMutableTreeNode racine = new DefaultMutableTreeNode("Taxonomie IPTC");
                    for (int i = 0; i < tRacines.length; i++) {
                        rattacheNoeudIPTC(base, tRacines[i], racine);
                    }
                    teThesaurus.setModel(new DefaultTreeModel(racine));
                    leThesaurus.setText("Taxonomie IPTC récupéré.");
                    themaGraph = new ThemaGraph(baseIPRI);
                    proc.thema.Experiences.setThemas(themaGraph);
                    IPTCCharge = true;
                    completeExperiences();
                } catch (NoBaseException nbe) {
                    leThesaurus.setText("Base indisponible.");
                }
            }
        }.start();
    }

    private void rattacheNoeudIPTC(ThesaurusDatabase base, ThemaItem noeud, DefaultMutableTreeNode parent)
            throws NoBaseException {
        String s = "<html>";
        s += noeud.getConceptName() + " - <font size=\"2\">" + noeud.getConceptDesc() + "</font><br>";
        Vector<LemmaItem> lemmes = new Vector<LemmaItem>(base.getLemmas(noeud.getConceptID()));
        LemmaItem[] tLemmes = new LemmaItem[lemmes.size()];
        lemmes.toArray(tLemmes);
        Arrays.sort(tLemmes, new ComparateurIPTC2());
        if (tLemmes.length > 0) {
            s += " {<i><font size=\"2\">";
            for (int i = 0; i < tLemmes.length; i++) {
                s += tLemmes[i].getLemmaName();
                if (i < tLemmes.length - 1) {
                    s += "</font>, <font size=\"2\">";
                }
            }
            s += "</font></i>}";
        }
        DefaultMutableTreeNode fils = new DefaultMutableTreeNode(s);
        parent.add(fils);
        Vector<ThemaItem> suite = new Vector<ThemaItem>(base.getSubclasses(noeud.getConceptID()));
        ThemaItem[] tSuite = new ThemaItem[suite.size()];
        suite.toArray(tSuite);
        Arrays.sort(tSuite, new ComparateurIPTC());
        for (int i = 0; i < tSuite.length; i++) {
            rattacheNoeudIPTC(base, tSuite[i], fils);
        }
    }

    public void effectueRecherche() {
        lsrRecherche.setText("Recherche en cours.");
        String[] s = tsrRecherche.getText().trim().split(" ");
        if (s.length == 0) {
            return;
        }
        tsrRecherche.setText(s[0]);
        final String texteARechercher = s[0];
        new Thread() {

            @Override
            public void run() {
                try {
                    StatsDatabase sd = new StatsDatabase(baseIPRI);
                    Map<String, String> resultat = sd.trouveArticlesParlantDe(texteARechercher);
                    Set<String> sources0 = new HashSet<String>();
                    Vector<String> articles = new Vector<String>(resultat.keySet());
                    for (int i = 0; i < articles.size(); i++) {
                        sources0.add(resultat.get(articles.elementAt(i)));
                    }
                    Vector<String> sources = new Vector(sources0);
                    DefaultMutableTreeNode racine = new DefaultMutableTreeNode("Résultat");
                    Map<String, DefaultMutableTreeNode> nodes = new HashMap<String, DefaultMutableTreeNode>();
                    for (int i = 0; i < sources.size(); i++) {
                        DefaultMutableTreeNode n = new DefaultMutableTreeNode(sources.elementAt(i));
                        racine.add(n);
                        nodes.put(sources.elementAt(i), n);
                    }
                    for (int i = 0; i < articles.size(); i++) {
                        DefaultMutableTreeNode n = new DefaultMutableTreeNode(articles.elementAt(i));
                        DefaultMutableTreeNode n2 = nodes.get(resultat.get(articles.elementAt(i)));
                        n2.add(n);
                    }
                    tsrResultat.setModel(new DefaultTreeModel(racine));
                    lsrRecherche.setText("Recherche terminée.");
                } catch (NoBaseException nbe) {
                    lsrRecherche.setText("Base indisponible.");
                }
            }
        }.start();
    }

    /*private void chargeCorpusOld() {
    new Thread() {

    @Override
    public void run() {
    long time = System.currentTimeMillis();
    if (baseIPRI.connect() != Database.DB_OK) {
    jLabel16.setText("ATTENTION : Connexion impossible à la base de données IPRI.");
    return;
    } else {
    jLabel16.setText("Récupération du corpus d'études en cours.");
    }
    CorpusDatabase base = new CorpusDatabase(baseIPRI);
    ThesaurusDatabase base2 = new ThesaurusDatabase(baseIPRI);
    Vector<CorpusItem> items = base.loadCorpus();
    jLabel16.setText("Récupération du corpus d'études en cours.");

    for (int i = 0; i < Math.min(200, items.size()); i++) {
    ThemaItem item = base2.getClasse(items.elementAt(i).getThemaId());
    if(item==null){
    item = new ThemaItem();
    }
    tableCorpus.setArticleAt(i,
    items.elementAt(i).getIdItem(),
    items.elementAt(i).getRSSItemTitle().trim(),
    items.elementAt(i).getRSSItemDesc().trim(),
    item);
    }
    long elapsed = System.currentTimeMillis() - time;
    jLabel16.setText("Corpus de " + items.size() + " articles chargé en " +
    (elapsed / 1000) + " seconde" +
    ((elapsed / 1000) > 1 ? "s" : "") + ".");
    }
    }.start();
    }*/
    private void chargeCorpus() {
        new Thread() {

            @Override
            public void run() {
                try {
                    leeCLoadStatus.setText("En attente du chargement de la taxonomie IPTC...");
                    while (!IPTCCharge) {
                        try {
                            Thread.sleep(100);
                        } catch (InterruptedException ie) {
                        }
                    }
                    long time = System.currentTimeMillis();
                    if (baseIPRI.connect() != Database.DB_OK) {
                        leeCLoadStatus.setText("ATTENTION : Connexion impossible à la base de données IPRI.");
                        return;
                    } else {
                        leeCLoadStatus.setText("Récupération du corpus d'études en cours.");
                    }
                    proc.thema.Experiences.setCorpus(new CorpusGraph(baseIPRI));
                    CorpusDatabase base = new CorpusDatabase(baseIPRI);
                    ThesaurusDatabase base2 = new ThesaurusDatabase(baseIPRI);
                    Vector<CorpusItem> items = base.loadCorpus();

                    for (int i = 0; i < Math.min(200, items.size()); i++) {
                        ThemaItem item = base2.getClasse(items.elementAt(i).getThemaId());
                        if (item == null) {
                            item = new ThemaItem();
                        }
                        tableCorpus.setArticleAt(i,
                                items.elementAt(i).getIdItem(),
                                items.elementAt(i).getRSSItemTitle().trim(),
                                items.elementAt(i).getRSSItemDesc().trim(),
                                item);
                    }
                    long elapsed = System.currentTimeMillis() - time;
                    leeCLoadStatus.setText("Corpus de " + items.size() + " articles " +
                            "chargé en " + (elapsed / 1000) + " seconde" +
                            ((elapsed / 1000) > 1 ? "s" : "") + ". Vous pouvez le " +
                            "voir dans l'onglet Corpus.");
                    leeCDesc.setText("Corpus actuellement choisi : " + items.size() + " articles.");
                    completeExperiences();
                } catch (NoBaseException nbe) {
                    leeCLoadStatus.setText("Base indisponible.");
                }
            }
        }.start();
    }

    /*private void sauvegardeCorpusOld() {
    new Thread() {

    @Override
    public void run() {
    long time = System.currentTimeMillis();
    if (baseIPRI.connect() != Database.DB_OK) {
    jLabel17.setText("ATTENTION : Connexion impossible à la base de données IPRI.");
    return;
    } else {
    jLabel17.setText("Sauvegarde du corpus d'études en cours.");
    }
    CorpusDatabase base = new CorpusDatabase(baseIPRI);
    Vector<CorpusItem> items = new Vector<CorpusItem>();
    for (int i = 0; i < tableCorpus.getTaille(); i++) {
    if (tableCorpus.getTitreAt(i) != null) {
    if (!(tableCorpus.getTitreAt(i).equalsIgnoreCase(""))) {
    int id = tableCorpus.getIdAt(i);
    String title = tableCorpus.getTitreAt(i);
    String desc = tableCorpus.getDescriptionAt(i);
    int themaId = tableCorpus.getIdThematiqueAt(i);
    items.add(new CorpusItem(id, title, desc, themaId));
    }
    }
    }
    base.saveCorpus(items);
    long elapsed = System.currentTimeMillis() - time;
    jLabel17.setText(items.size() + " articles sauvegardés en " +
    (elapsed / 1000) + " seconde" +
    ((elapsed / 1000) > 1 ? "s" : "") + ".");
    }
    }.start();
    }*/
    private void sauvegardeCorpus() {
        new Thread() {

            @Override
            public void run() {
                try {
                    long time = System.currentTimeMillis();
                    if (baseIPRI.connect() != Database.DB_OK) {
                        leeCNewStatus.setText("ATTENTION : Connexion impossible à la base de données IPRI.");
                        return;
                    } else {
                        leeCNewStatus.setText("Sauvegarde du corpus d'études en cours.");
                    }
                    CorpusDatabase base = new CorpusDatabase(baseIPRI);
                    Vector<CorpusItem> items = new Vector<CorpusItem>();
                    for (int i = 0; i < tableCorpus.getTaille(); i++) {
                        if (tableCorpus.getTitreAt(i) != null) {
                            if (!(tableCorpus.getTitreAt(i).equalsIgnoreCase(""))) {
                                int id = tableCorpus.getIdAt(i);
                                String title = tableCorpus.getTitreAt(i);
                                String desc = tableCorpus.getDescriptionAt(i);
                                int themaId = tableCorpus.getIdThematiqueAt(i);
                                items.add(new CorpusItem(id, title, desc, themaId));
                            }
                        }
                    }
                    base.saveCorpus(items);
                    proc.thema.Experiences.setCorpus(new CorpusGraph(baseIPRI));
                    long elapsed = System.currentTimeMillis() - time;
                    leeCNewStatus.setText(items.size() + " articles sauvegardés en " +
                            (elapsed / 1000) + " seconde" +
                            ((elapsed / 1000) > 1 ? "s" : "") + ".");
                    completeExperiences();
                } catch (NoBaseException nbe) {
                    leeCNewStatus.setText("Base indisponible.");
                }
            }
        }.start();
    }

    void sauvegardeManuel() {
        sauvegardeCorpus();
    }

    private void creeCorpusClustering() {
        new Thread() {

            @Override
            public void run() {
                long time = System.currentTimeMillis();
                if (baseIPRI.connect() != Database.DB_OK) {
                    leecLoadStatus2.setText("Connexion impossible.");
                    return;
                } else {
                    leecLoadStatus2.setText("Création en cours.");
                }
                int taille = Integer.parseInt(teeCNbArticles2.getText());
                proc.cluster.Experiences.setCorpus(new ClusteringCorpusGraph(baseIPRI, taille));
                long elapsed = System.currentTimeMillis() - time;
                leecLoadStatus2.setText("Création terminée en " + (elapsed / 1000) + "s.");
            }
        }.start();
    }
    private ThemaIdentifier tid;
    private long debutAnalyseDirecte;

    private void calculDirectIPTC() {
        timerCalculDirect.start();
        new Thread() {

            @Override
            public void run() {
                if (baseIPRI.connect() != Database.DB_OK) {
                    jLabel19.setText("ATTENTION : Connexion impossible à la base de données IPRI.");
                    return;
                } else {
                    jLabel19.setText("Recherche des thématiques en cours.");
                }
                tid = new ThemaIdentifier(baseIPRI);
                debutAnalyseDirecte = System.currentTimeMillis();
                String[] s = {};
                try {
                    s = tid.calculDirect();
                    for (int i = 0; i < s.length; i++) {
                        //tableCorpus.setResultatExperienceAt(i, 0, s[i]);
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    s = tid.calculDirect2();
                    for (int i = 0; i < s.length; i++) {
                        //tableCorpus.setResultatExperienceAt(i, 1, s[i]);
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
                long elapsed = System.currentTimeMillis() - debutAnalyseDirecte;
                jLabel19.setText(s.length + " thématiques trouvées en " + (elapsed / 60000) +
                        " minutes et " + (elapsed % 60000 / 1000) + " secondes.");
                timerCalculDirect.stop();
            }
        }.start();
    }
    private Timer timerCalculDirect = new Timer(1000, new ActionListener() {

        public void actionPerformed(ActionEvent ae) {
            long elapsed = System.currentTimeMillis() - debutAnalyseDirecte;
            String hr = "" + (elapsed / 3600000);
            if (hr.length() < 2) {
                hr = "0" + hr;
            }
            String mn = "" + (elapsed % 3600000 / 60000);
            if (mn.length() < 2) {
                mn = "0" + mn;
            }
            String s = "" + (elapsed % 60000 / 1000);
            if (s.length() < 2) {
                s = "0" + s;
            }
            if (tid != null) { // Au démarrage, ça na pas encore été instancié
                jLabel40.setText("Etude de l'article " +
                        tid.getCurrentState() +
                        " - " + hr + ":" + mn + ":" + s + ".");
            }
        }
    });
    private ThemaIdentifier tid2;
    private long debutAnalyse;

    private void enrichisCorpus() {
        timerAnalyseCorpus.start();
        new Thread() {

            @Override
            public void run() {
                if (baseIPRI.connect() != Database.DB_OK) {
                    jLabel13.setText("ATTENTION : Connexion impossible à la base de données IPRI.");
                    return;
                } else {
                    jLabel13.setText("Enrichissement sémantique en cours.");
                }
                tid2 = new ThemaIdentifier(baseIPRI);
                debutAnalyse = System.currentTimeMillis();
                String[] s = {};
                //Les déconnexions sont choses courantes avec DBPedia
                boolean echec = false;
                try {
                    s = tid2.processCorpus();
                } catch (Exception e) {
                    echec = true;
                    e.printStackTrace();
                }
                long elapsed = System.currentTimeMillis() - debutAnalyse;
                jLabel13.setText((echec ? "[ECHEC]" : "") +
                        s.length + " articles enrichis en " + (elapsed / 60000) +
                        " minutes et " + (elapsed % 60000 / 1000) + " secondes.");
                timerAnalyseCorpus.stop();
            }
        }.start();
    }
    private Timer timerAnalyseCorpus = new Timer(1000, new ActionListener() {

        public void actionPerformed(ActionEvent ae) {
            long elapsed = System.currentTimeMillis() - debutAnalyse;
            String hr = "" + (elapsed / 3600000);
            if (hr.length() < 2) {
                hr = "0" + hr;
            }
            String mn = "" + (elapsed % 3600000 / 60000);
            if (mn.length() < 2) {
                mn = "0" + mn;
            }
            String s = "" + (elapsed % 60000 / 1000);
            if (s.length() < 2) {
                s = "0" + s;
            }
            if (tid2 != null) { // Au démarrage, ça na pas encore été instancié
                jLabel37.setText("Etude de l'article " +
                        tid2.getCurrentState() +
                        " - " + hr + ":" + mn + ":" + s + ".");
            }
        }
    });

    private void lanceRequeteDBPedia() {
        debutSPARQL = System.currentTimeMillis();
        lesReponse.setText("Requête en cours de traitement.");
        taesReponse.setText("");
        timerSPARQL.start();
        new Thread() {

            @Override
            public void run() {
                data.base.connectors.SemanticDatabase query = new data.base.connectors.SemanticDatabase(baseIPRI);
                taesReponse.setText(query.sendQuery(taesRequete.getText()));
                timerSPARQL.stop();
                long elapsed = System.currentTimeMillis() - debutSPARQL;
                lesReponse.setText("Requête traitée en " + (elapsed / 1000) + " secondes.");
            }
        }.start();
    }
    private long debutSPARQL;
    private Timer timerSPARQL = new Timer(1000, new ActionListener() {

        public void actionPerformed(ActionEvent ae) {
            long elapsed = System.currentTimeMillis() - debutSPARQL;
            String hr = "" + (elapsed / 3600000);
            if (hr.length() < 2) {
                hr = "0" + hr;
            }
            String mn = "" + (elapsed % 3600000 / 60000);
            if (mn.length() < 2) {
                mn = "0" + mn;
            }
            String s = "" + (elapsed % 60000 / 1000);
            if (s.length() < 2) {
                s = "0" + s;
            }
            lesReponse.setText("Requête en cours de traitement - " +
                    hr + ":" + mn + ":" + s + ".");
        }
    });

    private void dechargeDepechesParDate() {
        new Thread() {

            @Override
            public void run() {
                try {
                    long time = System.currentTimeMillis();
                    if (baseIPRI.connect() != Database.DB_OK) {
                        jLabel10.setText("ATTENTION : Connexion impossible à la base de données IPRI.");
                        return;
                    } else {
                        jLabel10.setText("Récupération des articles en cours.");
                    }
                    int jj = Integer.parseInt(jFormattedTextField2.getText());
                    int mm = Integer.parseInt(jFormattedTextField3.getText());
                    int aaaa = Integer.parseInt(jFormattedTextField1.getText());
                    RSSFeedDatabase base = new RSSFeedDatabase(baseIPRI);
                    Vector<RSSItem> resultat = new Vector<RSSItem>(base.getAllRssItemsOfDate(jj, mm, aaaa));
                    listeDate = new RSSItem[resultat.size()];
                    for (int i = 0; i < listeDate.length; i++) {
                        listeDate[i] = resultat.elementAt(i);
                    }
                    long elapsed = System.currentTimeMillis() - time;
                    jLabel10.setText(listeDate.length + " articles récupérés en " + (elapsed / 1000) + " seconde" +
                            ((elapsed / 1000) > 1 ? "s" : "") + ".");
                } catch (NoBaseException nbe) {
                    jLabel10.setText("Base indisponible.");
                }
            }
        }.start();
    }
    private RSSItem[] listeDate;

    private void dechargeDepechesEntreDates() {
        new Thread() {

            @Override
            public void run() {
                try {
                    long time = System.currentTimeMillis();
                    if (baseIPRI.connect() != Database.DB_OK) {
                        jLabel10.setText("ATTENTION : Connexion impossible à la base de données IPRI.");
                        return;
                    } else {
                        jLabel10.setText("Récupération des articles en cours.");
                    }
                    int jj1 = Integer.parseInt(jFormattedTextField4.getText());
                    int mm1 = Integer.parseInt(jFormattedTextField5.getText());
                    int aaaa1 = Integer.parseInt(jFormattedTextField6.getText());
                    int jj2 = Integer.parseInt(jFormattedTextField7.getText());
                    int mm2 = Integer.parseInt(jFormattedTextField8.getText());
                    int aaaa2 = Integer.parseInt(jFormattedTextField9.getText());
                    RSSFeedDatabase base = new RSSFeedDatabase(baseIPRI);
                    Vector<RSSItem> resultat = new Vector<RSSItem>(base.getAllRssItemsBetween(jj1, mm1, aaaa1, jj2, mm2, aaaa2));
                    listeDate = new RSSItem[resultat.size()];
                    for (int i = 0; i < listeDate.length; i++) {
                        listeDate[i] = resultat.elementAt(i);
                    }
                    long elapsed = System.currentTimeMillis() - time;
                    jLabel10.setText(listeDate.length + " articles récupérés en " + (elapsed / 1000) + " seconde" +
                            ((elapsed / 1000) > 1 ? "s" : "") + ".");
                } catch (NoBaseException nbe) {
                    jLabel10.setText("Base indisponible.");
                }
            }
        }.start();
    }

    private ThemaItem[] getTopThematiques() {
        try {
            if (baseIPRI.connect() != Database.DB_OK) {
                return new ThemaItem[]{};
            } else {
                Set<ThemaItem> res = new ThesaurusDatabase(baseIPRI).getTopClasses();
                ThemaItem[] res1 = new ThemaItem[res.size()];
                res.toArray(res1);
                Arrays.sort(res1, new ComparateurThemaItems());
                ThemaItem[] res2 = new ThemaItem[res1.length + 1];
                res2[0] = new ThemaItem();
                for (int i = 1; i < res2.length; i++) {
                    res2[i] = res1[i - 1];
                }
                return res2;
            }
        } catch (NoBaseException nbe) {
            return new ThemaItem[]{};
        }
    }

    private void parseIPTCThemas() {
        final Component c = this;
        new Thread() {

            @Override
            public void run() {
                ThesaurusDatabase tdb = new ThesaurusDatabase(baseIPRI);
                JFileChooser jfc = new JFileChooser();
                int choix = jfc.showOpenDialog(c);
                if (choix == JFileChooser.APPROVE_OPTION) {
                    File f = jfc.getSelectedFile();
                    try {
                        // La taxonomie 1 est l'IPTC
                        tdb.resetTaxonomie(1);
                        BufferedReader r = new BufferedReader(
                                new InputStreamReader(
                                new FileInputStream(f),
                                "UTF-8")/*new FileReader(f)*/);
                        int n = 0;
                        while (r.ready()) {
                            String ligne0 = Codecs.desEscapeUnicode(r.readLine());
                            // Parfois il y a des caractères en début de ligne... pourquoi ?
                            // En tous cas, toutes les lignes doivent commencer par un identifiant.
                            while (!(Character.isDigit(ligne0.charAt(0)))) {
                                ligne0 = ligne0.substring(1);
                            }
                            String[] ligne = ligne0.split("\\\t");
                            int id = Integer.parseInt(ligne[0]);
                            String nomEN = ligne[1];
                            String descEN = ligne[2];
                            String nomFR = ligne[3];
                            String descFR = ligne[4];
                            int parent = Integer.parseInt(ligne[5]);
                            tdb.storeClasse(1, id, nomEN, descEN, nomFR, descFR, parent);
                            n++;
                            lefLignesLuesIPTC.setText(n + " lignes lues (total : environ 1500).");
                        }
                        lefLignesLuesIPTC.setText("Lecture terminée.");
                    } catch (IOException ex) {
                        ex.printStackTrace();
                    } catch (NoBaseException nbe) {
                        lefLignesLuesIPTC.setText("Base indisponible.");
                    }
                }
            }
        }.start();
    }

    private void parseDBPediaLabelsConcepts() {
        jLabel43.setText("Lecture des concepts en cours.");
        final Component c = this;
        new Thread() {

            @Override
            public void run() {
                try {
                    DBPediaDatabase ddb = new DBPediaDatabase(baseIPRI);
                    ddb.resetPages();
                    JFileChooser jfc = new JFileChooser();
                    int choix = jfc.showOpenDialog(c);
                    if (choix == JFileChooser.APPROVE_OPTION) {
                        File f = jfc.getSelectedFile();
                        try {
                            int n = 0;
                            BufferedReader r = new BufferedReader(new FileReader(f));
                            while (r.ready()) {
                                String ligne = Codecs.desEscapeUnicode(r.readLine());
                                String concept = ligne.split("\\s")[0];
                                concept = concept.replaceAll("<", "").replaceAll(">", "");
                                String label = "";
                                int l = ligne.split("\\\"").length;
                                for (int i = 1; i < l - 1; i++) {
                                    label += ligne.split("\\\"")[i];
                                    if (i < l - 2) {
                                        label += "\"";
                                    }
                                }
                                ddb.storeLabelPage(label, concept);
                                n++;
                            }
                            System.out.println("Récupération des concepts DBPédia terminée !");
                        } catch (IOException ex) {
                            ex.printStackTrace();
                        }
                    }
                    jLabel43.setText("Lecture des concepts terminée.");
                } catch (NoBaseException nbe) {
                    jLabel43.setText("Base indisponible.");
                }
            }
        }.start();
    }

    private void parseDBPediaDescConcepts() {
        jLabel43.setText("Lecture des descriptions de concepts en cours.");
        final Component c = this;
        new Thread() {

            @Override
            public void run() {
                try {
                    DBPediaDatabase ddb = new DBPediaDatabase(baseIPRI);
                    JFileChooser jfc = new JFileChooser();
                    int choix = jfc.showOpenDialog(c);
                    if (choix == JFileChooser.APPROVE_OPTION) {
                        File f = jfc.getSelectedFile();
                        try {
                            int n = 0;
                            BufferedReader r = new BufferedReader(new FileReader(f));
                            while (r.ready()) {
                                String ligne = Codecs.desEscapeUnicode(r.readLine());
                                String concept = ligne.split("\\s")[0];
                                concept = concept.replaceAll("<", "").replaceAll(">", "");
                                String desc = "";
                                int l = ligne.split("\\\"").length;
                                for (int i = 1; i < l - 1; i++) {
                                    desc += ligne.split("\\\"")[i];
                                    if (i < l - 2) {
                                        desc += "\"";
                                    }
                                }
                                ddb.storeDescriptionPage(desc, concept);
                                n++;
                            }
                            System.out.println("Récupération des descriptions de concepts DBPédia terminée !");
                        } catch (IOException ex) {
                            ex.printStackTrace();
                        }
                    }
                    jLabel43.setText("Lecture des concepts terminée.");
                } catch (NoBaseException nbe) {
                    jLabel43.setText("Base indisponible.");
                }
            }
        }.start();
    }

    private void parseDBPediaConceptsCategories() {
        jLabel43.setText("Lecture des catégories en cours.");
        final Component c = this;
        new Thread() {

            @Override
            public void run() {
                try {
                    DBPediaDatabase ddb = new DBPediaDatabase(baseIPRI);
                    ddb.resetCategories();
                    JFileChooser jfc = new JFileChooser();
                    int choix = jfc.showOpenDialog(c);
                    if (choix == JFileChooser.APPROVE_OPTION) {
                        File f = jfc.getSelectedFile();
                        try {
                            int n = 0;
                            BufferedReader r = new BufferedReader(new FileReader(f));
                            while (r.ready()) {
                                r.readLine();
                                n++;
                                if (n % 1000 == 0) {
                                    lefLignesLuesInstances.setText("0 lignes lues sur " + n + ".");
                                }
                            }
                            int max = n;
                            n = 0;
                            r = new BufferedReader(new FileReader(f));
                            while (r.ready()) {
                                String ligne = Codecs.desEscapeUnicode(r.readLine());
                                String concept = ligne.split("\\s")[0];
                                concept = concept.replaceAll("<", "").replaceAll(">", "");
                                String categorie = ligne.split("\\s")[2];
                                categorie = categorie.replaceAll("<", "").replaceAll(">", "");
                                ddb.storeCategorie(concept, categorie);
                                n++;
                                if (n % 100 == 0) {
                                    lefLignesLuesInstances.setText(n + " lignes lues sur " + max + ".");
                                }
                            }
                            lefLignesLuesInstances.setText("Lecture terminée.");
                            //System.out.println("Récupération des catégories DBPédia terminée !");
                        } catch (IOException ex) {
                            ex.printStackTrace();
                        }
                    }
                    jLabel43.setText("Lecture des catégories terminée.");
                } catch (NoBaseException nbe) {
                    jLabel43.setText("Base indisponible.");
                }
            }
        }.start();
    }

    private void lieConceptsOntologie() {
        new Thread() {

            @Override
            public void run() {
                try {
                    DBPediaDatabase ddb = new DBPediaDatabase(baseIPRI);
                    int max = ddb.getConceptsCount();
                    int debut = ddb.getLastConceptLieOnto();
                    lefOntoLie.setText("0 concepts liés sur " + max + ".");
                    for (int i = debut; i < max; i++) {
                        ddb.lieConceptOntologie(i);
                        lefOntoLie.setText(i + " concepts liés sur " + max + ".");
                    }
                    lefOntoLie.setText("Terminé.");
                } catch (NoBaseException nbe) {
                    lefOntoLie.setText("Base indisponible.");
                }
            }
        }.start();
    }

    private void lieConceptsWikipedia() {
        new Thread() {

            @Override
            public void run() {
                try {
                    DBPediaDatabase ddb = new DBPediaDatabase(baseIPRI);
                    int max = ddb.getConceptsCount();
                    int debut = ddb.getLastConceptLieWiki();
                    lefWikiLie.setText("0 concepts liés sur " + max + ".");
                    for (int i = debut; i < max; i++) {
                        ddb.lieConceptWikipedia(i);
                        lefWikiLie.setText(i + " concepts liés sur " + max + ".");
                    }
                    lefWikiLie.setText("Terminé.");
                } catch (NoBaseException nbe) {
                    lefWikiLie.setText("Base indisponible.");
                }
            }
        }.start();
    }

    private void parseDBPediaConceptsCategoriesWiki() {
        jLabel43.setText("Lecture des catégories Wiki en cours.");
        final Component c = this;
        new Thread() {

            @Override
            public void run() {
                try {
                    DBPediaDatabase ddb = new DBPediaDatabase(baseIPRI);
                    ddb.resetCategories2();
                    JFileChooser jfc = new JFileChooser();
                    int choix = jfc.showOpenDialog(c);
                    if (choix == JFileChooser.APPROVE_OPTION) {
                        File f = jfc.getSelectedFile();
                        try {
                            int n = 0;
                            BufferedReader r = new BufferedReader(new FileReader(f));
                            while (r.ready()) {
                                r.readLine();
                                n++;
                                if (n % 1000 == 0) {
                                    lefLignesLuesCategories.setText("0 lignes lues sur " + n + ".");
                                }
                            }
                            int max = n;
                            n = 0;
                            r = new BufferedReader(new FileReader(f));
                            while (r.ready()) {
                                String ligne = Codecs.desEscapeUnicode(r.readLine());
                                String concept = ligne.split("\\s")[0];
                                concept = concept.replaceAll("<", "").replaceAll(">", "");
                                String categorie = ligne.split("\\s")[2];
                                categorie = categorie.replaceAll("<", "").replaceAll(">", "");
                                ddb.storeCategorie2(concept, categorie);
                                n++;
                                if (n % 100 == 0) {
                                    lefLignesLuesCategories.setText(n + " lignes lues sur " + max + ".");
                                }
                            }
                            lefLignesLuesCategories.setText("Lecture terminée.");
                            //System.out.println("Récupération des catégories DBPédia terminée !");
                        } catch (IOException ex) {
                            ex.printStackTrace();
                        }
                    }
                    jLabel43.setText("Lecture des catégories Wiki terminée.");
                } catch (NoBaseException nbe) {
                    jLabel43.setText("Base indisponible.");
                }
            }
        }.start();
    }

    private void parseDBPediaLabelsCategoriesWiki() {
        jLabel43.setText("Lecture des noms des catégories Wiki en cours.");
        final Component c = this;
        new Thread() {

            @Override
            public void run() {
                try {
                    DBPediaDatabase ddb = new DBPediaDatabase(baseIPRI);
                    ddb.resetLabelsCategories();
                    JFileChooser jfc = new JFileChooser();
                    int choix = jfc.showOpenDialog(c);
                    if (choix == JFileChooser.APPROVE_OPTION) {
                        File f = jfc.getSelectedFile();
                        try {
                            int n = 0;
                            BufferedReader r = new BufferedReader(new FileReader(f));
                            while (r.ready()) {
                                r.readLine();
                                n++;
                                if (n % 1000 == 0) {
                                    lefLignesLuesCateLabels.setText("0 lignes lues sur " + n + ".");
                                }
                            }
                            int max = n;
                            n = 0;
                            r = new BufferedReader(new FileReader(f));
                            while (r.ready()) {
                                String ligne = Codecs.desEscapeUnicode(r.readLine());
                                String categorie = ligne.split("\\s")[0];
                                categorie = categorie.replaceAll("<", "").replaceAll(">", "");
                                String label = "";
                                int l = ligne.split("\\\"").length;
                                for (int i = 1; i < l - 1; i++) {
                                    label += ligne.split("\\\"")[i];
                                    if (i < l - 2) {
                                        label += "\"";
                                    }
                                }
                                ddb.storeLabelCategorie(categorie, label);
                                n++;
                                if (n % 100 == 0) {
                                    lefLignesLuesCateLabels.setText(n + " lignes lues sur " + max + ".");
                                }
                            }
                            lefLignesLuesCateLabels.setText("Lecture terminée.");
                        } catch (IOException ex) {
                            ex.printStackTrace();
                        }
                    }
                    jLabel43.setText("Lecture des noms des catégories Wiki terminée.");
                } catch (NoBaseException nbe) {
                    jLabel43.setText("Base indisponible.");
                }
            }
        }.start();
    }

    private void parseDBPediaOntologie() {
        jLabel43.setText("Lecture de l'ontologie en cours.");
        final Component c = this;
        new Thread() {

            @Override
            public void run() {
                try {
                    DBPediaDatabase ddb = new DBPediaDatabase(baseIPRI);
                    JFileChooser jfc = new JFileChooser();
                    int choix = jfc.showOpenDialog(c);
                    if (choix == JFileChooser.APPROVE_OPTION) {
                        File f = jfc.getSelectedFile();
                        ddb.resetOntologie();
                        try {
                            BufferedReader r = new BufferedReader(new FileReader(f));
                            String concept = "";
                            String label = "";
                            String parent = "";
                            Vector<String> classes = new Vector<String>();
                            Vector<String> parents = new Vector<String>();
                            int n = 0;
                            while (r.ready()) {
                                String ligne = Codecs.desEscapeUnicode(r.readLine());
                                if (ligne.startsWith("<owl:Class")) {
                                    concept = ligne.substring(ligne.indexOf("\"") + 1, ligne.lastIndexOf("\""));
                                    //System.out.println("nouveau concept : "+concept);
                                } else if (ligne.trim().startsWith("<rdfs:label") && !(concept.equals(""))) {
                                    label = ligne.substring(ligne.indexOf(">") + 1, ligne.lastIndexOf("<"));
                                    //System.out.println("  label : "+label);
                                } else if (ligne.trim().startsWith("<rdfs:subClassOf") && !(concept.equals(""))) {
                                    parent = ligne.substring(ligne.indexOf("\"") + 1, ligne.lastIndexOf("\""));
                                    //System.out.println("  parent : "+parent);
                                } else if (ligne.trim().startsWith("</owl:Class>") && !(concept.equals(""))) {
                                    //Stockage de la classe
                                    ddb.storeClasse(concept, label);
                                    classes.addElement(concept);
                                    parents.addElement(parent);
                                    concept = "";
                                    label = "";
                                    parent = "";
                                }
                                n++;
                                lefLignesLuesOntologie.setText(n + " lignes lues.");
                            }
                            for (int i = 0; i < classes.size(); i++) {
                                ddb.storeRelation(classes.elementAt(i), parents.elementAt(i));
                            }
                            lefLignesLuesOntologie.setText("Lecture de l'ontologie terminée.");
                        } catch (IOException ex) {
                            ex.printStackTrace();
                        }
                    }
                    jLabel43.setText("Lecture de l'ontologie terminée.");
                } catch (NoBaseException nbe) {
                    jLabel43.setText("Base indisponible.");
                }
            }
        }.start();
    }

    private void lemmatiseConceptsDBPedia() {
        jLabel43.setText("Lemmatisation des concepts en cours.");
        new Thread() {

            @Override
            public void run() {
                try {
                    DBPediaDatabase ddb = new DBPediaDatabase(baseIPRI);
                    int depart = ddb.getLastLemmatizedConcept();
                    int nb = ddb.getConceptsCount();
                    for (int i = depart; i < nb; i++) {
                        ddb.lemmatiseConcept(i);
                        lefLemmaConcepts.setText(i + " lignes lues - encore " + (nb - i) + ".");
                    }
                    lefLemmaConcepts.setText("Lecture terminée.");
                    jLabel43.setText("Lemmatisation des concepts terminé.");
                } catch (NoBaseException nbe) {
                    jLabel43.setText("Base indisponible.");
                }
            }
        }.start();
    }

    private void lemmatiseCategoriesWikiDBPedia() {
        jLabel43.setText("Lemmatisation des catégories en cours.");
        new Thread() {

            @Override
            public void run() {
                try {
                    DBPediaDatabase ddb = new DBPediaDatabase(baseIPRI);
                    int depart = ddb.getLastLemmatizedCategorie();
                    int nb = ddb.getCategoriesCount();
                    for (int i = depart; i < nb; i++) {
                        ddb.lemmatiseCategorie(i);
                        lefLemmaCategories.setText(i + " lignes lues - encore " + (nb - i) + ".");
                    }
                    lefLemmaCategories.setText("Lecture terminée.");
                    jLabel43.setText("Lemmatisation des catégories terminé.");
                } catch (NoBaseException nbe) {
                    jLabel43.setText("Base indisponible.");
                }
            }
        }.start();
    }
    private boolean lemmatisationDiffereeEnCours = false;
    private boolean lemmatisationDiffereeActivee = false;

    private void lanceLemmatisationDifferee() {
        lemmatisationDiffereeActivee = true;
        lcLemmatisation.setText("Lancement en cours de la lemmatisation différée.");
        ljInfoCollecte.setText(lcEtat.getText() + " --- " +
                lcLemmatisation.getText() + " --- " +
                lcCapture.getText());
        if (!lemmatisationDiffereeEnCours) {
            lemmatisationDiffereeEnCours = true;
            new Thread() {

                @Override
                public void run() {
                    try {
                        RSSFeedDatabase rdb = new RSSFeedDatabase(baseIPRI);
                        RSSSaver saver = new RSSSaver(baseIPRI);
                        while (lemmatisationDiffereeActivee) {
                            lcLemmatisation.setText("Lancement en cours de la lemmatisation différée.");
                            ljInfoCollecte.setText(lcEtat.getText() + " --- " +
                                    lcLemmatisation.getText() + " --- " +
                                    lcCapture.getText());
                            RSSItem[] aLemmatiser = new RSSItem[]{};
                            if (bcToutCorpus.isSelected()) {
                                aLemmatiser = rdb.getAllArticlesNonLemmatises();
                            } else {
                                SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yy");
                                try {
                                    Date d = sdf.parse(tcCorpusPartielDate.getText());
                                    if (bcCorpusPartiel.isSelected()) {
                                        aLemmatiser = rdb.getAllArticlesNonLemmatisesAPartirDe(d);
                                    } else {
                                        aLemmatiser = rdb.getAllArticlesNonLemmatisesDu(d);
                                    }
                                } catch (ParseException pe) {
                                }
                            }
                            lcLemmatisation.setText("Lemmatisations effectuées : " + 0 + "/" + aLemmatiser.length);
                            ljInfoCollecte.setText(lcEtat.getText() + " --- " +
                                    lcLemmatisation.getText() + " --- " +
                                    lcCapture.getText());
                            for (int i = 0; i < aLemmatiser.length; i++) {
                                Out.printInfo("Lemmatisation différée : [" +
                                        aLemmatiser[i].getId() + "] - " +
                                        aLemmatiser[i].getTitle());
                                saver.reLemmatise(aLemmatiser[i]);
                                lcLemmatisation.setText("Lemmatisations effectuées : " + i + "/" + aLemmatiser.length);
                                ljInfoCollecte.setText(lcEtat.getText() + " --- " +
                                        lcLemmatisation.getText() + " --- " +
                                        lcCapture.getText());
                                if (!lemmatisationDiffereeActivee) {
                                    break;
                                }
                            }
                            lemmatisationDiffereeEnCours = false;
                            stoppeLemmatisationDifferee();
                        }
                        bcLemmatisation2.setSelected(false);
                        lcLemmatisation.setText("Lemmatisation différée terminée.");
                        ljInfoCollecte.setText(lcEtat.getText() + " --- " +
                                lcLemmatisation.getText() + " --- " +
                                lcCapture.getText());
                    } catch (NoBaseException nbe) {
                        lcLemmatisation.setText("Base indisponible.");
                        lemmatisationDiffereeEnCours = false;
                        ljInfoCollecte.setText(lcEtat.getText() + " --- " +
                                lcLemmatisation.getText() + " --- " +
                                lcCapture.getText());
                    }
                }
            }.start();
        }
    }

    private void stoppeLemmatisationDifferee() {
        lemmatisationDiffereeActivee = false;
    }
    private boolean capturesEcranEnCours = false;
    private boolean capturesEcranActivees = false;

    private void lanceCapturesEcran() {
        capturesEcranActivees = true;
        lcCapture.setText("Lancement en cours des captures d'écran.");
        File f = new File(Config.getCaptureDirectory());
        f.mkdirs();
        ljInfoCollecte.setText(lcEtat.getText() + " --- " +
                lcLemmatisation.getText() + " --- " +
                lcCapture.getText());
        if (!capturesEcranEnCours) {
            capturesEcranEnCours = true;
            new Thread() {

                @Override
                public void run() {
                    try {
                        RSSFeedDatabase rdb = new RSSFeedDatabase(baseIPRI);
                        while (capturesEcranActivees) {
                            lcCapture.setText("Lancement en cours des captures d'écran.");
                            ljInfoCollecte.setText(lcEtat.getText() + " --- " +
                                    lcLemmatisation.getText() + " --- " +
                                    lcCapture.getText());
                            RSSItem[] liens = new RSSItem[]{};
                            SousCorpus sousCorpus = new SousCorpus();
                            // Amélioration notable : proposer de construire le sous-corpus.
                            sousCorpus.accepteTout(101, 108);
                            sousCorpus.refuseTout(201, 224);
                            sousCorpus.accepte(211);
                            sousCorpus.refuseTout(301, 305);
                            sousCorpus.accepte(305);
                            sousCorpus.accepteTout(401, 406);
                            sousCorpus.accepteTout(901, 902);
                            if (bcToutCorpus.isSelected()) {
                                liens = rdb.getAllLiensSansCapture(sousCorpus);
                            } else {
                                SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yy");
                                try {
                                    Date d = sdf.parse(tcCorpusPartielDate.getText());
                                    if (bcCorpusPartiel.isSelected()) {
                                        liens = rdb.getAllLiensSansCaptureAPartirDe(d, sousCorpus);
                                    } else {
                                        liens = rdb.getAllLiensSansCaptureDu(d, sousCorpus);
                                    }
                                } catch (ParseException pe) {
                                }
                            }
                            lcCapture.setText("Captures effectuées : " + 0 + "/" + liens.length);
                            ljInfoCollecte.setText(lcEtat.getText() + " --- " +
                                    lcLemmatisation.getText() + " --- " +
                                    lcCapture.getText());
                            for (int i = 0; i < liens.length; i++) {
                                rdb.captureLien(liens[i].getId(), liens[i].getLink());
                                lcCapture.setText("Captures effectuées : " + i + "/" + liens.length);
                                ljInfoCollecte.setText(lcEtat.getText() + " --- " +
                                        lcLemmatisation.getText() + " --- " +
                                        lcCapture.getText());
                                if (!capturesEcranActivees) {
                                    break;
                                }
                            }
                            capturesEcranEnCours = false;
                            stoppeCapturesEcran();
                        }
                        bcCapture.setSelected(false);
                        lcCapture.setText("Captures d'écran terminées.");
                        ljInfoCollecte.setText(lcEtat.getText() + " --- " +
                                lcLemmatisation.getText() + " --- " +
                                lcCapture.getText());
                    } catch (NoBaseException nbe) {
                        lcCapture.setText("Base indisponible.");
                        capturesEcranEnCours = false;
                        ljInfoCollecte.setText(lcEtat.getText() + " --- " +
                                lcLemmatisation.getText() + " --- " +
                                lcCapture.getText());
                    }
                }
            }.start();
        }
    }

    private void stoppeCapturesEcran() {
        capturesEcranActivees = false;
    }

    private void initFenetreTemporelleAnalyseSynchronique() {
        laseDeroulement1.setText("");
        laseDeroulement2.setText("");
        laseDeroulement3.setText("");
        laseDeroulement4.setText("");
        laseDeroulement5.setText("");
        laseDeroulement6.setText("");
        laseNbSujets.setText("");
        lassNbSujets.setText("");
        lass2NbSujets.setText("");
        lass2NbSources.setText("");
        lass2Sources = new JList(new String[]{});
        spass2Sources.setViewportView(lass2Sources);
        lasuListe = new JList(new String[]{});
        spasuListe.setViewportView(lasuListe);
        DefaultMutableTreeNode racine = new DefaultMutableTreeNode("");
        tassListe.setModel(new DefaultTreeModel(racine));
        DefaultMutableTreeNode racine2 = new DefaultMutableTreeNode("");
        tass2Liste.setModel(new DefaultTreeModel(racine2));
    }

    private void fenetreTemporelleAnalyseSynchroniqueChangee() {
        new Thread() {

            @Override
            public void run() {
                laseDeroulement1.setText("");
                laseDeroulement2.setText("");
                laseDeroulement3.setText("");
                laseDeroulement4.setText("");
                laseDeroulement5.setText("");
                laseDeroulement6.setText("");
                baseLancer.setEnabled(false);
                try {
                    SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yy");
                    RSSFeedDatabase rfd = new RSSFeedDatabase(baseIPRI);
                    try {
                        laseNbSujets.setText("Recherche en cours");
                        lassNbSujets.setText("Recherche en cours");
                        lass2NbSujets.setText("Recherche en cours");
                        lass2NbSources.setText("Recherche en cours");
                        lass2Sources = new JList(new String[]{});
                        spass2Sources.setViewportView(lass2Sources);
                        lasuListe = new JList(new String[]{});
                        spasuListe.setViewportView(lasuListe);
                        DefaultMutableTreeNode racine = new DefaultMutableTreeNode("Sujets d'actualité");
                        tassListe.setModel(new DefaultTreeModel(racine));
                        DefaultMutableTreeNode racine2 = new DefaultMutableTreeNode("Sujets d'actualité");
                        tass2Liste.setModel(new DefaultTreeModel(racine2));
                        Date dateD = sdf.parse(taseDateDebut.getText());
                        Date dateF = sdf.parse(taseDateFin.getText());
                        laseDeroulement1.setText("Récupération en cours des sujets Google News dans la base.");
                        int nbSujets = rfd.getNbSujetsEntre(dateD, dateF);
                        SujetBrut[] sujets = rfd.getSujetsEntre(dateD, dateF);
                        laseDeroulement1.setText("Tri en cours des sujets Google News de la base.");
                        Arrays.sort(sujets, new ComparateurSujetsBruts());
                        laseNbSujets.setText(nbSujets + " sujets dont " +
                                sujets.length + " sujets uniques");
                        racine = new DefaultMutableTreeNode("Sujets d'actualité");
                        int nburls = 0;
                        for (int i = 0; i < sujets.length; i++) {
                            DefaultMutableTreeNode x = new DefaultMutableTreeNode(sujets[i].toString());
                            for (int j = 0; j < sujets[i].getArticles().length; j++) {
                                DefaultMutableTreeNode y = new DefaultMutableTreeNode(sujets[i].getArticles()[j].getLink());
                                x.add(y);
                                nburls++;
                            }
                            racine.add(x);
                        }
                        lassNbSujets.setText(sujets.length + " sujets, " + nburls + " urls");
                        tassListe.setModel(new DefaultTreeModel(racine));
                        laseDeroulement1.setText("Terminé : récupération des sujets Google News (" +
                                sujets.length + " sujets, " + nburls + " urls).");
                        laseDeroulement2.setText("Recherche des articles de la base correspondant à ceux des sujets.");
                        Vector<SujetTraite> sujets20 = new Vector<SujetTraite>();
                        for (int i = 0; i < sujets.length; i++) {
                            laseDeroulement2.setText("Recherche des articles de la base correspondant à ceux " +
                                    "des sujets (sujet " + (i + 1) + "/" + sujets.length + ").");
                            SujetTraite sujet21 = rfd.trouveArticlesDesSujets(sujets[i]);
                            sujets20.addElement(sujet21);
                        }
                        SujetTraite[] sujets2 = new SujetTraite[sujets20.size()];
                        sujets20.toArray(sujets2);
                        Arrays.sort(sujets2, new ComparateurSujetsTraites());
                        Set<String> sources = new HashSet<String>();
                        racine2 = new DefaultMutableTreeNode("Sujets d'actualité");
                        laseDeroulement2.setText("Enumération des sources ayant produit les articles trouvés.");
                        int nbarticles = 0;
                        for (int i = 0; i < sujets2.length; i++) {
                            DefaultMutableTreeNode x = new DefaultMutableTreeNode(sujets2[i].toString());
                            for (int j = 0; j < sujets2[i].getArticles().length; j++) {
                                DefaultMutableTreeNode y = new DefaultMutableTreeNode(sujets2[i].getArticles()[j]);
                                sources.add(sujets2[i].getArticles()[j].getNomFluxRSS());
                                x.add(y);
                                nbarticles++;
                            }
                            racine2.add(x);
                        }
                        lass2NbSujets.setText(sujets2.length + " sujets, " + nbarticles + " articles");
                        tass2Liste.setModel(new DefaultTreeModel(racine2));
                        String[] sources2 = new String[sources.size()];
                        sources.toArray(sources2);
                        Arrays.sort(sources2, new ComparateurString());
                        lass2NbSources.setText(sources2.length + " sources");
                        lass2Sources = new JList(sources2);
                        spass2Sources.setViewportView(lass2Sources);
                        laseDeroulement2.setText("Enumération des urls données par Google News qui ne sont pas dans la base.");
                        Set<String> urlsNonTrouvees = new HashSet<String>();
                        for (int i = 0; i < sujets.length; i++) {
                            for (int j = 0; j < sujets[i].getArticles().length; j++) {
                                urlsNonTrouvees.add(sujets[i].getArticles()[j].getLink());
                            }
                        }
                        for (int i = 0; i < sujets2.length; i++) {
                            for (int j = 0; j < sujets2[i].getArticles().length; j++) {
                                urlsNonTrouvees.remove(sujets2[i].getArticles()[j].getLink());
                            }
                        }
                        String[] urlsNonTrouvees2 = new String[urlsNonTrouvees.size()];
                        urlsNonTrouvees.toArray(urlsNonTrouvees2);
                        Arrays.sort(urlsNonTrouvees2, new ComparateurURLs());
                        lasuListe = new JList(urlsNonTrouvees2);
                        spasuListe.setViewportView(lasuListe);
                        laseDeroulement2.setText("Terminé : recherche des articles de la base correspondants (" +
                                nbarticles + " urls trouvées).");
                        laseDeroulement3.setText("Récupération des articles correspondant au sous-corpus choisi.");
                        SousCorpus sousCorpus = new SousCorpus();
                        Tag[] tags = panelFluxAnalyse.listeTagsAcceptes();
                        sousCorpus.refuseTout(1, 999);
                        for(int i=0; i<tags.length; i++){
                            sousCorpus.accepte(tags[i].getId());
                        }
                        // A la base : presse nationale française
                        /*sousCorpus.accepteTout(101, 108);
                        sousCorpus.refuse(103); // pas de blogs
                        sousCorpus.refuseTout(201, 224);
                        sousCorpus.accepte(211);
                        sousCorpus.refuseTout(301, 305);
                        sousCorpus.accepte(305);
                        sousCorpus.accepteTout(401, 406);
                        sousCorpus.accepteTout(901, 902);*/
                        RSSItem[] listeArticles = rfd.listeArticlesRSS(dateD, dateF, sousCorpus);
                        laseDeroulement3.setText("Versement dans la liste à trier.");
                        corpus = new CorpusAnalyse();
                        SacArticles aTrier = new SacArticles(CorpusAnalyse.NOM_SUJET_DIVERS);
                        corpus.addSujet(aTrier);
                        for (int i = 0; i < listeArticles.length; i++) {
                            RSSItem r = listeArticles[i];
                            String date = "";
                            SimpleDateFormat sdf2 = new SimpleDateFormat("dd/MM/yy HH:mm:ss");
                            date = sdf2.format(r.getPubDate());
                            Article a = new Article(r.getId().intValue(), r.getTitle(),
                                    r.getDescription(), r.getTitleLemmes().split(" "),
                                    r.getDescLemmes().split(" "), r.getLink(),
                                    rfd.getFeedName(r.getIdFluxRSS()), date, Article.INITIAL);
                            aTrier.addArticle(a);
                        }
                        laseDeroulement3.setText("Terminé : récupération des articles correspondant au sous-corpus choisi (" +
                                listeArticles.length + " articles).");
                        laseDeroulement4.setText("Classement des articles indexés par Google.");
                        int nbClasses = 0;
                        //int nbPotCommun = 0;
                        SacArticles[] sujetsGoogle = new SacArticles[sujets2.length];
                        for (int i = 0; i < sujets2.length; i++) {
                            sujetsGoogle[i] = new SacArticles(sujets2[i].getTitre());
                            corpus.addSujet(sujetsGoogle[i]);
                            for(int j=0; j<sujets2[i].getRessources().length; j++){
                                sujetsGoogle[i].addRessource(sujets2[i].getRessources()[j].getTitle());
                                sujetsGoogle[i].addRessource(sujets2[i].getRessources()[j].getDescription());
                            }
                            for (int j = 0; j < sujets2[i].getArticles().length; j++) {
                                RSSItem r = sujets2[i].getArticles()[j];
                                Article a = aTrier.getArticle(r.getId());
                                if (a != null) {
                                    sujetsGoogle[i].addArticle(a);
                                    aTrier.removeArticle(a);
                                    nbClasses++;
                                }
                            }
                        }
                        laseDeroulement4.setText("Terminé : classement des articles des sources indexées par Google (" +
                                nbClasses + " dans les sujets).");
                        laseDeroulement5.setText("Classement des articles des portails et agrégateurs.");
                        int nbPortAgr = 0;
                        SousCorpus portAgr = new SousCorpus();
                        portAgr.refuseTout(1, 999);
                        for(int i=0; i<tags.length; i++){
                            portAgr.accepte(tags[i].getId());
                        }
                        // Portails et agrégateurs uniquement
                        portAgr.refuseTout(101, 108);
                        portAgr.accepte(102);
                        portAgr.accepte(105);
                        RSSItem[] articlesPortAgr = rfd.listeArticlesRSS(dateD, dateF, portAgr);
                        for (int i = 0; i < articlesPortAgr.length; i++) {
                            String titreA = articlesPortAgr[i].getTitle();
                            for (int j = 0; j < sujetsGoogle.length; j++) {
                                boolean trouve = false;
                                for (int k = 0; k < sujetsGoogle[j].getArticles().length; k++) {
                                    String titreB = sujetsGoogle[j].getArticles()[k].getTitre();
                                    if (titreA.equalsIgnoreCase(titreB)) {
                                        Article a = aTrier.getArticle(articlesPortAgr[i].getId());
                                        if (a != null) {
                                            sujetsGoogle[j].addArticle(a);
                                            aTrier.removeArticle(a);
                                            trouve = true;
                                            nbPortAgr++;
                                            break;
                                        }
                                    }
                                    if (trouve) {
                                        break;
                                    }
                                }
                            }
                        }
                        laseDeroulement5.setText("Terminé : classement des articles des portails et agrégateurs (" +
                                nbPortAgr + " articles repérés).");
                        laseDeroulement6.setText("Terminé. Utilisez la recherche automatique " +
                                "dans l'onglet 'Classification' pour plus de résultats.");
                        classInitListeSujets();
                        classInitListeDestinations();
                    } catch (ParseException pe) {
                        laseNbSujets.setText("Dates invalides");
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                    baseLancer.setEnabled(true);
                } catch (NoBaseException nbe) {
                    laseNbSujets.setText("Base indisponible.");
                    baseLancer.setEnabled(true);
                }
            }
        }.start();
    }
    private CorpusAnalyse corpus = new CorpusAnalyse();
    private CorpusAnalyse backup = new CorpusAnalyse();

    private void classInitListeSujets() {
        
        //màj label avecle nombre d'articles
        jLabelNbArticlesDansLaClassification.setText(corpus.getNbArticles() + " articles en tout");

        SacArticles[] sacs = corpus.getSujets();
        lasmSujets2.setText("Sujets (" + sacs.length + ")");
        lasmArticlesRestants.setText("(des " +
                corpus.getSujet(CorpusAnalyse.NOM_SUJET_DIVERS).getArticles().length +
                " articles restants)");
        Arrays.sort(sacs, new ComparateurNbArticlesSacsArticles());
        lasmSujets = new JList(sacs);
        spasmSujets.setViewportView(lasmSujets);
        spasmSujets.setPreferredSize(new Dimension(200, 50));
        lasmSujets.addListSelectionListener(new ListSelectionListener() {

            public void valueChanged(ListSelectionEvent lse) {
                classSujetSelectionne();
            }
        });
        lasmSujets.setCellRenderer(new ListCellRenderer() {

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                SacArticles article = (SacArticles) value;
                JLabel res = new JLabel(article.toString());
                res.setOpaque(true);
                if (isSelected) {
                    res.setBackground(Charte.getSelectionBackground());
                } else {
                    res.setBackground(Charte.getBackground());
                }
                //res.setPreferredSize(new Dimension(200, 17));
                return res;
            }
        });
        lasmSujets.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
    }

    private void classInitListeDestinations() {
        SacArticles[] sacs = corpus.getSujets();
        lasmDestinations2.setText("Sujets (" + sacs.length + ")");
        lasmArticlesRestants.setText("(des " +
                corpus.getSujet(CorpusAnalyse.NOM_SUJET_DIVERS).getArticles().length +
                " articles restants)");
        Arrays.sort(sacs, new ComparateurTitresSacsArticles());
        lasmDestinations = new JList(sacs);
        spasmDestinations.setViewportView(lasmDestinations);
        spasmDestinations.setPreferredSize(new Dimension(200, 50));
        lasmDestinations.addListSelectionListener(new ListSelectionListener() {

            public void valueChanged(ListSelectionEvent lse) {
                classDestinationSelectionnee();
            }
        });
        lasmDestinations.setCellRenderer(new ListCellRenderer() {

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                SacArticles article = (SacArticles) value;
                JLabel res = new JLabel(article.toString());
                res.setOpaque(true);
                if (isSelected) {
                    res.setBackground(Charte.getSelectionBackground());
                } else {
                    res.setBackground(Charte.getBackground());
                }
                //res.setPreferredSize(new Dimension(200, 17));
                return res;
            }
        });
        lasmDestinations.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
    }

    private void classInitListeArticles() {
        SacArticles sac = (SacArticles) (lasmSujets.getSelectedValue());
        if (sac != null) {
            Article[] listeA = sac.getArticles();
            lasmArticles2.setText("Articles (" + listeA.length + ")");
            Arrays.sort(listeA, new ComparateurArticles());
            lasmArticles = new JList(listeA);
        } else {
            lasmArticles2.setText("Articles (0)");
            lasmArticles = new JList(new Article[]{});
        }
        spasmArticles.setViewportView(lasmArticles);
        lasmArticles.addListSelectionListener(new ListSelectionListener() {

            public void valueChanged(ListSelectionEvent lse) {
                classArticlesSelectionnes();
            }
        });
        lasmArticles.setCellRenderer(new ListCellRenderer() {

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Article article = (Article) value;
                JLabel res = new JLabel(article.toString());
                res.setOpaque(true);
                if (article.getStatut() == Article.INITIAL) {
                    res.setForeground(Color.ORANGE.darker());
                } else if (article.getStatut() == Article.SUGGERE) {
                    res.setForeground(Color.RED.darker());
                } else {
                    res.setForeground(Color.GREEN.darker());
                }
                if (isSelected) {
                    res.setBackground(Charte.getSelectionBackground());
                } else {
                    res.setBackground(Charte.getBackground());
                }
                return res;
            }
        });
        lasmArticles.setSelectionMode(ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
    }

    private void classSujetSelectionne() {
        classInitListeArticles();
    }

    private void classDestinationSelectionnee() {
    }

    private void classArticlesSelectionnes() {
    }

    private void classRetrier() {
        SacArticles sacDepart = (SacArticles) lasmSujets.getSelectedValue();
        SacArticles sacArrivee = (SacArticles) lasmDestinations.getSelectedValue();
        classInitListeSujets();
        classInitListeDestinations();
        lasmSujets.setSelectedValue(sacDepart, true);
        lasmDestinations.setSelectedValue(sacArrivee, true);
    }

    private void classArticlesValides() {
        backup = corpus.getBackup();
        Object[] o = lasmArticles.getSelectedValues();
        for (int i = 0; i < o.length; i++) {
            Article a = (Article) (o[i]);
            a.setStatut(Article.VALIDE);
        }
        lasmArticles.repaint();
        lasmSujets.repaint();
        lasmDestinations.repaint();
    }

    private void classArticlesInvalides() {
        backup = corpus.getBackup();
        Object[] o = lasmArticles.getSelectedValues();
        SacArticles sacDepart = (SacArticles) lasmSujets.getSelectedValue();
        SacArticles potCommun = corpus.getSujet(CorpusAnalyse.NOM_SUJET_DIVERS);
        for (int i = 0; i < o.length; i++) {
            Article a = (Article) (o[i]);
            a.setStatut(Article.VALIDE);
            sacDepart.removeArticle(a);
            potCommun.addArticle(a);
        }
        SacArticles sacArrivee = (SacArticles) lasmDestinations.getSelectedValue();
        lasmArticles.repaint();
        classInitListeSujets();
        classInitListeDestinations();
        lasmSujets.setSelectedValue(sacDepart, true);
        lasmDestinations.setSelectedValue(sacArrivee, true);
        classInitListeArticles();
    }

    private void classArticlesTransferes() {
        backup = corpus.getBackup();
        Object[] o = lasmArticles.getSelectedValues();
        SacArticles sacDepart = (SacArticles) lasmSujets.getSelectedValue();
        SacArticles sacArrivee = (SacArticles) lasmDestinations.getSelectedValue();
        for (int i = 0; i < o.length; i++) {
            Article a = (Article) (o[i]);
            a.setStatut(Article.VALIDE);
            sacDepart.removeArticle(a);
            sacArrivee.addArticle(a);
        }
        classInitListeSujets();
        classInitListeDestinations();
        lasmSujets.setSelectedValue(sacDepart, true);
        lasmDestinations.setSelectedValue(sacArrivee, true);
        classInitListeArticles();
    }

    private void classSujetsFusionnes() {
        backup = corpus.getBackup();
        SacArticles sac1 = (SacArticles) lasmSujets.getSelectedValue();
        SacArticles sac2 = (SacArticles) lasmDestinations.getSelectedValue();
        corpus.fusionneSujets(new SacArticles[]{sac1, sac2});
        classInitListeSujets();
        classInitListeDestinations();
        lasmSujets.setSelectedValue(sac1, true);
    }

    private void classNouveauSujet() {
        backup = corpus.getBackup();
        SacArticles sac1 = (SacArticles) lasmSujets.getSelectedValue();
        SacArticles sac2 = (SacArticles) lasmDestinations.getSelectedValue();
        String nom = JOptionPane.showInputDialog("Nom : ");
        if (nom != null) {
            if (!nom.equals("") && !nom.equals(CorpusAnalyse.NOM_SUJET_DIVERS)) {
                SacArticles nouveauSac = new SacArticles(nom);
                corpus.addSujet(nouveauSac);
            }
        }
        classInitListeSujets();
        classInitListeDestinations();
        lasmSujets.setSelectedValue(sac1, true);
        lasmDestinations.setSelectedValue(sac2, true);
    }

    private void classRenommerSujet() {
        backup = corpus.getBackup();
        String nom = JOptionPane.showInputDialog("Nom : ");
        SacArticles sac = (SacArticles) (lasmSujets.getSelectedValue());
        SacArticles sac2 = (SacArticles) (lasmDestinations.getSelectedValue());
        sac.setTitre(nom);
        classInitListeSujets();
        classInitListeDestinations();
        lasmSujets.setSelectedValue(nom, true);
        lasmDestinations.setSelectedValue(sac2, true);
    }

    private void classSupprimerSujet() {
        backup = corpus.getBackup();
        SacArticles sac = (SacArticles) lasmSujets.getSelectedValue();
        if (!(sac.getTitre().equals(CorpusAnalyse.NOM_SUJET_DIVERS))) {
            SacArticles aTrier = corpus.getSujet(CorpusAnalyse.NOM_SUJET_DIVERS);
            aTrier.addAll(sac);
            corpus.removeSujet(sac);
            classInitListeSujets();
            classInitListeDestinations();
        }
    }

    private void classAnnulation() {
        // inversion des deux corpus
        CorpusAnalyse c = corpus.getBackup();
        corpus = backup;
        backup = c;
        classInitListeSujets();
        classInitListeDestinations();
        classInitListeArticles();
    }

    private void classRechercherEt() {
        String[] termes = tasmRechercher.getText().trim().split("\\s");
        SacArticles sac = (SacArticles) (lasmSujets.getSelectedValue());
        Article[] listeA = sac.getArticles();
        Arrays.sort(listeA, new ComparateurArticles());
        Vector<Integer> indices = new Vector<Integer>();
        for (int i = 0; i < listeA.length; i++) {
            boolean bon = true;
            for (int j = 0; j < termes.length; j++) {
                if (!(listeA[i].getTitre().contains(termes[j])) &&
                        !(listeA[i].getDescription().contains(termes[j]))) {
                    bon = false;
                    break;
                }
            }
            if (bon) {
                indices.addElement(new Integer(i));
            }
        }
        int[] indices0 = new int[indices.size()];
        for (int i = 0; i < indices.size(); i++) {
            indices0[i] = indices.elementAt(i).intValue();
        }
        lasmArticles.setSelectedIndices(indices0);
    }

    private void classRechercherOu() {
        String[] termes = tasmRechercher.getText().trim().split("\\s");
        SacArticles sac = (SacArticles) (lasmSujets.getSelectedValue());
        Article[] listeA = sac.getArticles();
        Arrays.sort(listeA, new ComparateurArticles());
        Vector<Integer> indices = new Vector<Integer>();
        for (int i = 0; i < listeA.length; i++) {
            boolean bon = false;
            for (int j = 0; j < termes.length; j++) {
                if ((listeA[i].getTitre().contains(termes[j])) ||
                        (listeA[i].getDescription().contains(termes[j]))) {
                    bon = true;
                    break;
                }
            }
            if (bon) {
                indices.addElement(new Integer(i));
            }
        }
        int[] indices0 = new int[indices.size()];
        for (int i = 0; i < indices.size(); i++) {
            indices0[i] = indices.elementAt(i).intValue();
        }
        lasmArticles.setSelectedIndices(indices0);
    }

    private void classRechercherAuto() {
        backup = corpus.getBackup();
        new Thread() {

            public void run() {
                basmClassAuto.setEnabled(false);
                basmClusterAuto.setEnabled(false);
                int nbArticlesSupplementairesTrouves = 0;
                SacArticles aTrier = corpus.getSujet(CorpusAnalyse.NOM_SUJET_DIVERS);
                SacArticles[] liste = corpus.getSujets();
                Arrays.sort(liste, new ComparateurNbArticlesSacsArticles2());
                for (int i = 0; i < liste.length; i++) {
                    SacArticles sujet = liste[i];
                    if (!(sujet.getTitre().equals(CorpusAnalyse.NOM_SUJET_DIVERS))) {
                        String[] ressources = sujet.recycleEnRessources();
                        for (int j = 0; j < aTrier.getArticles().length; j++) {
                            Article test = aTrier.getArticles()[j];
                            lasmAutoStatut.setText("Sujet " +
                                    (i + 1) + ", article " + (j + 1));
                            // tactique des n-grammes (la plus simple)
                            int N = Integer.parseInt(tasmAutoPrecision.getText());
                            boolean trouve = false;
                            String raison = "";
                            for (int k = 0; k < ressources.length; k++) {
                                String s1 = ressources[k].trim();
                                int l = s1.length();
                                String s2 = test.getTitre().trim();
                                String s3 = test.getDescription().trim();
                                if (l < N) {
                                    /*if (s2.contains(s1)) {
                                        trouve = true;
                                        raison = "en commun (titre) : "+s1;
                                        break;
                                    }
                                    if (s3.contains(s1)) {
                                        trouve = true;
                                        raison = "en commun (desc) : "+s1;
                                        break;
                                    }*/
                                } else {
                                    for (int x = 0; x < s1.length() - N; x++) {
                                        String cmp = s1.substring(x, x + N);
                                        if (s2.contains(cmp)) {
                                            trouve = true;
                                            raison = "en commun (titre) : "+cmp;
                                            break;
                                        }
                                        if (s3.contains(cmp)) {
                                            trouve = true;
                                            raison = "en commun (desc) : "+cmp;
                                            break;
                                        }
                                    }
                                    if (trouve) {
                                        break;
                                    }
                                }
                            }
                            if (trouve) {
                                Out.printInfo("Classement : article '"+test.getTitre()+
                                        "' rangé dans le sujet '"+liste[i].getTitre()+
                                        "' ("+raison+")");
                                test.setStatut(Article.SUGGERE);
                                liste[i].addArticle(test);
                                aTrier.removeArticle(test);
                                j--;
                                nbArticlesSupplementairesTrouves++;
                            }
                        }
                    }
                }
                lasmAutoStatut.setText(nbArticlesSupplementairesTrouves + " articles trouvés.");
                classRetrier();
                basmClassAuto.setEnabled(true);
                basmClusterAuto.setEnabled(true);
            }
        }.start();
    }

    private void classClusteringAuto(){
        backup = corpus.getBackup();
        new Thread() {

            public void run() {
                basmClassAuto.setEnabled(false);
                basmClusterAuto.setEnabled(false);
                int nbArticlesSupplementairesTrouves = 0;
                SacArticles aTrier = corpus.getSujet(CorpusAnalyse.NOM_SUJET_DIVERS);
                Vector<SacArticles> nouveauxSujets = new Vector<SacArticles>();
                Article[] articles = aTrier.getArticles();
                int total = (articles.length * (articles.length - 1)) / 2;
                int qt = 0;
                for (int i = 0; i < articles.length; i++) {
                    for (int j = i+1; j < articles.length; j++) {
                        qt++;
                        lasmAutoStatut.setText("article " +
                                (i + 1) + " ("+(qt*100/total)+"%)");
                        Article test = articles[i];
                        Article test2 = articles[j];
                        boolean trouve = false;
                        for (int k = 0; k < nouveauxSujets.size(); k++) {
                            if (nouveauxSujets.elementAt(k).contientArticle(test) &&
                                nouveauxSujets.elementAt(k).contientArticle(test2)) {
                                trouve = true;
                            }
                        }
                        if(trouve){
                            break;
                        }
                        // tactique des n-grammes (la plus simple)
                        int N = Integer.parseInt(tasmAutoPrecision2.getText());
                        String raison = "";
                        if(!trouve && test.getTitre().length()>N && test2.getTitre().length()>N){
                            for(int k=0; k<test.getTitre().length()-N; k++){
                                String cmp = test.getTitre().substring(k, k + N);
                                if(test2.getTitre().contains(cmp)){
                                    trouve = true;
                                    raison = "en commun : " + cmp;
                                }
                            }
                        }
                        if (!trouve && test.getTitre().length() > N && test2.getDescription().length() > N) {
                            for (int k = 0; k < test.getTitre().length() - N; k++) {
                                String cmp = test.getTitre().substring(k, k + N);
                                if (test2.getDescription().contains(cmp)) {
                                    trouve = true;
                                    raison = "en commun : " + cmp;
                                }
                            }
                        }
                        if (!trouve && test.getDescription().length() > N && test2.getTitre().length() > N) {
                            for (int k = 0; k < test.getDescription().length() - N; k++) {
                                String cmp = test.getDescription().substring(k, k + N);
                                if (test2.getTitre().contains(cmp)) {
                                    trouve = true;
                                    raison = "en commun : " + cmp;
                                }
                            }
                        }
                        if (!trouve && test.getDescription().length() > N && test2.getDescription().length() > N) {
                            for (int k = 0; k < test.getDescription().length() - N; k++) {
                                String cmp = test.getDescription().substring(k, k + N);
                                if (test2.getDescription().contains(cmp)) {
                                    trouve = true;
                                    raison = "en commun : " + cmp;
                                }
                            }
                        }
                        if(trouve){
                            /*Out.printInfo("Clustering : article '" + test.getTitre() +
                                    "' avec l'article '" + test2.getTitre() +
                                    "' (" + raison + ")");*/
                            test.setStatut(Article.SUGGERE);
                            test2.setStatut(Article.SUGGERE);
                            SacArticles sujet = null;
                            SacArticles sujet2 = null;
                            for(int k=0; k<nouveauxSujets.size(); k++){
                                if(nouveauxSujets.elementAt(k).contientArticle(test)){
                                    sujet = nouveauxSujets.elementAt(k);
                                }
                                if(nouveauxSujets.elementAt(k).contientArticle(test2)){
                                    sujet2 = nouveauxSujets.elementAt(k);
                                }
                            }
                            if(sujet == null && sujet2 == null){
                                sujet = new SacArticles(test.getTitre());
                                sujet.addArticle(test);
                                sujet.addArticle(test2);
                                aTrier.removeArticle(test);
                                aTrier.removeArticle(test2);
                                nouveauxSujets.add(sujet);
                                corpus.addSujet(sujet);
                                Out.printInfo("Clustering - nouveau sujet ("+nouveauxSujets.size()+"ème) : "+
                                        sujet.getTitre());
                            } else if(sujet == null && sujet2 != null){
                                sujet2.addArticle(test);
                                aTrier.removeArticle(test);
                                Out.printInfo("Clustering - nouvel article dans le sujet "+
                                        sujet2.getTitre()+" ("+test.getTitre()+")");
                            } else if(sujet != null && sujet2 == null){
                                sujet.addArticle(test2);
                                aTrier.removeArticle(test2);
                                Out.printInfo("Clustering - nouvel article dans le sujet "+
                                        sujet.getTitre()+" ("+test2.getTitre()+")");
                            } else if(sujet != null && sujet2 != null){
                                Out.printInfo("Clustering - fusion de sujets ("+
                                        sujet.getTitre()+")");
                                sujet.addAll(sujet2);
                                nouveauxSujets.remove(sujet2);
                                corpus.removeSujet(sujet2);
                            }
                            nbArticlesSupplementairesTrouves++;
                        }
                    }
                }
                lasmAutoStatut.setText(nbArticlesSupplementairesTrouves + " articles trouvés.");
                classRetrier();
                basmClassAuto.setEnabled(true);
                basmClusterAuto.setEnabled(true);
            }
        }.start();
    }

    private void classSelectAll() {
        SacArticles sac = (SacArticles) (lasmSujets.getSelectedValue());
        Article[] listeA = sac.getArticles();
        lasmArticles.getSelectionModel().setSelectionInterval(0, listeA.length - 1);
    }

    private void classDeselectAll() {
        lasmArticles.getSelectionModel().clearSelection();
    }

    private void classExportExcel() {
        JFileChooser jfc = new JFileChooser();
        int choix = jfc.showSaveDialog(this);
        if (choix == JFileChooser.APPROVE_OPTION) {
            basmExportExcel.setEnabled(false);
            try {
                File f = jfc.getSelectedFile();
                FileWriter w = new FileWriter(f);
                w.write("no sujet\ttitre sujet\ttitre article\tdescription article\tdate publication\tsource\tlien");
                w.flush();
                int n = 1;
                String separateur="\t";
                for (int i = 0; i < corpus.getSujets().length; i++) {
                    int noSujet = i;
                    String nomSujet = corpus.getSujets()[i].getTitre().replaceAll("\\\t", " ").replaceAll("\\\"", " ").replaceAll("\\\n", " ");
                    //debug
                    //Out.printInfo("Export Excel du sujet n°"+noSujet+" ("+nomSujet+") : "+corpus.getSujets()[i].getArticles().length+" articles");
                    for (int j = 0; j < corpus.getSujets()[i].getArticles().length; j++) {
                        String nomArticle = corpus.getSujets()[i].getArticles()[j].getTitre().replaceAll("\\\t", " ").replaceAll("\\\"", " ").replaceAll("\\\n", " ");
                        String descArticle = corpus.getSujets()[i].getArticles()[j].getDescription().replaceAll("\\\t", " ").replaceAll("\\\"", " ").replaceAll("\\\n", " ");
                        descArticle = descArticle.substring(0, Math.min(10000, Math.max(0, descArticle.length()-1)));
                        String dateArticle = corpus.getSujets()[i].getArticles()[j].getDatePubli().replaceAll("\\\t", " ").replaceAll("\\\"", " ").replaceAll("\\\n", " ");
                        String sourceArticle = corpus.getSujets()[i].getArticles()[j].getSource().replaceAll("\\\t", " ").replaceAll("\\\"", " ").replaceAll("\\\n", " ");
                        String lienArticle = corpus.getSujets()[i].getArticles()[j].getUrl().replaceAll("\\\t", " ").replaceAll("\\\"", " ").replaceAll("\\\n", " ");
                        w.write("\r\n");
                        String s = noSujet + separateur + nomSujet + separateur + nomArticle +
                                separateur + descArticle + separateur + dateArticle +
                                separateur + sourceArticle + separateur + lienArticle;
                        w.write(s);
                        /*
                         //debug
                        java.util.regex.Pattern p = java.util.regex.Pattern.compile("\\\t");
                        java.util.regex.Matcher m = p.matcher(s);
                        int nn = 0;
                        while(m.find()){
                            nn++;
                        }
                        if(nn>6){
                            Out.printErreur("["+nn+"] "+s);
                        }
                         
                         */
                        n++;
                        w.flush();
                    }
                }
                w.close();
                lasmStatutSave.setText("Export Excel terminé (" + n + " lignes)");
            } catch (IOException ioe) {
                lasmStatutSave.setText("Echec de l'export Excel");
            }
            basmExportExcel.setEnabled(true);
        }
    }

    private void classExportLexico() {
        JFileChooser jfc = new JFileChooser();
        int choix = jfc.showSaveDialog(this);
        if (choix == JFileChooser.APPROVE_OPTION) {
            basmExportExcel.setEnabled(false);
            try {
                File f = jfc.getSelectedFile();
                FileWriter w = new FileWriter(f);
                for (int i = 0; i < corpus.getSujets().length; i++) {
                    for (int j = 0; j < corpus.getSujets()[i].getArticles().length; j++) {
                        String titreArticle = corpus.getSujets()[i].getArticles()[j].getTitre();
                        String descArticle = corpus.getSujets()[i].getArticles()[j].getDescription();
                        String sourceArticle = corpus.getSujets()[i].getArticles()[j].getSource();
                        w.write("<source=" + sourceArticle + ">\r\n" + titreArticle + "\r\n" + descArticle + "\r\n");
                        w.flush();
                    }
                }
                w.close();
                lasmStatutSave.setText("Export Lexico terminé");
            } catch (IOException ioe) {
                lasmStatutSave.setText("Echec de l'export Lexico");
            }
            basmExportExcel.setEnabled(true);
        }
    }

    private void classSave() {
        final JFileChooser jfc = new JFileChooser();
        int choix = jfc.showSaveDialog(this);
        if (choix == JFileChooser.APPROVE_OPTION) {
            lasmStatutSave.setText("Sauvegarde...");
            final CorpusAnalyse c = corpus.getBackup();
            new Thread() {

                public void run() {
                    basmSauvegarder.setEnabled(false);
                    try {
                        //lasmStatutSave.setText("Préparation (2/3).");
                        File f = jfc.getSelectedFile();
                        FileWriter w = new FileWriter(f);
                        c.sauvegarde(w);
                        //String s0 = c.getSauvegarde();
                        //lasmStatutSave.setText("Préparation (3/3).");
                        /*String[] s = s0.split("\\\n");
                        for(int i=0; i<s.length; i++){
                        //lasmStatutSave.setText("Sauvegarde : "+(100*i/s.length)+"%");
                        w.write(s[i]+"\n");
                        w.flush();
                        }*/
                        w.close();
                        lasmStatutSave.setText("Sauvegarde terminée.");
                    } catch (IOException ioe) {
                        lasmStatutSave.setText("Echec de la sauvegarde.");
                    }
                    basmSauvegarder.setEnabled(true);
                }
            }.start();
        }
    }

    private void classLoad() {
        final JFileChooser jfc = new JFileChooser();
        int choix = jfc.showOpenDialog(this);
        if (choix == JFileChooser.APPROVE_OPTION) {
            new Thread() {

                public void run() {
                    laseDeroulement1.setText("Chargement en cours.");
                    baseCharger.setEnabled(false);
                    try {
                        File f = jfc.getSelectedFile();
                        Reader r = new FileReader(f);
                        char[] cc = new char[(int) (f.length())];
                        r.read(cc);
                        r.close();
                        String s = new String(cc);
                        corpus = CorpusAnalyse.charge(s);
                        classInitListeSujets();
                        classInitListeDestinations();
                        classInitListeArticles();
                        laseDeroulement1.setText("Chargement terminé. Voyez l'onglet Classification pour continuer.");
                    } catch (IOException ioe) {
                        Out.printErreur("Chargement de ce fichier impossible.");
                    }
                    baseCharger.setEnabled(true);
                }
            }.start();
        }
    }

    private void genererStatistiques() {
        new Thread() {

            public void run() {
                RSSFeedDatabase rfd;
                try {
                    rfd = new RSSFeedDatabase(baseIPRI);
                } catch (NoBaseException nbe) {
                    rfd = null;
                }
                lasdGenerer.setText("Calcul en cours.");
                SacArticles[] sujets = corpus.getSujets();
                lasdgvSujets.setText("Nombre de sujets : " + sujets.length);
                int nbArticles = 0;
                String[] lSujets = new String[sujets.length];
                for (int i = 0; i < sujets.length; i++) {
                    nbArticles += sujets[i].getArticles().length;
                }
                for (int i = 0; i < sujets.length; i++) {
                    lSujets[i] = "[" + sujets[i].getArticles().length +
                            " articles soit " +
                            ((int) (Math.round(100.0 *
                            sujets[i].getArticles().length / nbArticles))) +
                            "%] " + sujets[i].getTitre();
                }
                lasdgvArticles.setText("Nombre d'articles : " + nbArticles);
                Arrays.sort(lSujets, new ComparateurNbArticlesDistribution());
                lasdgDistributionS = new JList(lSujets);
                spasdgDistributionS.setViewportView(lasdgDistributionS);
                Set<String> sources = new HashSet<String>();

                for (int i = 0; i < sujets.length; i++) {
                    Article[] a = sujets[i].getArticles();
                    for (int j = 0; j < a.length; j++) {
                        sources.add(a[j].getSource());
                    }
                }
                String[] lSources = new String[sources.size()];
                sources.toArray(lSources);
                Arrays.sort(lSources);

                Map<String, Integer> sSources = new HashMap<String, Integer>();
                Map<String, Integer> sCategories = new HashMap<String, Integer>();
                Map<String, Integer> sExclus = new HashMap<String, Integer>();
                Map<String, Integer> sPrimeurs = new HashMap<String, Integer>();
                
                for (int i = 0; i < sujets.length; i++) {
                    String source1 = "";
                    for (int j = 0; j < sujets[i].getArticles().length; j++) {
                        String source = sujets[i].getArticles()[j].getSource();
                        Integer nb = sSources.get(source);
                        if (nb == null) {
                            sSources.put(source, new Integer(1));
                        } else {
                            sSources.put(source, new Integer(nb.intValue() + 1));
                        }
                        nb = sExclus.get(source);
                        if (nb == null) {
                            sExclus.put(source, new Integer(0));
                        }
                        nb = sPrimeurs.get(source);
                        if (nb == null) {
                            sPrimeurs.put(source, new Integer(0));
                        }
                        if(source1.equals("")){
                            source1 = source;
                        } else if(!(source1.equals(source))){
                            source1 = "~~~~~Plusieurs flux~~~~~";
                        }
                        String nomCategorie = "?";
                        try {
                            Tag[] categories = rfd.getTagsOfFeed(rfd.findFeedId(source),
                                    RSSFeedDatabase.TAGS_CATEGORIE);
                            if (categories.length > 0) {
                                nomCategorie = categories[0].getTag();
                                nb = sCategories.get(nomCategorie);
                                if (nb == null) {
                                    sCategories.put(nomCategorie, new Integer(1));
                                } else {
                                    sCategories.put(nomCategorie, new Integer(nb.intValue() + 1));
                                }
                            }
                        } catch (NullPointerException npe) { // pas de base => rfd null
                            sCategories.put("Base indisponible", new Integer(0));
                        } catch (NoBaseException nbe) {
                            sCategories.put("Base indisponible", new Integer(0));
                        }
                    }
                    if(!source1.equals("") && !source1.equals("~~~~~Plusieurs flux~~~~~")){
                        Integer nb = sExclus.get(source1);
                        if (nb == null) {
                            sExclus.put(source1, new Integer(1));
                        } else {
                            sExclus.put(source1, new Integer(nb.intValue() + 1));
                        }
                    }
                    Article[] listeArticles = sujets[i].getArticles();
                    Arrays.sort(listeArticles, new ComparateurArticlesDate());
                    if(listeArticles.length>1){
                        String source0 = listeArticles[0].getSource();
                        if(!source1.equals(source0) && // premier parmi d'autres = non exclusivité
                           !(listeArticles[0].getDatePubli().equals(listeArticles[1].getDatePubli()))){
                            Integer nb = sPrimeurs.get(source0);
                            if (nb == null) {
                                sPrimeurs.put(source0, new Integer(1));
                            } else {
                                sPrimeurs.put(source0, new Integer(nb.intValue() + 1));
                            }
                        }
                    }
                }

                Vector<String> vSources = new Vector<String>(sSources.keySet());
                String[] lSources2 = new String[vSources.size()];
                vSources.toArray(lSources2);
                for (int i = 0; i < lSources2.length; i++) {
                    int nb = sSources.get(lSources2[i]).intValue();
                    lSources2[i] = "[" + nb + " articles soit " + ((int) (Math.round(100.0 * nb / nbArticles))) + "%] " + lSources2[i];
                }
                Arrays.sort(lSources2, new ComparateurNbArticlesDistribution());
                Vector<String> vCategories = new Vector<String>(sCategories.keySet());
                String[] lCategories = new String[vCategories.size()];
                vCategories.toArray(lCategories);
                for (int i = 0; i < lCategories.length; i++) {
                    int nb = sCategories.get(lCategories[i]).intValue();
                    lCategories[i] = "[" + nb + " articles soit " + ((int) (Math.round(100.0 * nb / nbArticles))) + "%] " + lCategories[i];
                }
                Arrays.sort(lCategories, new ComparateurNbArticlesDistribution());
                Vector<String> vExclus = new Vector<String>(sExclus.keySet());
                String[] lExclus = new String[vExclus.size()];
                vExclus.toArray(lExclus);
                for (int i = 0; i < lExclus.length; i++) {
                    int nb = sExclus.get(lExclus[i]).intValue();
                    lExclus[i] = "[" + nb + " sujet"+(nb>1?"s":"")+"] " + lExclus[i];
                }
                Arrays.sort(lExclus, new ComparateurNbArticlesDistribution());
                Vector<String> vPrimeurs = new Vector<String>(sPrimeurs.keySet());
                String[] lPrimeurs = new String[vPrimeurs.size()];
                vPrimeurs.toArray(lPrimeurs);
                for (int i = 0; i < lPrimeurs.length; i++) {
                    int nb = sPrimeurs.get(lPrimeurs[i]).intValue();
                    lPrimeurs[i] = "[" + nb + " sujet"+(nb>1?"s":"")+"] " + lPrimeurs[i];
                }
                Arrays.sort(lPrimeurs, new ComparateurNbArticlesDistribution());
                lasdgvSources.setText("Nombre de flux produisants : " + sSources.size());
                lasdgvCategories.setText("Nombre de catégories produisantes : " + sCategories.size());
                lasdgDistributionO = new JList(lSources2);
                spasdgDistributionO.setViewportView(lasdgDistributionO);
                lasdgDistributionC = new JList(lCategories);
                spasdgDistributionC.setViewportView(lasdgDistributionC);
                lasdgDistributionE = new JList(lExclus);
                spasdgDistributionE.setViewportView(lasdgDistributionE);
                lasdgDistributionP = new JList(lPrimeurs);
                spasdgDistributionP.setViewportView(lasdgDistributionP);

                Arrays.sort(sujets, new ComparateurNbArticlesSacsArticles());
                lasdListeSujets = new JList(sujets);
                lasdListeSujets.addListSelectionListener(new ListSelectionListener() {

                    public void valueChanged(ListSelectionEvent e) {
                        genererDonneesDiachronieSujets();
                    }
                });
                lasdListeSujets.setSelectedIndex(0);
                spasdListeSujets.setViewportView(lasdListeSujets);
                
                lasdoListeSources = new JList(lSources);
                lasdoListeSources.addListSelectionListener(new ListSelectionListener() {

                    public void valueChanged(ListSelectionEvent e) {
                        genererDonneesDiachronieFlux();
                    }
                });
                lasdoListeSources.setSelectedIndex(0);
                spasdoListeSources.setViewportView(lasdoListeSources);
                lasdGenerer.setText("Calcul terminé.");
            }
        }.start();
    }

    private void genererDonneesDiachronieSujets() {
        RSSFeedDatabase rfd;
        try {
            rfd = new RSSFeedDatabase(baseIPRI);
        } catch (NoBaseException nbe) {
            rfd = null;
        }
        SacArticles sujet = (SacArticles) (lasdListeSujets.getSelectedValue());
        if (sujet != null) {
            Article[] articles = sujet.getArticles();
            lasdsvArticles.setText("Nombre d'articles : " + articles.length);
            Arrays.sort(articles, new ComparateurArticlesDate());
            String[] crArticles = new String[articles.length];
            Map<String, Integer> sSources = new HashMap<String, Integer>();
            Map<String, Integer> sCategories = new HashMap<String, Integer>();
            for (int i = 0; i < articles.length; i++) {
                Integer nb = sSources.get(articles[i].getSource());
                if (nb == null) {
                    sSources.put(articles[i].getSource(), new Integer(1));
                } else {
                    sSources.put(articles[i].getSource(), new Integer(nb.intValue() + 1));
                }
                String nomCategorie = "?";
                try {
                    Tag[] categories = rfd.getTagsOfFeed(rfd.findFeedId(
                            articles[i].getSource()), RSSFeedDatabase.TAGS_CATEGORIE);
                    if (categories.length > 0) {
                        nomCategorie = categories[0].getTag();
                        nb = sCategories.get(nomCategorie);
                        if (nb == null) {
                            sCategories.put(nomCategorie, new Integer(1));
                        } else {
                            sCategories.put(nomCategorie, new Integer(nb.intValue() + 1));
                        }
                    }
                } catch (NullPointerException npe) { // pas de base => rfd null
                    sCategories.put("Base indisponible", new Integer(0));
                } catch (NoBaseException nbe) {
                    sCategories.put("Base indisponible", new Integer(0));
                }
                crArticles[i] = "[" + articles[i].getDatePubli() + "] " + articles[i].getSource() +
                        " (" + nomCategorie + ") : \"" + articles[i].getTitre() + "\"";
            }
            Vector<String> vSources = new Vector<String>(sSources.keySet());
            String[] lSources = new String[vSources.size()];
            vSources.toArray(lSources);
            for (int i = 0; i < lSources.length; i++) {
                int nb = sSources.get(lSources[i]).intValue();
                lSources[i] = "[" + nb + " articles soit " + ((int) (Math.round(100.0 * nb / articles.length))) + "%] " + lSources[i];
            }
            Arrays.sort(lSources, new ComparateurNbArticlesDistribution());
            Vector<String> vCategories = new Vector<String>(sCategories.keySet());
            String[] lCategories = new String[vCategories.size()];
            vCategories.toArray(lCategories);
            for (int i = 0; i < lCategories.length; i++) {
                int nb = sCategories.get(lCategories[i]).intValue();
                lCategories[i] = "[" + nb + " articles soit " + ((int) (Math.round(100.0 * nb / articles.length))) + "%] " + lCategories[i];
            }
            Arrays.sort(lCategories, new ComparateurNbArticlesDistribution());
            lasdsvSources.setText("Nombre de flux : " + sSources.size());
            lasdsvCategories.setText("Nombre de catégories : " + sCategories.size());
            lasdsDiachronie = new JList(crArticles);
            spasdsDiachronie.setViewportView(lasdsDiachronie);
            lasdsDistributionS = new JList(lSources);
            spasdsDistributionS.setViewportView(lasdsDistributionS);
            lasdsDistributionC = new JList(lCategories);
            spasdsDistributionC.setViewportView(lasdsDistributionC);
        }
    }

    private void genererDonneesDiachronieFlux() {
        String source = (String) (lasdoListeSources.getSelectedValue());
        if (source != null) {
            Set<Article> prod = new HashSet<Article>();
            Map<SacArticles, Integer> sujets = new HashMap<SacArticles, Integer>();
            for (int i = 0; i < corpus.getSujets().length; i++) {
                Article[] articles = corpus.getSujets()[i].getArticles();
                for (int j = 0; j < articles.length; j++) {
                    if (articles[j].getSource().equals(source)) {
                        prod.add(articles[j]);
                        Integer nb = sujets.get(corpus.getSujets()[i]);
                        if (nb != null) {
                            sujets.put(corpus.getSujets()[i],
                                    new Integer(nb.intValue() + 1));
                        } else {
                            sujets.put(corpus.getSujets()[i], new Integer(1));
                        }
                    }
                }
            }
            Article[] lProd = new Article[prod.size()];
            prod.toArray(lProd);
            Arrays.sort(lProd, new ComparateurArticlesDate());
            SacArticles[] lSujets = new SacArticles[sujets.keySet().size()];
            sujets.keySet().toArray(lSujets);
            String[] crSujets = new String[lSujets.length];
            Vector<SacArticles> exclusivites = new Vector<SacArticles>();
            for (int i = 0; i < lSujets.length; i++) {
                int nbArticles = sujets.get(lSujets[i]).intValue();
                crSujets[i] = "[" + nbArticles + " articles soit " +
                        ((int) (Math.round(100.0 * nbArticles / lProd.length))) + "%] " +
                        lSujets[i].getTitre();
                if (lSujets[i].getArticles().length == nbArticles) {
                    exclusivites.add(lSujets[i]);
                }
            }
            Arrays.sort(crSujets, new ComparateurNbArticlesDistribution());
            SacArticles[] lExclusivites = new SacArticles[exclusivites.size()];
            exclusivites.toArray(lExclusivites);
            Arrays.sort(lExclusivites, new ComparateurTitresSacsArticles());

            Vector<SacArticles> primeurs = new Vector<SacArticles>();
            for (int i = 0; i < lSujets.length; i++) {
                int nbArticles = sujets.get(lSujets[i]).intValue();
                if (lSujets[i].getArticles().length != nbArticles) {
                    Article[] articles = lSujets[i].getArticles();
                    Arrays.sort(articles, new ComparateurArticlesDate());
                    if(articles.length>1){
                        if(articles[0].getSource().equalsIgnoreCase(source) &&
                                !(articles[0].getDatePubli().equals(articles[1].getDatePubli()))){
                            primeurs.add(lSujets[i]);
                        }
                    }
                }
            }
            SacArticles[] lPrimeurs = new SacArticles[primeurs.size()];
            primeurs.toArray(lPrimeurs);
            Arrays.sort(lPrimeurs, new ComparateurTitresSacsArticles());

            lasdoProduction = new JList(lProd);
            spasdoProduction.setViewportView(lasdoProduction);
            lasdoDistribution = new JList(crSujets);
            spasdoDistribution.setViewportView(lasdoDistribution);
            lasdoExclus = new JList(lExclusivites);
            spasdoExclus.setViewportView(lasdoExclus);
            lasdoPrimeurs = new JList(lPrimeurs);
            spasdoPrimeurs.setViewportView(lasdoPrimeurs);
            lasdoArticles.setText("Nombre d'articles : " + lProd.length);
            lasdoSujets2.setText("Nombre de sujets : " + sujets.keySet().size());
            lasdoExclus2.setText("     en exclusivité : " + lExclusivites.length);
            lasdoPrimeurs2.setText("     en premier (avant d'autres) : " + lPrimeurs.length);
        }
    }

    private void exportExcelAnalyseParSujet() {
        final JFileChooser jfc = new JFileChooser();
        int choix = jfc.showSaveDialog(this);
        if (choix == JFileChooser.APPROVE_OPTION) {
            jLabel53.setText("Export en cours.");
            new Thread() {

                public void run() {
                    RSSFeedDatabase rfd = null;
                    try {
                        rfd = new RSSFeedDatabase(baseIPRI);
                    } catch (NoBaseException nbe) {
                    }
                    try {
                        FileWriter w = new FileWriter(jfc.getSelectedFile());
                        w.write("Sujet\tNb articles\t% articles\tNb flux\t%produisants");
                        if (rfd != null) {
                            w.write("\tNb catégories\t% catégories");
                        }
                        w.write("\n");
                        w.flush();
                        int nbArticles = 0;
                        Set<String> sSources = new HashSet<String>();
                        Set<String> sCategories = new HashSet<String>();
                        SacArticles[] lSujets = corpus.getSujets();
                        for (int i = 0; i < lSujets.length; i++) {
                            nbArticles += lSujets[i].getArticles().length;
                            for (int j = 0; j < lSujets[i].getArticles().length; j++) {
                                sSources.add(lSujets[i].getArticles()[j].getSource());
                                try {
                                    Tag[] categories = rfd.getTagsOfFeed(rfd.findFeedId(
                                            lSujets[i].getArticles()[j].getSource()),
                                            RSSFeedDatabase.TAGS_CATEGORIE);
                                    if (categories.length > 0) {
                                        sCategories.add(categories[0].getTag());
                                    }
                                } catch (NullPointerException npe) { // pas de base => rfd null
                                } catch (NoBaseException nbe) {
                                }
                            }
                        }
                        int nbSources = sSources.size();
                        int nbCategories = sCategories.size();
                        for (int i = 0; i < lSujets.length; i++) {
                            sSources = new HashSet<String>();
                            sCategories = new HashSet<String>();
                            Article[] articles = lSujets[i].getArticles();
                            for (int j = 0; j < articles.length; j++) {
                                sSources.add(articles[j].getSource());
                                try {
                                    Tag[] categories = rfd.getTagsOfFeed(rfd.findFeedId(
                                            articles[j].getSource()), RSSFeedDatabase.TAGS_CATEGORIE);
                                    if (categories.length > 0) {
                                        sCategories.add(categories[0].getTag());
                                    }
                                } catch (NullPointerException npe) { // pas de base => rfd null
                                } catch (NoBaseException nbe) {
                                }
                            }
                            w.write(lSujets[i].getTitre() + "\t" +
                                    lSujets[i].getArticles().length + "\t" +
                                    (100.0 * lSujets[i].getArticles().length / nbArticles) + "\t" +
                                    sSources.size() + "\t" +
                                    (100.0 * sSources.size() / nbSources));
                            if (rfd != null) {
                                w.write("\t" + sCategories.size() + "\t" +
                                        (100.0 * sCategories.size() / nbCategories));
                            }
                            w.write("\n");
                            w.flush();
                        }
                        w.close();
                        jLabel53.setText("Export terminé.");
                        if (rfd == null) {
                            jLabel53.setText("Export terminé (sans les catégories : base indisponible).");
                        }
                    } catch (IOException ioe) {
                        jLabel53.setText("L'export n'a pas marché : " + ioe.getMessage() + ".");
                    }
                }
            }.start();
        }
    }

    private void exportExcelAnalyseParSource() {
        final JFileChooser jfc = new JFileChooser();
        int choix = jfc.showSaveDialog(this);
        if (choix == JFileChooser.APPROVE_OPTION) {
            jLabel52.setText("Export en cours.");
            new Thread() {

                public void run() {
                    try {
                        FileWriter w = new FileWriter(jfc.getSelectedFile());
                        w.write("Flux\tNb articles\t% articles\tNb sujets\t% sujets\n");
                        w.flush();
                        SacArticles[] lSujets = corpus.getSujets();
                        Map<String, Integer> sArticles = new HashMap<String, Integer>();
                        Map<String, Set<String>> sSujets = new HashMap<String, Set<String>>();
                        int nbArticles = 0;
                        for (int i = 0; i < lSujets.length; i++) {
                            Article[] articles = lSujets[i].getArticles();
                            for (int j = 0; j < articles.length; j++) {
                                nbArticles++;
                                String source = articles[j].getSource();
                                Integer nbA = sArticles.get(source);
                                if(nbA == null){
                                    sArticles.put(source, new Integer(1));
                                } else {
                                    sArticles.put(source, new Integer(nbA.intValue()+1));
                                }
                                Set<String> nbS = sSujets.get(source);
                                if (nbS == null) {
                                    nbS = new HashSet<String>();
                                    nbS.add(lSujets[i].getTitre());
                                    sSujets.put(source, nbS);
                                } else {
                                    nbS.add(lSujets[i].getTitre());
                                }
                            }
                        }
                        Vector<String> listeSources = new Vector<String>(sArticles.keySet());
                        for(int i=0; i<listeSources.size(); i++){
                            String source = listeSources.elementAt(i);
                            w.write(source+"\t"+
                                    sArticles.get(source).intValue()+"\t"+
                                    (100.0*sArticles.get(source).intValue()/nbArticles)+"\t"+
                                    sSujets.get(source).size()+"\t"+
                                    (100.0*sSujets.get(source).size()/lSujets.length)+"\n");
                            w.flush();
                        }
                        jLabel52.setText("Export terminé.");
                    } catch (IOException ioe) {
                        jLabel53.setText("L'export n'a pas marché : " + ioe.getMessage() + ".");
                    }
                }
            }.start();
        }
    }

    private void exporteCaptures() {
        new Thread() {

            @Override
            public void run() {
                try {
                    laseNbSujets.setText("");
                    laseDeroulement1.setText("");
                    laseDeroulement2.setText("");
                    laseDeroulement3.setText("");
                    laseDeroulement4.setText("");
                    laseDeroulement5.setText("");
                    baseCaptures.setEnabled(false);
                    SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yy");
                    RSSFeedDatabase rfd = new RSSFeedDatabase(baseIPRI);
                    try {
                        Date dateD = sdf.parse(taseDateDebut.getText());
                        Date dateF = sdf.parse(taseDateFin.getText());
                        laseDeroulement1.setText("Récupération des articles de la presse nationale française.");
                        SousCorpus sousCorpus = new SousCorpus();
                        Tag[] tags = panelFluxAnalyse.listeTagsAcceptes();
                        sousCorpus.refuseTout(1, 999);
                        for(int i=0; i<tags.length; i++){
                            sousCorpus.accepte(tags[i].getId());
                        }
                        // A la base : presse nationale française
                        /*sousCorpus.accepteTout(101, 108);
                        sousCorpus.refuseTout(201, 224);
                        sousCorpus.accepte(211);
                        sousCorpus.refuseTout(301, 305);
                        sousCorpus.accepte(305);
                        sousCorpus.accepteTout(401, 406);
                        sousCorpus.accepteTout(901, 902);*/
                        RSSItem[] listeArticles = rfd.listeArticlesRSS(dateD, dateF, sousCorpus);
                        laseDeroulement1.setText("Sauvegarde dans la table image_rss_articles.");
                        rfd.saveImageOfAllArticlesDe(dateD, dateF, sousCorpus);
                        laseDeroulement1.setText("Terminé : récupération des articles de la presse nationale française (" +
                                listeArticles.length + " articles).");
                        laseDeroulement2.setText("Export des captures d'écran dans le répertoire export.");
                        int nbExports = 0;
                        try {
                            File export = new File("export");
                            export.mkdir();
                            for (int i = 0; i < listeArticles.length; i++) {
                                File capture = new File("cap/" + listeArticles[i].getId().intValue() + ".png");
                                if (capture.exists()) {
                                    SimpleDateFormat sdf2 = new SimpleDateFormat("HH:mm:ss");
                                    String dateArticle = sdf2.format(listeArticles[i].getPubTime());
                                    dateArticle = dateArticle.replaceAll(":", "-");
                                    String titreArticle = Codecs.toFileName(listeArticles[i].getTitle().trim());
                                    File repImage = new File("export/" +
                                            Codecs.toFileName(listeArticles[i].getNomFluxRSS()));
                                    File image = new File("export/" +
                                            Codecs.toFileName(listeArticles[i].getNomFluxRSS()) + "/" + dateArticle + "_" + titreArticle + ".png");
                                    Out.printInfo("Copie : " + capture.getPath() + " => " + image.getPath());
                                    repImage.mkdir();
                                    image.createNewFile();
                                    nbExports++;
                                    FileInputStream entree = new FileInputStream(capture);
                                    FileOutputStream sortie = new FileOutputStream(image);
                                    byte[] data = new byte[entree.available()];
                                    entree.read(data);
                                    sortie.write(data);
                                    sortie.flush();
                                    entree.close();
                                    sortie.close();
                                }
                            }
                        } catch (IOException ioe) {
                            ioe.printStackTrace();
                            Out.printErreur(ioe.getClass() + " : " + ioe.getMessage());
                        }
                        laseDeroulement2.setText("Terminé : export des captures d'écran dans " +
                                "le répertoire export (" + nbExports + " captures d'écran).");

                    } catch (ParseException pe) {
                        laseNbSujets.setText("Dates invalides");
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                } catch (NoBaseException nbe) {
                    laseNbSujets.setText("Base indisponible.");
                }
                baseCaptures.setEnabled(true);
            }
        }.start();
    }
    private int tpsConfrontation = 1;
    private Timer timerConfrontation = new Timer(1000, new ActionListener() {

        public void actionPerformed(ActionEvent ae) {
            tpsConfrontation--;
            lascStatut.setText("Prochaine capture dans " + tpsConfrontation / 60 + ":" +
                    (tpsConfrontation % 60 < 10 ? "0" : "") + tpsConfrontation % 60);
            if (tpsConfrontation <= 0) {
                tpsConfrontation += 300;
                confrontePageRSS();
            }
        }
    });

    private void lanceConfrontationPageRSS() {
        if (bascConfrontation.isSelected()) {
            tpsConfrontation = 1;
            lascStatut.setText("Prochaine capture dans " + tpsConfrontation / 60 + ":" +
                    (tpsConfrontation % 60 < 10 ? "0" : "") + tpsConfrontation % 60 + ".");
            timerConfrontation.start();
        } else {
            timerConfrontation.stop();
            lascStatut.setText("Pas de capture.");
        }
    }
    private Vector<String> captures = new Vector<String>();

    private void confrontePageRSS() {
        new Thread() {

            public void run() {
                File dir = new File("confrontation");
                dir.mkdir();
                String urlPage = tascPageWeb.getText();
                String urlRSS = tascFluxRSS.getText();
                long time = System.currentTimeMillis();
                SimpleDateFormat sdf = new SimpleDateFormat("HH_mm_ss");
                String stime = sdf.format(new Date(time));
                captures.addElement("Capture lancée à " + stime.replaceAll("_", ":"));
                File f = data.base.Config.getCaptureProgram();
                final Thread t = Thread.currentThread();
                final Thread t2 = new Thread() {

                    @Override
                    public void run() {
                        try {
                            Thread.sleep(40000);
                            t.interrupt();
                        } catch (InterruptedException ie) {
                        }
                    }
                };
                try {
                    time = System.currentTimeMillis();
                    Process p = Runtime.getRuntime().exec(f.getAbsolutePath() + " --url=\"" +
                            urlPage + "\" --out=\"" +
                            dir.getAbsolutePath() + "\\" + stime +
                            "_page.png\" --silent --max-wait=30000");
                    Out.printInfo("Capture lancée : " + urlPage);
                    int exitValue = 0;
                    // Il faut s'assurer que l'on n'est plus interrompu.
                    Thread.interrupted();
                    try {
                        t2.start();
                        exitValue = p.waitFor();
                        t2.interrupt();
                    } catch (InterruptedException ie) {
                        t2.interrupt();
                        p.destroy();
                        throw new Exception("capture trop longue (" + ((System.currentTimeMillis() - time) / 1000) + " secondes).");
                    }
                    if (exitValue != 0) {
                        throw new Exception(f.getAbsolutePath() + ", " + "erreur " + exitValue);
                    }
                    if (new File(dir.getAbsolutePath() + "\\" + stime +
                            "_page.png").exists()) {
                    } else {
                        throw new Exception("pas d'image générée.");
                    }
                } catch (IOException ioe) {
                    Out.printErreur("Capture impossible : " + ioe.getMessage());
                } catch (Exception e) {
                    Out.printErreur("Le programme utilisé pour la capture a échoué : " + e.getMessage());
                }
                try {
                    time = System.currentTimeMillis();
                    Process p = Runtime.getRuntime().exec(f.getAbsolutePath() + " --url=\"" +
                            urlRSS + "\" --out=\"" +
                            dir.getAbsolutePath() + "\\" + stime +
                            "_rss.png\" --silent --max-wait=30000");
                    Out.printInfo("Capture lancée : " + urlRSS);
                    int exitValue = 0;
                    // Il faut s'assurer que l'on n'est plus interrompu.
                    Thread.interrupted();
                    try {
                        t2.start();
                        exitValue = p.waitFor();
                        t2.interrupt();
                    } catch (InterruptedException ie) {
                        t2.interrupt();
                        p.destroy();
                        throw new Exception("capture trop longue (" + ((System.currentTimeMillis() - time) / 1000) + " secondes).");
                    }
                    if (exitValue != 0) {
                        throw new Exception(f.getAbsolutePath() + ", " + "erreur " + exitValue);
                    }
                    if (new File(dir.getAbsolutePath() + "\\" + stime +
                            "_rss.png").exists()) {
                    } else {
                        throw new Exception("pas d'image générée.");
                    }
                } catch (IOException ioe) {
                    Out.printErreur("Capture impossible : " + ioe.getMessage());
                } catch (Exception e) {
                    Out.printErreur("Le programme utilisé pour la capture a échoué : " + e.getMessage());
                }
                lascCaptures = new JList(captures);
                spascCaptures.setViewportView(lascCaptures);
            }
        }.start();
    }

    private void chargerTags(){
        try{
            ManagementDatabase mdb = new ManagementDatabase(baseIPRI);
            data.structures.base.Tag[] listeT = mdb.getTags();
            Arrays.sort(listeT, new ComparateurTags());
            ltListe = new JList(listeT);
            ltListe.addListSelectionListener(new ListSelectionListener() {

                public void valueChanged(ListSelectionEvent lse) {
                    selectionTag();
                }
            });
            ltListe.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
            sptListe.setViewportView(ltListe);
            chargerTagsFlux();
            pfGestion212.remove(cbfgeTag);
            pfGestion212.remove(bfgeAjouterTag);
            cbfgeTag = new JComboBox(listeT);
            pfGestion212.add(cbfgeTag);
            pfGestion212.add(bfgeAjouterTag);
        } catch(NoBaseException nbe){
            jLabel54.setText("Base indisponible.");
            btgeModifier.setEnabled(false);
            btgeSupprimer.setEnabled(false);
            btgnAjouter.setEnabled(false);
        }
    }

    private void selectionTag(){
        try {
            data.structures.base.Tag selection = (data.structures.base.Tag)(ltListe.getSelectedValue());
            ttgeNo.setText(""+selection.getId());
            ttgeNom.setText(selection.getTag());
        } catch(NullPointerException npe){

        }
    }

    private void ajouterTag(){
        int id = Integer.parseInt(ttgnNo.getText());
        String nom = ttgnNom.getText().trim();
        try{
            ManagementDatabase mdb = new ManagementDatabase(baseIPRI);
            mdb.ajouteTag(id, nom);
        } catch(NoBaseException nbe){
            // déjà pris en compte
        }
        chargerTags();
    }

    private void modifierTag(){
        data.structures.base.Tag aModifier;
        try {
            aModifier = (data.structures.base.Tag)(ltListe.getSelectedValue());
        } catch(NullPointerException pe){
            return;
        }
        int id = Integer.parseInt(ttgeNo.getText());
        String nom = ttgeNom.getText().trim();
        try{
            ManagementDatabase mdb = new ManagementDatabase(baseIPRI);
            mdb.modifieTag(aModifier.getId(), id, nom);
        } catch(NoBaseException nbe){
            // déjà pris en compte
        }
        chargerTags();
    }

    private void supprimerTag(){
        Tag aSupprimer;
        try {
            aSupprimer = (Tag)(ltListe.getSelectedValue());
        } catch(NullPointerException pe){
            return;
        }
        try{
            ManagementDatabase mdb = new ManagementDatabase(baseIPRI);
            mdb.supprimeTag(aSupprimer.getId());
        } catch(NoBaseException nbe){
            // déjà pris en compte
        }
        chargerTags();
    }

    private void chargerSources(){
        try{
            ManagementDatabase mdb = new ManagementDatabase(baseIPRI);
            Source[] listeS = mdb.getSources();
            Arrays.sort(listeS, new ComparateurSources());
            lsListe = new JList(listeS);
            lsListe.addListSelectionListener(new ListSelectionListener() {

                public void valueChanged(ListSelectionEvent lse) {
                    selectionSource();
                }
            });
            lsListe.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
            spsListe.setViewportView(lsListe);
            pfGestion24.remove(cbfgnSource);
            cbfgnSource = new JComboBox(listeS);
            cbfgnSource.setMaximumRowCount(20);
            pfGestion24.add(cbfgnSource);
            pfGestion29.remove(cbfgeSource);
            cbfgeSource = new JComboBox(listeS);
            cbfgeSource.setMaximumRowCount(20);
            pfGestion29.add(cbfgeSource);
        } catch(NoBaseException nbe){
            jLabel61.setText("Base indisponible.");
            bsgeModifier.setEnabled(false);
            bsgeSupprimer.setEnabled(false);
            bsgnAjouter.setEnabled(false);
        }
    }

    private void selectionSource(){
        try {
            Source selection = (Source)(lsListe.getSelectedValue());
            tsgeNom.setText(selection.getNom());
            tsgeHomepage.setText(selection.getHomepage());
        } catch(NullPointerException npe){

        }
    }

    private void ajouterSource(){
        String nom = tsgnNom.getText().trim();
        String hp = tsgnHomepage.getText().trim();
        try{
            ManagementDatabase mdb = new ManagementDatabase(baseIPRI);
            mdb.ajouteSource(nom, hp);
        } catch(NoBaseException nbe){
            // déjà pris en compte
        }
        chargerSources();
    }

    private void modifierSource(){
        Source aModifier;
        try {
            aModifier = (Source)(lsListe.getSelectedValue());
        } catch(NullPointerException pe){
            return;
        }
        String nom = tsgeNom.getText().trim();
        String hp = tsgeHomepage.getText().trim();
        try{
            ManagementDatabase mdb = new ManagementDatabase(baseIPRI);
            mdb.modifieSource(aModifier.getId(), nom, hp);
        } catch(NoBaseException nbe){
            // déjà pris en compte
        }
        chargerSources();
    }

    private void supprimerSource(){
        Source aSupprimer;
        try {
            aSupprimer = (Source)(lsListe.getSelectedValue());
        } catch(NullPointerException pe){
            return;
        }
        try{
            ManagementDatabase mdb = new ManagementDatabase(baseIPRI);
            mdb.supprimeSource(aSupprimer.getId());
        } catch(NoBaseException nbe){
            // déjà pris en compte
        }
        chargerSources();
    }

    private void chargerFlux(){
        try{
            ManagementDatabase mdb = new ManagementDatabase(baseIPRI);
            Flux[] listeF = mdb.getFlux();
            Arrays.sort(listeF, new ComparateurFlux());
            lfListe = new JList(listeF);
            lfListe.addListSelectionListener(new ListSelectionListener() {

                public void valueChanged(ListSelectionEvent lse) {
                    selectionFlux();
                }
            });
            lfListe.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
            spfListe.setViewportView(lfListe);
        } catch(NoBaseException nbe){
            /*jLabel61.setText("Base indisponible.");
            bsgeModifier.setEnabled(false);
            bsgeSupprimer.setEnabled(false);
            bsgnAjouter.setEnabled(false);*/
        }
    }

    private void selectionFlux(){
        try {
            ManagementDatabase mdb = new ManagementDatabase(baseIPRI);
            Flux selection = (Flux)(lfListe.getSelectedValue());
            chargerTagsFlux();
            tfgeNom.setText(selection.getNom());
            tfgeUrl.setText(selection.getUrl());
            cbfgeSource.setSelectedItem(mdb.getSourceDuFlux(selection));
            /*tsgeNom.setText(selection.getNom());
            tsgeHomepage.setText(selection.getHomepage());*/
        } catch(NullPointerException npe){

        } catch(NoBaseException nbe){
            // déjà pris en compte
        }
    }

    private void chargerTagsFlux(){
        try {
            ManagementDatabase mdb = new ManagementDatabase(baseIPRI);
            Flux selection = (Flux)(lfListe.getSelectedValue());
            Tag[] tags = mdb.getTagsDuFlux(selection);
            lfTags = new JList(tags);
            spfTags.setViewportView(lfTags);
        } catch(NullPointerException npe){

        } catch(NoBaseException nbe){
            // déjà pris en compte
        }
    }

    private void ajouterFlux(){
        String nom = tfgnNom.getText().trim();
        String url = tfgnUrl.getText().trim();
        Source source = (Source)(cbfgnSource.getSelectedItem());
        try{
            ManagementDatabase mdb = new ManagementDatabase(baseIPRI);
            mdb.ajouteFlux(nom, url, source);
        } catch(NoBaseException nbe){
            // déjà pris en compte
        }
        chargerFlux();
    }

    private void modifierFlux(){
        Flux aModifier;
        try {
            aModifier = (Flux)(lfListe.getSelectedValue());
        } catch(NullPointerException pe){
            return;
        }
        String nom = tfgeNom.getText().trim();
        String url = tfgeUrl.getText().trim();
        Source source = (Source)(cbfgeSource.getSelectedItem());
        try{
            ManagementDatabase mdb = new ManagementDatabase(baseIPRI);
            mdb.modifieFlux(aModifier.getId(), nom, url, source);
        } catch(NoBaseException nbe){
            // déjà pris en compte
        }
        chargerFlux();
    }

    private void supprimerFlux(){
        Flux aSupprimer;
        try {
            aSupprimer = (Flux)(lfListe.getSelectedValue());
        } catch(NullPointerException pe){
            return;
        }
        try{
            ManagementDatabase mdb = new ManagementDatabase(baseIPRI);
            mdb.supprimeFlux(aSupprimer.getId());
        } catch(NoBaseException nbe){
            // déjà pris en compte
        }
        chargerFlux();
    }

    private void ajouterTagFlux(){
        data.structures.base.Tag aAjouter;
        Flux aModifier;
        try {
            aAjouter = (data.structures.base.Tag)(cbfgeTag.getSelectedItem());
            aModifier = (Flux)(lfListe.getSelectedValue());
        } catch(NullPointerException pe){
            return;
        }
        try{
            ManagementDatabase mdb = new ManagementDatabase(baseIPRI);
            mdb.ajouteTagAuFlux(aAjouter, aModifier);
        } catch(NoBaseException nbe){
            // déjà pris en compte
        }
        chargerTagsFlux();
    }

    private void supprimerTagFlux(){
        Object[] aSupprimer;
        Flux aModifier;
        try {
            aSupprimer = lfTags.getSelectedValues();
            aModifier = (Flux)(lfListe.getSelectedValue());
        } catch(NullPointerException pe){
            return;
        }
        try{
            ManagementDatabase mdb = new ManagementDatabase(baseIPRI);
            for(int i=0; i<aSupprimer.length; i++) {
                mdb.supprimeTagDuFlux((data.structures.base.Tag)(aSupprimer[i]), aModifier);
            }
        } catch(NoBaseException nbe){
            // déjà pris en compte
        }
        chargerTagsFlux();
    }

    /*private void nettoyerURLs(){
    new Thread() {
    @Override
    public void run() {
    baseFantome.setText("En cours");
    baseFantome.setEnabled(false);
    RSSFeedDatabase rfd = new RSSFeedDatabase(baseIPRI);
    rfd.nettoieURLs();
    baseFantome.setText("Faire marcher !");
    baseLancer.setEnabled(true);
    }
    }.start();
    }*/
}

class ComparateurTags implements Comparator {
    public int compare(Object o1, Object o2) {
        return ((Tag) o1).getId() - ((Tag) o2).getId();
    }
}

class ComparateurSources implements Comparator {
    public int compare(Object o1, Object o2) {
        return ((Source) o1).getNom().compareToIgnoreCase(((Source) o2).getNom());
    }
}

class ComparateurFlux implements Comparator {
    public int compare(Object o1, Object o2) {
        return ((Flux) o1).getNom().compareToIgnoreCase(((Flux) o2).getNom());
    }
}

class ComparateurIPTC implements Comparator {

    public int compare(Object o1, Object o2) {
        return ((ThemaItem) o1).getConceptName().compareToIgnoreCase(
                ((ThemaItem) o2).getConceptName());
    }
}

class ComparateurIPTC2 implements Comparator {

    public int compare(Object o1, Object o2) {
        return ((LemmaItem) o1).toString().compareToIgnoreCase(
                ((LemmaItem) o2).toString());
    }
}

class ComparateurRSSItemCount implements Comparator {

    public final static int DECROISSANT = -1;
    public final static int CROISSANT = 1;
    private int mode = 1;

    public ComparateurRSSItemCount(int mode) {
        this.mode = mode;
    }

    public int compare(Object o1, Object o2) {
        if (mode == CROISSANT) {
            return ((RSSItemCount) o1).hashCode() - ((RSSItemCount) o2).hashCode();
        } else {
            return ((RSSItemCount) o2).hashCode() - ((RSSItemCount) o1).hashCode();
        }
    }
}

class ComparateurRSSItemCount2 implements Comparator {

    public final static int DECROISSANT = -1;
    public final static int CROISSANT = 1;
    private int mode = 1;

    public ComparateurRSSItemCount2(int mode) {
        this.mode = mode;
    }

    public int compare(Object o1, Object o2) {
        if (mode == CROISSANT) {
            return ((RSSItemCount) o1).getCount() - ((RSSItemCount) o2).getCount();
        } else {
            return ((RSSItemCount) o2).getCount() - ((RSSItemCount) o1).getCount();
        }
    }
}

class ComparateurThemaItems implements Comparator {

    public int compare(Object o1, Object o2) {
        return ((ThemaItem) o2).getConceptID() - ((ThemaItem) o1).getConceptID();
    }
}

class ComparateurString implements Comparator {

    public int compare(Object o1, Object o2) {
        return ((String) o1).compareToIgnoreCase(((String) o2));
    }
}

class ComparateurSujetsBruts implements Comparator {

    public int compare(Object o1, Object o2) {
        return ((SujetBrut) o2).getArticles().length - ((SujetBrut) o1).getArticles().length;
    }
}

class ComparateurSujetsTraites implements Comparator {

    public int compare(Object o1, Object o2) {
        return ((SujetTraite) o2).getArticles().length - ((SujetTraite) o1).getArticles().length;
    }
}

class ComparateurNbArticlesSacsArticles implements Comparator {

    public int compare(Object o1, Object o2) {
        int x = 1000 * (((SacArticles) o2).getArticles().length - ((SacArticles) o1).getArticles().length);
        if (x == 0) {
            x = ((SacArticles) o1).getTitre().compareToIgnoreCase(((SacArticles) o2).getTitre());
        }
        return x;
    }
}

class ComparateurNbArticlesSacsArticles2 implements Comparator {

    public int compare(Object o1, Object o2) {
        int x = 1000 * (((SacArticles) o1).getArticles().length - ((SacArticles) o2).getArticles().length);
        if (x == 0) {
            x = ((SacArticles) o1).getTitre().compareToIgnoreCase(((SacArticles) o2).getTitre());
        }
        return x;
    }
}

class ComparateurNbArticlesDistribution implements Comparator {

    public int compare(Object o1, Object o2) {
        int i1 = Integer.parseInt(o1.toString().split("\\[")[1].split(" ")[0].trim());
        int i2 = Integer.parseInt(o2.toString().split("\\[")[1].split(" ")[0].trim());
        int x = i2 - i1;
        if (x == 0) {
            x = ((String) o1).compareToIgnoreCase(((String) o2));
        }
        return x;
    }
}

class ComparateurTitresSacsArticles implements Comparator {

    public int compare(Object o1, Object o2) {
        return ((SacArticles) o1).getTitre().compareToIgnoreCase(((SacArticles) o2).getTitre());
    }
}

class ComparateurArticles implements Comparator {

    public int compare(Object o1, Object o2) {
        return ((Article) o1).getTitre().compareToIgnoreCase(((Article) o2).getTitre());
    }
}

class ComparateurArticlesDate implements Comparator {

    public int compare(Object o1, Object o2) {
        String date1 = ((Article) o1).getDatePubli();
        String date2 = ((Article) o2).getDatePubli();
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yy HH:mm:ss");
        Date d1 = new Date();
        Date d2 = new Date();
        try {
            d1 = sdf.parse(date1);
            d2 = sdf.parse(date2);
        } catch (ParseException pe) {
        }
        return (int) (d1.getTime() - d2.getTime());
    }
}

class ComparateurURLs implements Comparator {

    public int compare(Object o1, Object o2) {
        String s = (String) o1;
        String t = (String) o2;
        try {
            String[] ss = s.split("/");
            String[] tt = s.split("/");
            String s1 = ss[2];
            String t1 = tt[2];
            String[] ss1 = s1.split("\\.");
            String[] tt1 = t1.split("\\.");
            String s2 = ss1[ss1.length - 2];
            String t2 = ss1[ss1.length - 2];
            String s0 = s2 + s;
            String t0 = t2 + t;
            return s0.compareToIgnoreCase(t0);
        } catch (Exception e) {
            return s.compareToIgnoreCase(t);
        }
    }
}
